/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.widgets.RemoteResourceBrowserWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ILoadDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.ControlRemoteProfilesPreferencePage;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.LTTngProfileViewer;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LoadDialog
extends TitleAreaDialog
implements ILoadDialog {
    public static final String IMPORT_ICON_FILE = "icons/elcl16/import_button.png";
    private Composite fDialogComposite = null;
    private Button fLocalButton = null;
    private Button fRemoteButton = null;
    private Composite fLocalComposite = null;
    private CheckboxTreeViewer fFolderViewer;
    private Button fForceButton = null;
    private RemoteResourceBrowserWidget fFileWidget;
    private IRemoteConnection fConnection = null;
    private List<IFileStore> fLocalFiles = null;
    private List<IFileStore> fRemoteFiles = null;
    private boolean fIsForce = true;

    public LoadDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public List<IFileStore> getRemoteResources() {
        return this.fRemoteFiles;
    }

    @Override
    public List<IFileStore> getLocalResources() {
        return this.fLocalFiles;
    }

    @Override
    public boolean isForce() {
        return this.fIsForce;
    }

    @Override
    public void initialize(IRemoteConnection connection) {
        this.fConnection = connection;
        this.fIsForce = true;
        this.fRemoteFiles = null;
        this.fLocalFiles = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_LoadDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(IMPORT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        this.fDialogComposite.setLayoutData((Object)data);
        this.createSelectionGroup();
        this.createOptionComposite();
        this.fLocalComposite = null;
        this.fFileWidget = null;
        this.createLocalComposite();
        this.setMessage(Messages.TraceControl_SelectProfileText);
        return this.fDialogComposite;
    }

    private void createSelectionGroup() {
        Composite group = new Composite(this.fDialogComposite, 2048);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        this.fLocalButton = new Button(group, 16);
        this.fLocalButton.setText(Messages.TraceControl_LocalButtonText);
        this.fLocalButton.setLayoutData((Object)new GridData(1808));
        this.fLocalButton.setSelection(true);
        this.fRemoteButton = new Button(group, 16);
        this.fRemoteButton.setText(Messages.TraceControl_RemoteButtonText);
        this.fRemoteButton.setLayoutData((Object)new GridData(1808));
        this.fLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LoadDialog.this.fLocalButton.getSelection()) {
                    LoadDialog.this.disposeRemoteComposite();
                    LoadDialog.this.createLocalComposite();
                    LoadDialog.this.fRemoteFiles = null;
                    LoadDialog.this.fDialogComposite.layout();
                    LoadDialog.this.enableLocalButtons();
                }
            }
        });
        this.fRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LoadDialog.this.fRemoteButton.getSelection()) {
                    LoadDialog.this.disposeLocalComposite();
                    LoadDialog.this.createRemoteComposite();
                    LoadDialog.this.fLocalFiles = null;
                    LoadDialog.this.fDialogComposite.layout();
                    LoadDialog.this.enableRemoteButtons();
                }
            }
        });
    }

    private void createLocalComposite() {
        if (this.fLocalComposite == null) {
            this.fLocalComposite = new Composite(this.fDialogComposite, 2048);
            this.fLocalComposite.setLayout((Layout)new GridLayout(2, false));
            this.fLocalComposite.setLayoutData((Object)new GridData(1808));
            this.fFolderViewer = LTTngProfileViewer.createLTTngProfileViewer(this.fLocalComposite, 0);
            this.fFolderViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            this.fFolderViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    LoadDialog.this.enableLocalButtons();
                }
            });
        }
    }

    private void disposeLocalComposite() {
        if (this.fLocalComposite != null) {
            this.fLocalComposite.dispose();
            this.fLocalComposite = null;
        }
    }

    private void createRemoteComposite() {
        if (this.fFileWidget == null) {
            this.fFileWidget = new RemoteResourceBrowserWidget(this.fDialogComposite, 2048, 16);
            this.fFileWidget.setLayoutData((Object)new GridData(1808));
            this.fFileWidget.setInitialPath(".lttng/sessions");
            this.fFileWidget.setConnection(this.fConnection);
            this.fFileWidget.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    LoadDialog.this.enableRemoteButtons();
                }
            });
            this.getButton(0).setEnabled(true);
        }
    }

    private void disposeRemoteComposite() {
        if (this.fFileWidget != null) {
            this.fFileWidget.dispose();
            this.fFileWidget = null;
        }
    }

    private void createOptionComposite() {
        Composite group = new Composite(this.fDialogComposite, 2048);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        this.fForceButton = new Button(group, 32);
        this.fForceButton.setText(Messages.TraceControl_ForceButtonText);
        this.fForceButton.setSelection(true);
    }

    private void enableLocalButtons() {
        Object[] checked = this.fFolderViewer.getCheckedElements();
        boolean enabled = checked != null && checked.length > 0;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    private void enableRemoteButtons() {
        List resources = this.fFileWidget.getResources();
        boolean enabled = resources != null && resources.size() > 0;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    protected void createButtonsForButtonBar(final Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        Button manageButton = this.createButton(parent, 1025, Messages.TraceControl_ManageButtonText, false);
        manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)ControlRemoteProfilesPreferencePage.ID, (String[])new String[]{ControlRemoteProfilesPreferencePage.ID}, null);
                dialog.open();
                if (LoadDialog.this.fLocalComposite != null) {
                    LoadDialog.this.fFolderViewer.setInput((Object)LTTngProfileViewer.getViewerInput());
                    LoadDialog.this.enableLocalButtons();
                }
            }
        });
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        button.setEnabled(false);
    }

    protected void okPressed() {
        this.fIsForce = this.fForceButton.getSelection();
        if (this.fFileWidget != null) {
            this.fRemoteFiles = this.fFileWidget.getResources();
            if (this.fRemoteFiles.size() > 0) {
                super.okPressed();
            }
            return;
        }
        Object[] files = this.fFolderViewer.getCheckedElements();
        ArrayList<IFileStore> stores = new ArrayList<IFileStore>();
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (file instanceof File) {
                stores.add(EFS.getLocalFileSystem().fromLocalFile((File)file));
            }
            ++n2;
        }
        if (stores.size() != 0) {
            this.fLocalFiles = stores;
            super.okPressed();
        }
    }
}

