/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DestroySessionHandler
extends BaseControlViewHandler {
    @NonNull
    private final List<TraceSessionComponent> fSessions = new ArrayList<TraceSessionComponent>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        ArrayList<TraceSessionComponent> tmpSessions = new ArrayList<TraceSessionComponent>();
        this.fLock.lock();
        try {
            tmpSessions = new ArrayList();
            tmpSessions.addAll(this.fSessions);
        }
        finally {
            this.fLock.unlock();
        }
        final ArrayList<TraceSessionComponent> sessions = tmpSessions;
        IConfirmDialog dialog = TraceControlDialogFactory.getInstance().getConfirmDialog();
        if (!dialog.openConfirm(window.getShell(), Messages.TraceControl_DestroyConfirmationTitle, Messages.TraceControl_DestroyConfirmationMessage)) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_DestroySessionJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (TraceSessionComponent session : sessions) {
                        TraceSessionGroup sessionGroup = (TraceSessionGroup)session.getParent();
                        sessionGroup.destroySession(session, monitor);
                    }
                }
                catch (ExecutionException e) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_DestroySessionFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>(0);
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent session;
                if (!(element instanceof TraceSessionComponent) || (session = (TraceSessionComponent)element).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                sessions.add((TraceSessionComponent)element);
            }
        }
        boolean isEnabled = !sessions.isEmpty();
        this.fLock.lock();
        try {
            this.fSessions.clear();
            if (isEnabled) {
                this.fSessions.addAll(sessions);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

