/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TraceChannelPropertySource
extends BasePropertySource {
    public static final String TRACE_CHANNEL_NAME_PROPERTY_ID = "trace.channel.name";
    public static final String TRACE_CHANNEL_STATE_PROPERTY_ID = "trace.channel.state";
    public static final String TRACE_CHANNEL_OVERWRITE_MODE_PROPERTY_ID = "trace.channel.overwrite.mode";
    public static final String TRACE_CHANNEL_SUBBUFFER_SIZE_PROPERTY_ID = "trace.channel.subbuffer.size";
    public static final String TRACE_CHANNEL_NO_SUBBUFFERS_PROPERTY_ID = "trace.channel.no.subbuffers";
    public static final String TRACE_CHANNEL_SWITCH_TIMER_PROPERTY_ID = "trace.channel.switch.timer";
    public static final String TRACE_CHANNEL_READ_TIMER_PROPERTY_ID = "trace.channel.read.timer";
    public static final String TRACE_CHANNEL_OUTPUT_TYPE_PROPERTY_ID = "trace.channel.output.type";
    public static final String TRACE_CHANNEL_TRACE_FILE_COUNT_PROPERTY_ID = "trace.channel.trace.file.count";
    public static final String TRACE_CHANNEL_TRACE_FILE_SIZE_PROPERTY_ID = "trace.channel.trace.file.size";
    public static final String TRACE_CHANNEL_NAME_PROPERTY_NAME = Messages.TraceControl_ChannelNamePropertyName;
    public static final String TRACE_CHANNEL_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    public static final String TRACE_CHANNEL_OVERWRITE_MODE_PROPERTY_NAME = Messages.TraceControl_OverwriteModePropertyName;
    public static final String TRACE_CHANNEL_SUBBUFFER_SIZE_PROPERTY_NAME = Messages.TraceControl_SubBufferSizePropertyName;
    public static final String TRACE_CHANNEL_NO_SUBBUFFERS_PROPERTY_NAME = Messages.TraceControl_NbSubBuffersPropertyName;
    public static final String TRACE_CHANNEL_SWITCH_TIMER_PROPERTY_NAME = Messages.TraceControl_SwitchTimerPropertyName;
    public static final String TRACE_CHANNEL_READ_TIMER_PROPERTY_NAME = Messages.TraceControl_ReadTimerPropertyName;
    public static final String TRACE_CHANNEL_OUTPUT_TYPEPROPERTY_NAME = Messages.TraceControl_OutputTypePropertyName;
    public static final String TRACE_CHANNEL_TRACE_FILE_COUNT_PROPERTY_NAME = Messages.TraceControl_TraceFileCountPropertyName;
    public static final String TRACE_CHANNEL_TRACE_FILE_SIZE_PROPERTY_NAME = Messages.TraceControl_TraceFileSizePropertyName;
    private final TraceChannelComponent fChannel;

    public TraceChannelPropertySource(TraceChannelComponent component) {
        this.fChannel = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ReadOnlyTextPropertyDescriptor> properties = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_NAME_PROPERTY_ID, TRACE_CHANNEL_NAME_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_STATE_PROPERTY_ID, TRACE_CHANNEL_STATE_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_OVERWRITE_MODE_PROPERTY_ID, TRACE_CHANNEL_OVERWRITE_MODE_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_SUBBUFFER_SIZE_PROPERTY_ID, TRACE_CHANNEL_SUBBUFFER_SIZE_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_NO_SUBBUFFERS_PROPERTY_ID, TRACE_CHANNEL_NO_SUBBUFFERS_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_SWITCH_TIMER_PROPERTY_ID, TRACE_CHANNEL_SWITCH_TIMER_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_READ_TIMER_PROPERTY_ID, TRACE_CHANNEL_READ_TIMER_PROPERTY_NAME));
        properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_OUTPUT_TYPE_PROPERTY_ID, TRACE_CHANNEL_OUTPUT_TYPEPROPERTY_NAME));
        if (this.fChannel.getTargetNode().isVersionSupported("2.5.0")) {
            properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_TRACE_FILE_COUNT_PROPERTY_ID, TRACE_CHANNEL_TRACE_FILE_COUNT_PROPERTY_NAME));
            properties.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_CHANNEL_TRACE_FILE_SIZE_PROPERTY_ID, TRACE_CHANNEL_TRACE_FILE_SIZE_PROPERTY_NAME));
        }
        return properties.toArray(new IPropertyDescriptor[0]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_CHANNEL_NAME_PROPERTY_ID.equals(id)) {
            return this.fChannel.getName();
        }
        if (TRACE_CHANNEL_STATE_PROPERTY_ID.equals(id)) {
            return this.fChannel.getState().name();
        }
        if (TRACE_CHANNEL_OVERWRITE_MODE_PROPERTY_ID.equals(id)) {
            return String.valueOf(this.fChannel.isOverwriteMode());
        }
        if (TRACE_CHANNEL_SUBBUFFER_SIZE_PROPERTY_ID.equals(id)) {
            return String.valueOf(this.fChannel.getSubBufferSize());
        }
        if (TRACE_CHANNEL_NO_SUBBUFFERS_PROPERTY_ID.equals(id)) {
            return String.valueOf(this.fChannel.getNumberOfSubBuffers());
        }
        if (TRACE_CHANNEL_SWITCH_TIMER_PROPERTY_ID.equals(id)) {
            return String.valueOf(this.fChannel.getSwitchTimer());
        }
        if (TRACE_CHANNEL_READ_TIMER_PROPERTY_ID.equals(id)) {
            return String.valueOf(this.fChannel.getReadTimer());
        }
        if (TRACE_CHANNEL_OUTPUT_TYPE_PROPERTY_ID.equals(id)) {
            return this.fChannel.getOutputType().getInName();
        }
        if (TRACE_CHANNEL_TRACE_FILE_COUNT_PROPERTY_ID.equals(id)) {
            return this.fChannel.getMaxNumberTraceFiles();
        }
        if (TRACE_CHANNEL_TRACE_FILE_SIZE_PROPERTY_ID.equals(id)) {
            return this.fChannel.getMaxSizeTraceFiles();
        }
        return null;
    }
}

