/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;

public abstract class AbstractScannerExtensionConfiguration
implements IScannerExtensionConfiguration {
    private static final IMacro[] EMPTY_MACRO_ARRAY = new IMacro[0];
    private ArrayList<IMacro> fAddMacroList;
    private IMacro[] fAddMacros;
    private CharArrayIntMap fAddKeywords;
    private CharArrayIntMap fAddPreprocessorKeywords;

    @Override
    public boolean support$InIdentifiers() {
        return false;
    }

    @Override
    public boolean supportAtSignInIdentifiers() {
        return false;
    }

    @Override
    public boolean supportUTFLiterals() {
        return true;
    }

    @Override
    public boolean supportSlashPercentComments() {
        return false;
    }

    @Override
    public char[] supportAdditionalNumericLiteralSuffixes() {
        return null;
    }

    @Override
    public boolean supportMinAndMaxOperators() {
        return false;
    }

    @Override
    public boolean supportRawStringLiterals() {
        return false;
    }

    @Override
    public boolean supportUserDefinedLiterals() {
        return false;
    }

    @Override
    public CharArrayIntMap getAdditionalPreprocessorKeywords() {
        return this.fAddPreprocessorKeywords;
    }

    @Override
    public CharArrayIntMap getAdditionalKeywords() {
        return this.fAddKeywords;
    }

    @Override
    public IMacro[] getAdditionalMacros() {
        if (this.fAddMacros == null) {
            this.fAddMacros = this.fAddMacroList == null ? EMPTY_MACRO_ARRAY : this.fAddMacroList.toArray(new IMacro[this.fAddMacroList.size()]);
        }
        return this.fAddMacros;
    }

    protected void addMacro(String signature, String value) {
        if (this.fAddMacroList == null) {
            this.fAddMacroList = new ArrayList();
        }
        this.fAddMacroList.add(new MacroDefinition(signature.toCharArray(), value.toCharArray()));
        this.fAddMacros = null;
    }

    protected void addPreprocessorKeyword(char[] name, int tokenKind) {
        if (this.fAddPreprocessorKeywords == null) {
            this.fAddPreprocessorKeywords = new CharArrayIntMap(10, -1);
        }
        this.fAddPreprocessorKeywords.put(name, tokenKind);
    }

    protected void addKeyword(char[] name, int tokenKind) {
        if (this.fAddKeywords == null) {
            this.fAddKeywords = new CharArrayIntMap(10, -1);
        }
        this.fAddKeywords.put(name, tokenKind);
    }

    @Deprecated
    protected static IMacro createMacro(String signature, String value) {
        return new MacroDefinition(signature.toCharArray(), value.toCharArray());
    }

    @Deprecated
    protected static IMacro createFunctionStyleMacro(String name, String value, String[] arguments) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('(');
        int i = 0;
        while (i < arguments.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(arguments[i]);
            ++i;
        }
        buf.append(')');
        char[] signature = new char[buf.length()];
        buf.getChars(0, signature.length, signature, 0);
        return new MacroDefinition(signature, value.toCharArray());
    }

    @Override
    @Deprecated
    public boolean initializeMacroValuesTo1() {
        return false;
    }

    protected static class MacroDefinition
    implements IMacro {
        private final char[] fSignature;
        private final char[] fExpansion;

        MacroDefinition(char[] signature, char[] expansion) {
            this.fSignature = signature;
            this.fExpansion = expansion;
        }

        @Override
        public char[] getSignature() {
            return this.fSignature;
        }

        @Override
        public char[] getExpansion() {
            return this.fExpansion;
        }
    }
}

