/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

final class CPPASTAmbiguityResolver
extends ASTVisitor {
    private int fSkipInitializers = 0;
    private int fDeferFunctions = 1;
    private HashSet<IASTDeclaration> fRepopulate = new HashSet();
    private Deque<Deque<IASTNode>> fDeferredNodes = new ArrayDeque<Deque<IASTNode>>();

    public CPPASTAmbiguityResolver() {
        super(false);
        this.includeInactiveNodes = true;
        this.shouldVisitAmbiguousNodes = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitTranslationUnit = true;
    }

    @Override
    public int visit(ASTAmbiguousNode astAmbiguousNode) {
        IASTNode node = astAmbiguousNode.resolveAmbiguity(this);
        if (node instanceof IASTDeclarator) {
            while (node != null) {
                if (node instanceof IASTDeclaration) {
                    this.fRepopulate.add((IASTDeclaration)node);
                } else if (node instanceof IASTParameterDeclaration) {
                    IASTDeclarator dtor;
                    IASTNode parent = node.getParent();
                    if (parent instanceof IASTDeclarator && (dtor = (IASTDeclarator)parent) == ASTQueries.findTypeRelevantDeclarator(dtor) && ASTQueries.findOutermostDeclarator(dtor).getParent() instanceof IASTDeclaration) {
                        this.repopulateScope((IASTParameterDeclaration)node);
                    }
                } else if (!(node instanceof IASTExpression)) {
                    node = node.getParent();
                    continue;
                }
                break;
            }
        } else if (node instanceof IASTDeclaration) {
            this.repopulateScope((IASTDeclaration)node);
        }
        return 1;
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            ++this.fDeferFunctions;
            this.fDeferredNodes.add(new ArrayDeque());
        }
        return 3;
    }

    @Override
    public int leave(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            --this.fDeferFunctions;
            ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
            if (declSpec instanceof CPPASTCompositeTypeSpecifier) {
                ((CPPASTCompositeTypeSpecifier)declSpec).setAmbiguitiesResolved();
            }
            this.processDeferredNodes(this.fDeferredNodes.removeLast());
        }
        return 3;
    }

    @Override
    public int visit(IASTDeclaration decl) {
        if (this.fDeferFunctions > 0 && decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            ICPPASTFunctionDeclarator fdecl = (ICPPASTFunctionDeclarator)fdef.getDeclarator();
            ++this.fSkipInitializers;
            fdecl.accept(this);
            --this.fSkipInitializers;
            fdef.getDeclSpecifier().accept(this);
            IASTTypeId trailingReturnType = fdecl.getTrailingReturnType();
            if (trailingReturnType != null) {
                trailingReturnType.accept(this);
            }
            this.fDeferredNodes.getLast().add(decl);
            return 1;
        }
        return 3;
    }

    @Override
    public int leave(IASTDeclaration declaration) {
        if (this.fRepopulate.remove(declaration)) {
            this.repopulateScope(declaration);
        }
        if (declaration instanceof IASTSimpleDeclaration) {
            ICPPASTElaboratedTypeSpecifier elab;
            ASTNodeProperty prop;
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)declaration;
            IASTName name = null;
            IASTDeclSpecifier declspec = sdecl.getDeclSpecifier();
            if (declspec instanceof IASTCompositeTypeSpecifier) {
                name = ((IASTCompositeTypeSpecifier)declspec).getName().getLastName();
            } else if (declspec instanceof ICPPASTElaboratedTypeSpecifier && sdecl.getDeclarators().length == 0 && ((prop = declaration.getPropertyInParent()) == ICPPASTTemplateDeclaration.OWNED_DECLARATION || prop == ICPPASTTemplateSpecialization.OWNED_DECLARATION) && !(elab = (ICPPASTElaboratedTypeSpecifier)declspec).isFriend()) {
                name = elab.getName().getLastName();
            }
            if (name instanceof ICPPASTTemplateId) {
                name.resolveBinding();
            }
        }
        return 3;
    }

    @Override
    public int visit(IASTInitializer initializer) {
        if (this.fSkipInitializers > 0) {
            return 1;
        }
        return 3;
    }

    @Override
    public int visit(IASTTranslationUnit tu) {
        this.fDeferredNodes.add(new ArrayDeque());
        return 3;
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        this.fDeferFunctions = 0;
        while (!this.fDeferredNodes.isEmpty()) {
            this.processDeferredNodes(this.fDeferredNodes.removeLast());
        }
        return 3;
    }

    private void processDeferredNodes(Deque<IASTNode> deferredNodes) {
        int deferFunctions = this.fDeferFunctions;
        this.fDeferFunctions = 0;
        try {
            while (!deferredNodes.isEmpty()) {
                deferredNodes.removeFirst().accept(this);
            }
        }
        finally {
            this.fDeferFunctions = deferFunctions;
        }
    }

    private void repopulateScope(IASTDeclaration declaration) {
        IScope scope = CPPVisitor.getContainingNonTemplateScope(declaration);
        if (scope instanceof ICPPASTInternalScope) {
            CPPSemantics.populateCache((ICPPASTInternalScope)scope, declaration);
        }
    }

    private void repopulateScope(IASTParameterDeclaration declaration) {
        IScope scope = CPPVisitor.getContainingNonTemplateScope(declaration);
        if (scope instanceof ICPPASTInternalScope) {
            CPPSemantics.populateCache((ICPPASTInternalScope)scope, declaration);
        }
    }

    public void resolvePendingAmbiguities(IASTNode node) {
        Iterator<Deque<IASTNode>> iterator = this.fDeferredNodes.descendingIterator();
        block3: while (iterator.hasNext()) {
            Deque<IASTNode> deferred = iterator.next();
            for (IASTNode deferredNode : deferred) {
                if (deferredNode != node) continue;
                int deferFunctions = this.fDeferFunctions;
                this.fDeferFunctions = 0;
                try {
                    deferredNode.accept(this);
                }
                finally {
                    this.fDeferFunctions = deferFunctions;
                }
                deferred.remove(deferredNode);
                continue block3;
            }
        }
    }
}

