/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTDeleteExpression
extends ASTNode
implements ICPPASTDeleteExpression,
IASTAmbiguityParent {
    private static final ICPPEvaluation EVALUATION = new EvalFixed(CPPSemantics.VOID_TYPE, IASTExpression.ValueCategory.PRVALUE, Value.UNKNOWN);
    private IASTExpression operand;
    private boolean isGlobal;
    private boolean isVectored;
    private IASTImplicitName[] implicitNames;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTDeleteExpression() {
    }

    public CPPASTDeleteExpression(IASTExpression operand) {
        this.setOperand(operand);
    }

    public CPPASTDeleteExpression(CPPASTDeleteExpression from) {
        this.setOperand(from.operand);
    }

    @Override
    public CPPASTDeleteExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDeleteExpression copy(IASTNode.CopyStyle style) {
        CPPASTDeleteExpression copy = new CPPASTDeleteExpression(this.operand == null ? null : this.operand.copy(style));
        copy.isGlobal = this.isGlobal;
        copy.isVectored = this.isVectored;
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getOperand() {
        return this.operand;
    }

    @Override
    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    @Override
    public void setIsGlobal(boolean global) {
        this.assertNotFrozen();
        this.isGlobal = global;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public void setIsVectored(boolean vectored) {
        this.assertNotFrozen();
        this.isVectored = vectored;
    }

    @Override
    public boolean isVectored() {
        return this.isVectored;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction deleteOperator;
            ICPPFunction destructor;
            ArrayList<CPPASTImplicitName> names = new ArrayList<CPPASTImplicitName>();
            if (!this.isVectored && (destructor = CPPSemantics.findImplicitlyCalledDestructor(this)) != null) {
                CPPASTImplicitName destructorName = new CPPASTImplicitName(destructor.getNameCharArray(), (IASTNode)this);
                destructorName.setBinding(destructor);
                destructorName.computeOperatorOffsets(this.operand, false);
                names.add(destructorName);
            }
            if (!this.isGlobal && (deleteOperator = CPPSemantics.findOverloadedOperator(this)) != null && !(deleteOperator instanceof CPPImplicitFunction)) {
                CPPASTImplicitName deleteName = new CPPASTImplicitName(deleteOperator.getNameCharArray(), (IASTNode)this);
                deleteName.setOperator(true);
                deleteName.setBinding(deleteOperator);
                deleteName.computeOperatorOffsets(this.operand, false);
                names.add(deleteName);
            }
            this.implicitNames = names.isEmpty() ? IASTImplicitName.EMPTY_NAME_ARRAY : names.toArray(new IASTImplicitName[names.size()]);
        }
        return this.implicitNames;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames && !CPPASTDeleteExpression.acceptByNodes((IASTNode[])this.getImplicitNames(), (ASTVisitor)action)) {
            return false;
        }
        if (this.operand != null && !this.operand.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTDeleteExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return EVALUATION;
    }

    @Override
    public IType getExpressionType() {
        return CPPSemantics.VOID_TYPE;
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }
}

