/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDecltypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.AttributeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclSpecWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclarationWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclaratorWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ExpressionWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.InitializerWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.MacroExpansionHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NameWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.StatementWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.TemplateParameterWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ASTWriterVisitor
extends ASTVisitor {
    protected final Scribe scribe = new Scribe();
    protected NodeCommentMap commentMap;
    protected ExpressionWriter expWriter;
    protected DeclSpecWriter declSpecWriter;
    protected StatementWriter statementWriter;
    protected DeclaratorWriter declaratorWriter;
    protected DeclarationWriter declarationWriter;
    protected InitializerWriter initializerWriter;
    protected NameWriter nameWriter;
    protected TemplateParameterWriter tempParameterWriter;
    protected AttributeWriter attributeWriter;
    protected MacroExpansionHandler macroHandler;
    private boolean insertLeadingBlankLine;
    private boolean suppressLeadingBlankLine;
    private boolean spaceNeededBeforeName;

    public ASTWriterVisitor() {
        this(new NodeCommentMap());
    }

    public ASTWriterVisitor(NodeCommentMap commentMap) {
        this.shouldVisitArrayModifiers = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitDecltypeSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitNames = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitPointerOperators = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitAttributes = true;
        this.init(commentMap);
        this.commentMap = commentMap;
        this.suppressLeadingBlankLine = true;
    }

    private void init(NodeCommentMap commentMap) {
        this.macroHandler = new MacroExpansionHandler(this.scribe);
        this.statementWriter = new StatementWriter(this.scribe, this, commentMap);
        this.declaratorWriter = new DeclaratorWriter(this.scribe, this, commentMap);
        this.declarationWriter = new DeclarationWriter(this.scribe, this, commentMap);
        this.declSpecWriter = new DeclSpecWriter(this.scribe, this, commentMap);
        this.expWriter = new ExpressionWriter(this.scribe, this, this.macroHandler, commentMap);
        this.initializerWriter = new InitializerWriter(this.scribe, this, commentMap);
        this.nameWriter = new NameWriter(this.scribe, this, commentMap);
        this.tempParameterWriter = new TemplateParameterWriter(this.scribe, this, commentMap);
        this.attributeWriter = new AttributeWriter(this.scribe, this, commentMap);
    }

    public String toString() {
        return this.scribe.toString();
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        for (IASTComment comment : this.commentMap.getFreestandingCommentsForNode(tu)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
        return super.leave(tu);
    }

    private void writeLeadingComments(IASTNode node) {
        for (IASTComment comment : this.getLeadingComments(node)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
    }

    private List<IASTComment> getLeadingComments(IASTNode node) {
        List<IASTComment> leadingComments = this.commentMap.getLeadingCommentsForNode(node);
        IASTNode originalNode = node.getOriginalNode();
        if (originalNode != node) {
            leadingComments.addAll(this.commentMap.getLeadingCommentsForNode(originalNode));
        }
        return leadingComments;
    }

    public void visit(ASTLiteralNode lit) {
        this.insertBlankLineIfNeeded(lit);
        this.scribe.print(lit.getRawSignature());
    }

    @Override
    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
        this.declSpecWriter.writeBaseSpecifiers(baseSpecifier);
        return 1;
    }

    @Override
    public int visit(IASTName name) {
        if (this.spaceNeededBeforeName && name.getSimpleID().length != 0) {
            this.scribe.printSpace();
            this.spaceNeededBeforeName = false;
        }
        this.writeLeadingComments(name);
        if (!this.macroHandler.checkisMacroExpansionNode(name)) {
            this.nameWriter.writeName(name);
        }
        return 1;
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        this.writeLeadingComments(declSpec);
        this.declSpecWriter.writeDelcSpec(declSpec);
        return 1;
    }

    @Override
    public int visit(ICPPASTDecltypeSpecifier decltypeSpec) {
        this.scribe.print("decltype");
        this.scribe.print('(');
        decltypeSpec.getDecltypeExpression().accept(this);
        this.scribe.print(')');
        return 1;
    }

    @Override
    public int visit(IASTExpression expression) {
        this.writeLeadingComments(expression);
        if (!this.macroHandler.checkisMacroExpansionNode(expression)) {
            if (expression instanceof IGNUASTCompoundStatementExpression) {
                IGNUASTCompoundStatementExpression gnuCompStmtExp = (IGNUASTCompoundStatementExpression)expression;
                gnuCompStmtExp.getCompoundStatement().accept(this);
            } else {
                this.expWriter.writeExpression(expression);
            }
        }
        return 1;
    }

    @Override
    public int visit(IASTStatement statement) {
        this.insertBlankLineIfNeeded(statement);
        this.writeLeadingComments(statement);
        try {
            if (this.macroHandler.isStatementWithMixedLocation(statement) && !(statement instanceof IASTCompoundStatement)) {
                int n = this.statementWriter.writeMixedStatement(statement);
                return n;
            }
            if (this.macroHandler.checkisMacroExpansionNode(statement)) {
                return 1;
            }
            int n = this.statementWriter.writeStatement(statement, true);
            return n;
        }
        finally {
            this.setLeadingBlankLineFlags(statement);
        }
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        this.insertBlankLineIfNeeded(declaration);
        this.writeLeadingComments(declaration);
        if (!this.macroHandler.checkisMacroExpansionNode(declaration)) {
            this.declarationWriter.writeDeclaration(declaration);
            this.setLeadingBlankLineFlags(declaration);
        }
        return 1;
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        this.writeLeadingComments(declarator);
        if (!this.macroHandler.checkisMacroExpansionNode(declarator)) {
            this.declaratorWriter.writeDeclarator(declarator);
        }
        return 1;
    }

    @Override
    public int visit(IASTArrayModifier amod) {
        if (!this.macroHandler.checkisMacroExpansionNode(amod)) {
            this.declaratorWriter.writeArrayModifier(amod);
        }
        return 1;
    }

    @Override
    public int visit(IASTInitializer initializer) {
        this.writeLeadingComments(initializer);
        if (!this.macroHandler.checkisMacroExpansionNode(initializer)) {
            this.initializerWriter.writeInitializer(initializer);
        }
        return 1;
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.writeLeadingComments(parameterDeclaration);
        if (!this.macroHandler.checkisMacroExpansionNode(parameterDeclaration)) {
            parameterDeclaration.getDeclSpecifier().accept(this);
            IASTDeclarator declarator = this.getParameterDeclarator(parameterDeclaration);
            this.spaceNeededBeforeName = true;
            declarator.accept(this);
        }
        return 1;
    }

    @Override
    public int visit(IASTPointerOperator pointerOperator) {
        this.writeLeadingComments(pointerOperator);
        if (!this.macroHandler.checkisMacroExpansionNode(pointerOperator)) {
            this.declaratorWriter.writePointerOperator(pointerOperator);
        }
        return 1;
    }

    protected IASTName getParameterName(IASTDeclarator declarator) {
        return declarator.getName();
    }

    protected IASTDeclarator getParameterDeclarator(IASTParameterDeclaration parameterDeclaration) {
        return parameterDeclaration.getDeclarator();
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespace) {
        this.insertBlankLineIfNeeded(namespace);
        this.writeLeadingComments(namespace);
        if (!this.macroHandler.checkisMacroExpansionNode(namespace)) {
            this.declarationWriter.writeDeclaration(namespace);
            this.setLeadingBlankLineFlags(namespace);
        }
        return 1;
    }

    @Override
    public int visit(ICPPASTTemplateParameter parameter) {
        this.writeLeadingComments(parameter);
        if (!this.macroHandler.checkisMacroExpansionNode(parameter)) {
            this.tempParameterWriter.writeTemplateParameter(parameter);
        }
        return 1;
    }

    @Override
    public int visit(IASTAttributeSpecifier specifier) {
        this.attributeWriter.writeAttributeSpecifier(specifier);
        return 1;
    }

    public void cleanCache() {
        this.scribe.cleanCache();
        this.macroHandler.reset();
    }

    private void insertBlankLineIfNeeded(IASTNode node) {
        if (!this.suppressLeadingBlankLine && (this.insertLeadingBlankLine || ASTWriter.requiresLeadingBlankLine(node))) {
            this.scribe.newLine();
        }
        this.insertLeadingBlankLine = false;
        this.suppressLeadingBlankLine = false;
    }

    private void setLeadingBlankLineFlags(IASTNode node) {
        this.insertLeadingBlankLine = ASTWriter.requiresTrailingBlankLine(node);
        this.suppressLeadingBlankLine = ASTWriter.suppressesTrailingBlankLine(node);
    }

    public boolean isSuppressLeadingBlankLine() {
        return this.suppressLeadingBlankLine;
    }

    public void setSuppressLeadingBlankLine(boolean value) {
        this.suppressLeadingBlankLine = value;
    }

    public boolean isSpaceNeededBeforeName() {
        return this.spaceNeededBeforeName;
    }

    public void setSpaceNeededBeforeName(boolean value) {
        this.spaceNeededBeforeName = value;
    }

    public Scribe getScribe() {
        return this.scribe;
    }

    public void newLine() {
        this.scribe.newLine();
    }
}

