/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.Util;

public class CreateUsingOperation
extends CreateElementInTUOperation {
    protected String fUsingName;
    protected boolean fIsDirective;

    public CreateUsingOperation(String usingName, boolean isDirective, ITranslationUnit parentElement) {
        super(parentElement);
        this.fIsDirective = isDirective;
        this.fUsingName = usingName;
    }

    @Override
    protected ICElement generateResultHandle() {
        return this.getTranslationUnit().getUsing(this.fUsingName);
    }

    @Override
    public String getMainTaskName() {
        return "operation.createUsingProgress";
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ITranslationUnit cu = this.getTranslationUnit();
            IUsing[] usings = cu.getUsings();
            if (usings.length > 0) {
                this.createAfter(usings[usings.length - 1]);
                return;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    @Override
    protected String generateElement(ITranslationUnit unit) throws CModelException {
        StringBuffer sb = new StringBuffer();
        sb.append("using ");
        if (this.fIsDirective) {
            sb.append("namespace ");
        }
        sb.append(this.fUsingName);
        sb.append(';');
        sb.append(Util.LINE_SEPARATOR);
        return sb.toString();
    }
}

