/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateParameterMap;
import org.eclipse.core.runtime.CoreException;

abstract class PDOMCPPSpecialization
extends PDOMCPPBinding
implements ICPPSpecialization,
IPDOMOverloader {
    private static final int ARGMAP = 32;
    private static final int SIGNATURE_HASH = 36;
    private static final int SPECIALIZED = 40;
    protected static final int RECORD_SIZE = 44;
    private volatile IBinding fSpecializedCache = null;
    private volatile ICPPTemplateParameterMap fArgMap;

    public PDOMCPPSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPSpecialization spec, IPDOMBinding specialized) throws CoreException {
        super(linkage, parent, spec.getNameCharArray());
        this.getDB().putRecPtr(this.record + 40L, specialized.getRecord());
        if (this instanceof ICPPTemplateInstance) {
            this.fArgMap = spec.getTemplateParameterMap();
            PDOMCPPLinkage pDOMCPPLinkage = linkage;
            pDOMCPPLinkage.getClass();
            pDOMCPPLinkage.new PDOMCPPLinkage.ConfigureInstance(this);
        }
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(spec);
            this.getDB().putInt(this.record + 36L, sigHash != null ? sigHash : 0);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public PDOMCPPSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    public IBinding getSpecializedBinding() {
        if (this.fSpecializedCache == null) {
            try {
                long specializedRec = this.getDB().getRecPtr(this.record + 40L);
                this.fSpecializedCache = this.loadSpecializedBinding(specializedRec);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return this.fSpecializedCache;
    }

    protected IPDOMBinding loadSpecializedBinding(long specializedRec) throws CoreException {
        return (IPDOMBinding)((Object)PDOMNode.load(this.getPDOM(), specializedRec));
    }

    @Override
    @Deprecated
    public ObjectMap getArgumentMap() {
        return CPPTemplates.getArgumentMap(this, this.getTemplateParameterMap());
    }

    @Override
    public ICPPTemplateParameterMap getTemplateParameterMap() {
        if (this.fArgMap == null) {
            try {
                if (this instanceof ICPPTemplateInstance) {
                    this.fArgMap = PDOMCPPTemplateParameterMap.getMap(this, this.getDB().getRecPtr(this.record + 32L));
                } else {
                    IIndexBinding owner = this.getOwner();
                    if (owner instanceof ICPPSpecialization) {
                        this.fArgMap = ((ICPPSpecialization)((Object)owner)).getTemplateParameterMap();
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return this.fArgMap;
    }

    public void storeTemplateParameterMap() {
        try {
            long rec = PDOMCPPTemplateParameterMap.putMap(this, this.fArgMap);
            this.getDB().putRecPtr(this.record + 32L, rec);
            this.fArgMap = null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 36L);
    }
}

