/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTemplateNonTypeParameter
extends PDOMCPPBinding
implements IPDOMMemberOwner,
ICPPTemplateNonTypeParameter,
IPDOMCPPTemplateParameter {
    private static final int TYPE_OFFSET = 32;
    private static final int PARAMETERID = 38;
    private static final int DEFAULTVAL = 42;
    protected static final int RECORD_SIZE = 47;
    private int fCachedParamID = -1;
    private volatile IType fType;

    public PDOMCPPTemplateNonTypeParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateNonTypeParameter param) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putInt(this.record + 38L, param.getParameterID());
    }

    public PDOMCPPTemplateNonTypeParameter(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 47;
    }

    @Override
    public int getNodeType() {
        return 49;
    }

    @Override
    public ICPPTemplateArgument getDefaultValue() {
        IValue val;
        block3: {
            try {
                val = ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 42L);
                if (val != null) break block3;
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return null;
            }
        }
        return new CPPTemplateNonTypeArgument(val, this.getType());
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateNonTypeParameter ntp = (ICPPTemplateNonTypeParameter)newBinding;
            this.updateName(newBinding.getNameCharArray());
            Database db = this.getDB();
            try {
                IType newType = ntp.getType();
                this.setType(linkage, newType);
                this.setDefaultValue(db, ntp);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    @Override
    public void forceDelete(PDOMLinkage linkage) throws CoreException {
        this.getDBName().delete();
        linkage.storeType(this.record + 32L, null);
        linkage.storeValue(this.record + 42L, null);
    }

    @Override
    public short getParameterPosition() {
        return (short)this.getParameterID();
    }

    @Override
    public short getTemplateNestingLevel() {
        this.readParamID();
        return (short)(this.getParameterID() >> 16);
    }

    @Override
    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    @Override
    public int getParameterID() {
        this.readParamID();
        return this.fCachedParamID;
    }

    private void readParamID() {
        if (this.fCachedParamID == -1) {
            try {
                Database db = this.getDB();
                this.fCachedParamID = db.getInt(this.record + 38L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fCachedParamID = Integer.MAX_VALUE;
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException, DOMException {
        linkage.storeType(this.record + 32L, newType);
    }

    @Override
    public void configure(ICPPTemplateParameter param) {
        try {
            if (param instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nonTypeParm = (ICPPTemplateNonTypeParameter)param;
                this.setType((PDOMLinkage)this.getLinkage(), nonTypeParm.getType());
                Database db = this.getDB();
                this.setDefaultValue(db, nonTypeParm);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
    }

    private void setDefaultValue(Database db, ICPPTemplateNonTypeParameter nonTypeParm) throws CoreException {
        IValue sval;
        ICPPTemplateArgument val = nonTypeParm.getDefaultValue();
        if (val != null && (sval = val.getNonTypeValue()) != null) {
            ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 42L, sval);
        }
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            try {
                this.fType = ((PDOMLinkage)this.getLinkage()).loadType(this.record + 32L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return this.fType;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IASTExpression getDefault() {
        return null;
    }
}

