/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class SOM {
    public static final String NL = System.getProperty("line.separator", "\n");
    String filename;
    FileHeader filehdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    Symbol[] symbols;

    protected SOM() {
    }

    public SOM(String filename) throws IOException {
        this(filename, 0L);
    }

    public SOM(String filename, long offset) throws IOException {
        this.filename = filename;
        this.commonSetup(new RandomAccessFile(filename, "r"), offset);
    }

    void commonSetup(RandomAccessFile file, long offset) throws IOException {
        this.startingOffset = offset;
        this.rfile = file;
        try {
            this.filehdr = new FileHeader(this.rfile, this.startingOffset);
        }
        finally {
            this.dispose();
        }
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public Attribute getAttributes() {
        Attribute attrib = new Attribute();
        switch (this.filehdr.system_id) {
            case 523: 
            case 528: 
            case 532: {
                attrib.cpu = "PA_RISC";
                break;
            }
            default: {
                attrib.cpu = "unknown";
            }
        }
        switch (this.filehdr.a_magic) {
            case 260: 
            case 263: 
            case 264: 
            case 267: {
                attrib.type = 1;
                break;
            }
            case 269: 
            case 270: {
                attrib.type = 2;
                break;
            }
            default: {
                attrib.type = 3;
            }
        }
        attrib.isle = false;
        attrib.bDebug = this.filehdr.symbol_location != 0 || this.filehdr.symbol_total != 0;
        return attrib;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long offset = this.startingOffset + (long)this.getFileHeader().symbol_location;
            this.getRandomAccessFile();
            this.rfile.seek(offset);
            int numSymbols = this.getFileHeader().symbol_total;
            ArrayList<Symbol> symList = new ArrayList<Symbol>(numSymbols);
            int i = 0;
            while (i < numSymbols) {
                Symbol v = new Symbol(this.rfile);
                symList.add(v);
                ++i;
            }
            this.symbols = symList.toArray(new Symbol[symList.size()]);
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null) {
            if (this.getFileHeader().symbol_strings_size > 0) {
                this.getRandomAccessFile();
                long offset = this.startingOffset + (long)this.getFileHeader().symbol_strings_location;
                this.rfile.seek(offset);
                this.string_table = new byte[this.getFileHeader().symbol_strings_size];
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            FileHeader header = null;
            header = this.getFileHeader();
            if (header != null) {
                buffer.append(header);
            }
            this.getSymbols();
            int i = 0;
            while (i < this.symbols.length) {
                buffer.append(this.symbols[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static boolean isSOMHeader(byte[] hints) {
        return hints != null && hints[0] == 2 && (hints[1] == 11 || hints[1] == 16 || hints[1] == 20);
    }

    public static Attribute getAttributes(byte[] hints) throws IOException {
        SOM emptyXCoff = new SOM();
        emptyXCoff.filehdr = new FileHeader(hints, false);
        Attribute attribute = emptyXCoff.getAttributes();
        emptyXCoff.dispose();
        return attribute;
    }

    public static Attribute getAttributes(String file) throws IOException {
        SOM xcoff = new SOM(file);
        Attribute attribute = xcoff.getAttributes();
        xcoff.dispose();
        return attribute;
    }

    public static void main(String[] args) {
        try {
            SOM som = new SOM(args[0]);
            System.out.println(som);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Attribute {
        public static final int SOM_TYPE_EXE = 1;
        public static final int SOM_TYPE_SHLIB = 2;
        public static final int SOM_TYPE_OBJ = 3;
        public static final int SOM_TYPE_CORE = 4;
        String cpu;
        int type;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }

    public static class FileHeader {
        public static final int FILHSZ = 128;
        public static final short PA_RISC_10 = 523;
        public static final short PA_RISC_11 = 528;
        public static final short PA_RISC_20 = 532;
        public static final short EXE_SOM_LIB = 260;
        public static final short REL_SOM = 262;
        public static final short PRIV_EXEC_SOM = 263;
        public static final short SHARE_EXEC_SOM = 264;
        public static final short SHARE_DEMAND_LOAD_EXE_SOM = 267;
        public static final short DYN_LOAD_LIB = 269;
        public static final short SHARED_LIB = 270;
        public static final short RELOC_SOM_LIB = 1561;
        public short system_id;
        public short a_magic;
        public int version_id;
        public long file_time_sec;
        public long file_time_nano;
        public int entry_space;
        public int entry_subspace;
        public int entry_offset;
        public int aux_header_location;
        public int aux_header_size;
        public int som_length;
        public int presumed_dp;
        public int space_location;
        public int space_total;
        public int subspace_location;
        public int subspace_total;
        public int loader_fixup_location;
        public int loader_fixup_total;
        public int space_strings_location;
        public int space_strings_size;
        public int init_array_location;
        public int init_array_total;
        public int compiler_location;
        public int compiler_total;
        public int symbol_location;
        public int symbol_total;
        public int fixup_request_location;
        public int fixup_request_total;
        public int symbol_strings_location;
        public int symbol_strings_size;
        public int unloadable_sp_location;
        public int unloadable_sp_size;
        public int checksum;

        public FileHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public FileHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[128];
            file.readFully(hdr);
            this.commonSetup(hdr, false);
        }

        public FileHeader(byte[] hdr, boolean little) throws IOException {
            this.commonSetup(hdr, little);
        }

        public void commonSetup(byte[] hdr, boolean little) throws IOException {
            if (hdr == null || hdr.length < 128) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            if (!SOM.isSOMHeader(hdr)) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notSOM"));
            }
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, little);
            this.system_id = memory.getShort();
            this.a_magic = memory.getShort();
            this.version_id = memory.getInt();
            this.file_time_sec = memory.getInt();
            this.file_time_nano = memory.getInt();
            this.entry_space = memory.getInt();
            this.entry_subspace = memory.getInt();
            this.entry_offset = memory.getInt();
            this.aux_header_location = memory.getInt();
            this.aux_header_size = memory.getInt();
            this.som_length = memory.getInt();
            this.presumed_dp = memory.getInt();
            this.space_location = memory.getInt();
            this.space_total = memory.getInt();
            this.subspace_location = memory.getInt();
            this.subspace_total = memory.getInt();
            this.loader_fixup_location = memory.getInt();
            this.loader_fixup_total = memory.getInt();
            this.space_strings_location = memory.getInt();
            this.space_strings_size = memory.getInt();
            this.init_array_location = memory.getInt();
            this.init_array_total = memory.getInt();
            this.compiler_location = memory.getInt();
            this.compiler_total = memory.getInt();
            this.symbol_location = memory.getInt();
            this.symbol_total = memory.getInt();
            this.fixup_request_location = memory.getInt();
            this.fixup_request_total = memory.getInt();
            this.symbol_strings_location = memory.getInt();
            this.symbol_strings_size = memory.getInt();
            this.unloadable_sp_location = memory.getInt();
            this.unloadable_sp_size = memory.getInt();
            this.checksum = memory.getInt();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("FILE HEADER VALUES").append(NL);
            buffer.append("system_id               = ").append(this.system_id).append(NL);
            buffer.append("a_magic                 = ").append(this.a_magic).append(NL);
            buffer.append("version_id              = ").append(this.version_id).append(NL);
            buffer.append("file_time_sec           = ").append(this.file_time_sec).append(NL);
            buffer.append("file_time_nano          = ").append(this.file_time_nano).append(NL);
            buffer.append("entry_space             = ").append(this.entry_space).append(NL);
            buffer.append("entry_subspace          = ").append(this.entry_subspace).append(NL);
            buffer.append("aux_header_location     = ").append(this.aux_header_location).append(NL);
            buffer.append("aux_header_size         = ").append(this.aux_header_size).append(NL);
            buffer.append("som_length              = ").append(this.som_length).append(NL);
            buffer.append("presumed_dp             = ").append(this.presumed_dp).append(NL);
            buffer.append("space_location          = ").append(this.space_location).append(NL);
            buffer.append("space_total             = ").append(this.space_total).append(NL);
            buffer.append("subspace_location       = ").append(this.subspace_location).append(NL);
            buffer.append("subspace_total          = ").append(this.subspace_total).append(NL);
            buffer.append("loader_fixup_location   = ").append(this.loader_fixup_location).append(NL);
            buffer.append("loader_fixup_total      = ").append(this.loader_fixup_total).append(NL);
            buffer.append("space_strings_location  = ").append(this.space_strings_location).append(NL);
            buffer.append("space_strings_size      = ").append(this.space_strings_size).append(NL);
            buffer.append("init_array_location     = ").append(this.init_array_location).append(NL);
            buffer.append("init_array_total        = ").append(this.init_array_total).append(NL);
            buffer.append("compiler_location       = ").append(this.compiler_location).append(NL);
            buffer.append("compiler_total          = ").append(this.compiler_total).append(NL);
            buffer.append("symbol_location         = ").append(this.symbol_location).append(NL);
            buffer.append("symbol_total            = ").append(this.symbol_total).append(NL);
            buffer.append("fixup_request_location  = ").append(this.fixup_request_location).append(NL);
            buffer.append("fixup_request_total     = ").append(this.fixup_request_total).append(NL);
            buffer.append("symbol_strings_location = ").append(this.symbol_strings_location).append(NL);
            buffer.append("symbol_strings_size     = ").append(this.symbol_strings_size).append(NL);
            buffer.append("unloadable_sp_location  = ").append(this.unloadable_sp_location).append(NL);
            buffer.append("unloadable_sp_size      = ").append(this.unloadable_sp_size).append(NL);
            buffer.append("checksum                = ").append(this.checksum).append(NL);
            return buffer.toString();
        }
    }

    public class Symbol {
        public static final int SYMSZ = 20;
        public static final int B31_MASK = Integer.MIN_VALUE;
        public static final int B30_MASK = 0x40000000;
        public static final int B29_24_MASK = 0x3F000000;
        public static final int B23_20_MASK = 0xF00000;
        public static final int B19_17_MASK = 917504;
        public static final int B16_MASK = 65536;
        public static final int B15_MASK = 32768;
        public static final int B14_MASK = 16384;
        public static final int B13_MASK = 8192;
        public static final int B12_MASK = 4096;
        public static final int B11_10_MASK = 3072;
        public static final int B9_0_MASK = 1023;
        public static final int B23_0_MASK = 0xFFFFFF;
        public static final int B7_0_MASK = 255;
        public static final int NULL = 0;
        public static final int ABSOLUTE = 1;
        public static final int DATA = 2;
        public static final int CODE = 3;
        public static final int PRI_PROG = 4;
        public static final int SEC_PROG = 5;
        public static final int ENTRY = 6;
        public static final int STORAGE = 7;
        public static final int STUB = 8;
        public static final int MODULE = 9;
        public static final int SYM_EXT = 10;
        public static final int ARG_EXT = 11;
        public static final int MILLICODE = 12;
        public static final int PLABEL = 13;
        public static final int OCT_DIS = 14;
        public static final int MILLI_EXT = 15;
        public static final int ST_DATA = 15;
        public static final int UNSAT = 0;
        public static final int EXTERNAL = 1;
        public static final int LOCAL = 2;
        public static final int UNIVERSAL = 3;
        public boolean hidden;
        public boolean secondary_def;
        public int symbol_type;
        public int symbol_scope;
        public int check_level;
        public boolean must_qualify;
        public boolean initially_frozen;
        public boolean memory_resident;
        public boolean is_common;
        public boolean dup_common;
        public int xleast;
        public int arg_reloc;
        public int name_offset;
        public int qualifier_name_offset;
        public boolean has_long_return;
        public boolean no_relocation;
        public int symbol_info;
        public int symbol_value;

        public Symbol(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public Symbol(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] bytes = new byte[20];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, false);
            int word = memory.getInt();
            this.hidden = (word & Integer.MIN_VALUE) != 0;
            this.secondary_def = (word & 0x40000000) != 0;
            this.symbol_type = (word & 0x3F000000) >> 24;
            this.symbol_scope = (word & 0xF00000) >> 20;
            this.check_level = (word & 0xE0000) >> 17;
            this.must_qualify = (word & 0x10000) != 0;
            this.initially_frozen = (word & 0x8000) != 0;
            this.memory_resident = (word & 0x4000) != 0;
            this.is_common = (word & 0x2000) != 0;
            this.dup_common = (word & 0x1000) != 0;
            this.xleast = (word & 0xC00) >> 10;
            this.arg_reloc = word & 0x3FF;
            this.name_offset = memory.getInt();
            this.qualifier_name_offset = memory.getInt();
            word = memory.getInt();
            this.has_long_return = (word & Integer.MIN_VALUE) != 0;
            this.no_relocation = (word & 0x40000000) != 0;
            this.symbol_info = word & 0xFFFFFF;
            this.symbol_value = memory.getInt();
            if (this.check_level >= 1) {
                file.readFully(bytes);
                memory = new ReadMemoryAccess(bytes, false);
                word = memory.getInt();
                int num_args = word & 0xFF;
                if (num_args > 3 && this.check_level >= 3) {
                    int num_descs = (num_args - 3) % 4 == 0 ? (num_args - 3) / 4 : (num_args - 3) / 4 + 1;
                    int i = 0;
                    while (i < num_descs) {
                        file.readFully(bytes);
                        ++i;
                    }
                }
            }
        }

        public String getName(byte[] table) {
            if (this.qualifier_name_offset != 0) {
                byte[] len = new byte[4];
                System.arraycopy(table, this.qualifier_name_offset - 4, len, 0, 4);
                ReadMemoryAccess memory = new ReadMemoryAccess(len, false);
                int length = memory.getInt();
                return new String(table, this.qualifier_name_offset, length);
            }
            if (this.name_offset != 0) {
                byte[] len = new byte[4];
                System.arraycopy(table, this.name_offset - 4, len, 0, 4);
                ReadMemoryAccess memory = new ReadMemoryAccess(len, false);
                int length = memory.getInt();
                return new String(table, this.name_offset, length);
            }
            return "";
        }

        public boolean isFunction() {
            return this.symbol_type == 4 || this.symbol_type == 6 && this.symbol_scope != 2;
        }

        public boolean isVariable() {
            return this.symbol_type == 2 && this.symbol_scope != 2 || this.symbol_type == 7;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SYMBOL TABLE ENTRY").append(NL);
            buffer.append("symbol_name  = ");
            try {
                buffer.append(this.getName(SOM.this.getStringTable())).append(NL);
            }
            catch (IOException e) {
                buffer.append("I/O error");
            }
            buffer.append("symbol_value = ").append(this.symbol_value).append(NL);
            buffer.append("symbol_type  = ").append(this.symbol_type).append(NL);
            buffer.append("symbol_scope = ").append(this.symbol_scope).append(NL);
            return buffer.toString();
        }
    }
}

