/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.AbstractImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbench;

public class ImportTraceWizardPageOptions
extends AbstractImportTraceWizardPage {
    private List fProjects;
    private final Map<String, IProject> fProjectsMap = new LinkedHashMap<String, IProject>();

    public ImportTraceWizardPageOptions(IWorkbench workbench, IStructuredSelection selection) {
        super(workbench, selection);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        IFolder originalFolder = this.getBatchWizard().getTargetFolder();
        IProject proj = null;
        if (originalFolder != null) {
            proj = originalFolder.getProject();
        }
        Composite optionPane = (Composite)this.getControl();
        optionPane.setLayout((Layout)new GridLayout());
        optionPane.setLayoutData((Object)new GridData(16384, 128, true, true));
        this.fProjects = new List(optionPane, 512);
        this.fProjects.setLayoutData((Object)new GridData(4, 4, true, true));
        for (IProject project : TraceUtils.getOpenedTmfProjects()) {
            String name = project.getName();
            this.fProjectsMap.put(name, project);
            this.fProjects.add(name);
        }
        this.fProjects.getSelection();
        this.fProjects.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPageOptions.this.updateWithSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportTraceWizardPageOptions.this.updateWithSelection();
            }
        });
        if (proj != null) {
            this.fProjects.setSelection(this.fProjects.indexOf(proj.getName()));
        } else if (this.fProjects.getItemCount() > 0) {
            this.fProjects.setSelection(0);
            this.updateWithSelection();
        }
        this.setMessage(Messages.SharedSelectProject);
        this.setTitle(Messages.ImportTraceWizardPageOptionsTitle);
    }

    private void updateWithSelection() {
        String[] selection = this.fProjects.getSelection();
        if (selection.length > 0) {
            String listItem = selection[0];
            IFolder folder = this.fProjectsMap.get(listItem).getFolder("Traces");
            this.getBatchWizard().setTraceFolder(folder);
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.SharedSelectProject);
        }
    }
}

