/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConflictHandler;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class TraceValidateAndImportOperation
implements IRunnableWithProgress {
    private static final String TRACE_IMPORT_TEMP_FOLDER = ".traceImport";
    private String fTraceType;
    private IPath fDestinationContainerPath;
    private IPath fBaseSourceContainerPath;
    private boolean fImportFromArchive;
    private int fImportOptionFlags;
    private Shell fShell;
    private TmfTraceFolder fTraceFolderElement;
    private List<TraceFileSystemElement> fSelectedFileSystemElements;
    private IStatus fStatus;
    private ImportConflictHandler fConflictHandler;
    private String fCurrentPath;
    private List<IResource> fImportedResources;

    public TraceValidateAndImportOperation(Shell shell, List<TraceFileSystemElement> traceFileSystemElements, String traceId, IPath baseSourceContainerPath, IPath destinationContainerPath, boolean importFromArchive, int importOptionFlags, TmfTraceFolder traceFolderElement) {
        this.fTraceType = traceId;
        this.fBaseSourceContainerPath = baseSourceContainerPath;
        this.fDestinationContainerPath = destinationContainerPath;
        this.fImportOptionFlags = importOptionFlags;
        this.fImportFromArchive = importFromArchive;
        this.fShell = shell;
        this.fTraceFolderElement = traceFolderElement;
        boolean overwriteExistingResources = (importOptionFlags & 0x10) != 0;
        this.fConflictHandler = overwriteExistingResources ? new ImportConflictHandler(this.fShell, this.fTraceFolderElement, ImportConfirmation.OVERWRITE_ALL) : new ImportConflictHandler(this.fShell, this.fTraceFolderElement, ImportConfirmation.SKIP);
        this.fImportedResources = new ArrayList<IResource>();
        this.fSelectedFileSystemElements = traceFileSystemElements;
    }

    public void run(IProgressMonitor progressMonitor) {
        try {
            SubProgressMonitor monitor;
            List<TraceFileSystemElement> selectedFileSystemElements = this.fSelectedFileSystemElements;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            IFolder destTempFolder = this.fTraceFolderElement.getProject().getResource().getFolder(TRACE_IMPORT_TEMP_FOLDER);
            if (destTempFolder.exists()) {
                monitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 4);
                destTempFolder.delete(true, (IProgressMonitor)monitor);
            }
            monitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 4);
            destTempFolder.create(4096, true, (IProgressMonitor)monitor);
            subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
            String baseSourceLocation = null;
            if (this.fImportFromArchive) {
                SubMonitor archiveMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)2);
                this.extractArchiveContent(selectedFileSystemElements.iterator(), destTempFolder, (IProgressMonitor)archiveMonitor.newChild(1));
                if (!selectedFileSystemElements.isEmpty()) {
                    baseSourceLocation = TraceValidateAndImportOperation.getRootElement(selectedFileSystemElements.get(0)).getSourceLocation();
                    List<TraceFileSystemElement> tempFolderFileSystemElements = TraceValidateAndImportOperation.createElementsForFolder(destTempFolder);
                    this.extractAllArchiveFiles(tempFolderFileSystemElements, destTempFolder, destTempFolder.getLocation(), (IProgressMonitor)archiveMonitor.newChild(1));
                }
            } else {
                SubMonitor directoryMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)2);
                this.importFileSystemElements((IProgressMonitor)directoryMonitor.newChild(1), selectedFileSystemElements);
                this.extractAllArchiveFiles(selectedFileSystemElements, destTempFolder, this.fBaseSourceContainerPath, (IProgressMonitor)directoryMonitor.newChild(1));
                baseSourceLocation = URIUtil.toUnencodedString((URI)this.fBaseSourceContainerPath.toFile().getCanonicalFile().toURI());
            }
            this.fBaseSourceContainerPath = destTempFolder.getLocation();
            List<TraceFileSystemElement> tempFolderFileSystemElements = TraceValidateAndImportOperation.createElementsForFolder(destTempFolder);
            if (!tempFolderFileSystemElements.isEmpty()) {
                this.calculateSourceLocations(tempFolderFileSystemElements, baseSourceLocation);
                this.fImportOptionFlags &= 0xFFFFFFFB;
                SubMonitor importTempMonitor = subMonitor.newChild(1);
                this.importFileSystemElements((IProgressMonitor)importTempMonitor, tempFolderFileSystemElements);
            }
            if (destTempFolder.exists()) {
                destTempFolder.delete(true, progressMonitor);
            }
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception e) {
            String errorMessage = String.valueOf(Messages.ImportTraceWizard_ImportProblem) + ": " + (this.fCurrentPath != null ? this.fCurrentPath : "");
            Activator.getDefault().logError(errorMessage, e);
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", errorMessage, (Throwable)e));
        }
    }

    public List<IResource> getImportedResources() {
        return this.fImportedResources;
    }

    private void importFileSystemElements(IProgressMonitor monitor, List<TraceFileSystemElement> fileSystemElements) throws InterruptedException, TmfTraceImportException, CoreException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fileSystemElements.size());
        ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
        HashMap<String, TraceFileSystemElement> directoryTraces = new HashMap<String, TraceFileSystemElement>();
        while (fileSystemElementsIter.hasNext()) {
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            this.fCurrentPath = null;
            TraceFileSystemElement element = fileSystemElementsIter.next();
            IFileSystemObject fileSystemObject = element.getFileSystemObject();
            String resourcePath = element.getFileSystemObject().getAbsolutePath();
            element.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(resourcePath)));
            this.fCurrentPath = resourcePath;
            SubMonitor sub = subMonitor.newChild(1);
            if (element.isDirectory()) {
                if (directoryTraces.containsKey(resourcePath) || !TraceValidateAndImportOperation.isDirectoryTrace(element)) continue;
                directoryTraces.put(resourcePath, element);
                this.validateAndImportTrace(element, (IProgressMonitor)sub);
                continue;
            }
            TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
            String parentPath = parentElement.getFileSystemObject().getAbsolutePath();
            parentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
            this.fCurrentPath = parentPath;
            if (directoryTraces.containsKey(parentPath)) continue;
            if (TraceValidateAndImportOperation.isDirectoryTrace(parentElement)) {
                directoryTraces.put(parentPath, parentElement);
                this.validateAndImportTrace(parentElement, (IProgressMonitor)sub);
                continue;
            }
            boolean validateFile = true;
            TraceFileSystemElement grandParentElement = (TraceFileSystemElement)parentElement.getParent();
            if (grandParentElement != null) {
                String grandParentPath = grandParentElement.getFileSystemObject().getAbsolutePath();
                grandParentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
                this.fCurrentPath = grandParentPath;
                if (directoryTraces.containsKey(grandParentPath)) {
                    validateFile = false;
                } else if (TraceValidateAndImportOperation.isDirectoryTrace(grandParentElement)) {
                    directoryTraces.put(grandParentPath, grandParentElement);
                    this.validateAndImportTrace(grandParentElement, (IProgressMonitor)sub);
                    validateFile = false;
                }
            }
            if (!validateFile || !fileSystemObject.exists()) continue;
            this.validateAndImportTrace(element, (IProgressMonitor)sub);
        }
    }

    private static List<TraceFileSystemElement> createElementsForFolder(IFolder folder) {
        FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
        IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
        TraceFileSystemElement createRootElement = TraceFileSystemElement.createRootTraceFileElement(rootElement, importStructureProvider);
        LinkedList<TraceFileSystemElement> list = new LinkedList<TraceFileSystemElement>();
        createRootElement.getAllChildren(list);
        return list;
    }

    private void extractAllArchiveFiles(List<TraceFileSystemElement> fileSystemElements, IFolder destFolder, IPath baseSourceContainerPath, IProgressMonitor progressMonitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)fileSystemElements.size());
        ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
        while (fileSystemElementsIter.hasNext()) {
            boolean isArchiveFileElement;
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            SubMonitor elementProgress = subMonitor.newChild(1);
            TraceFileSystemElement element = fileSystemElementsIter.next();
            File archiveFile = (File)element.getFileSystemObject().getRawFileSystemObject();
            boolean bl = isArchiveFileElement = element.getFileSystemObject() instanceof FileFileSystemObject && ArchiveUtil.isArchiveFile(archiveFile);
            if (!isArchiveFileElement) continue;
            elementProgress = SubMonitor.convert((IProgressMonitor)elementProgress, (int)4);
            IPath relativeToSourceContainer = new Path(element.getFileSystemObject().getAbsolutePath()).makeRelativeTo(baseSourceContainerPath);
            IFolder folder = TraceValidateAndImportOperation.safeCreateExtractedFolder(destFolder, relativeToSourceContainer, (IProgressMonitor)elementProgress.newChild(1));
            this.extractArchiveToFolder(archiveFile, folder, (IProgressMonitor)elementProgress.newChild(1));
            IFile fileRes = destFolder.getFile(relativeToSourceContainer);
            fileRes.delete(true, (IProgressMonitor)elementProgress.newChild(1));
            IPath newPath = destFolder.getFullPath().append(relativeToSourceContainer);
            folder.move(newPath, true, (IProgressMonitor)elementProgress.newChild(1));
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath);
            FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
            TraceFileSystemElement newElement = TraceFileSystemElement.createRootTraceFileElement(rootElement, importStructureProvider);
            ArrayList<TraceFileSystemElement> extractedChildren = new ArrayList<TraceFileSystemElement>();
            newElement.getAllChildren(extractedChildren);
            this.extractAllArchiveFiles(extractedChildren, folder, folder.getLocation(), progressMonitor);
        }
    }

    private void extractArchiveToFolder(File sourceFile, IFolder destinationFolder, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> rootObjectAndProvider = ArchiveUtil.getRootObjectAndProvider(sourceFile, this.fShell);
        TraceFileSystemElement rootElement = TraceFileSystemElement.createRootTraceFileElement((IFileSystemObject)rootObjectAndProvider.getFirst(), (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond());
        ArrayList<TraceFileSystemElement> fileSystemElements = new ArrayList<TraceFileSystemElement>();
        rootElement.getAllChildren(fileSystemElements);
        this.extractArchiveContent(fileSystemElements.listIterator(), destinationFolder, progressMonitor);
        ((FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond()).dispose();
    }

    private static IFolder safeCreateExtractedFolder(IFolder destinationFolder, IPath relativeContainerRelativePath, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        String suffix = "";
        int i = 2;
        while (true) {
            IPath fullPath = destinationFolder.getFullPath().append(relativeContainerRelativePath + ".extract" + suffix);
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath);
            if (!folder.exists()) break;
            suffix = "(" + i + ")";
            ++i;
        }
        IFolder extractedFolder = folder;
        subMonitor.worked(1);
        TraceUtils.createFolder(extractedFolder, (IProgressMonitor)subMonitor.newChild(1));
        return extractedFolder;
    }

    private void calculateSourceLocations(List<TraceFileSystemElement> fileSystemElements, String baseSourceLocation) {
        for (TraceFileSystemElement element : fileSystemElements) {
            IPath tempRelative = new Path(element.getFileSystemObject().getAbsolutePath()).makeRelativeTo(this.fBaseSourceContainerPath);
            String sourceLocation = String.valueOf(baseSourceLocation) + tempRelative;
            element.setSourceLocation(sourceLocation);
            TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
            tempRelative = new Path(parentElement.getFileSystemObject().getAbsolutePath()).makeRelativeTo(this.fBaseSourceContainerPath);
            sourceLocation = String.valueOf(baseSourceLocation) + tempRelative + '/';
            parentElement.setSourceLocation(sourceLocation);
        }
    }

    private void extractArchiveContent(Iterator<TraceFileSystemElement> fileSystemElementsIter, IFolder tempFolder, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
        while (fileSystemElementsIter.hasNext()) {
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            TraceFileSystemElement element = fileSystemElementsIter.next();
            if (element.isDirectory()) {
                Object[] array = element.getFiles().getChildren();
                int i = 0;
                while (i < array.length) {
                    subList.add((TraceFileSystemElement)((Object)array[i]));
                    ++i;
                }
            }
            subList.add(element);
        }
        if (subList.isEmpty()) {
            return;
        }
        TraceFileSystemElement root = TraceValidateAndImportOperation.getRootElement((TraceFileSystemElement)((Object)subList.get(0)));
        ImportProvider fileSystemStructureProvider = new ImportProvider();
        IOverwriteQuery myQueryImpl = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        progressMonitor.setTaskName(Messages.ImportTraceWizard_ExtractImportOperationTaskName);
        IPath containerPath = tempFolder.getFullPath();
        ImportOperation operation = new ImportOperation(containerPath, (Object)root, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
        operation.setContext(this.fShell);
        operation.setCreateContainerStructure(true);
        operation.setOverwriteResources(false);
        operation.setVirtualFolders(false);
        operation.run((IProgressMonitor)new SubProgressMonitor(progressMonitor, subList.size(), 4));
    }

    private static TraceFileSystemElement getRootElement(TraceFileSystemElement element) {
        TraceFileSystemElement root = element;
        while (root.getParent() != null) {
            root = (TraceFileSystemElement)root.getParent();
        }
        return root;
    }

    private IPath computeDestinationContainerPath(Path resourcePath) {
        IPath destinationContainerPath = this.fDestinationContainerPath;
        if ((this.fImportOptionFlags & 2) != 0) {
            IPath sourceContainerPath = resourcePath.removeLastSegments(1);
            if (this.fBaseSourceContainerPath.equals((Object)resourcePath)) {
                sourceContainerPath = resourcePath;
            }
            IPath relativeContainerPath = sourceContainerPath.makeRelativeTo(this.fBaseSourceContainerPath);
            destinationContainerPath = this.fDestinationContainerPath.append(relativeContainerPath);
        }
        return destinationContainerPath;
    }

    private void validateAndImportTrace(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws TmfTraceImportException, CoreException, InvocationTargetException, InterruptedException {
        IResource importedResource;
        boolean isArchiveFileElement;
        String path = fileSystemElement.getFileSystemObject().getAbsolutePath();
        TraceTypeHelper traceTypeHelper = null;
        File file = (File)fileSystemElement.getFileSystemObject().getRawFileSystemObject();
        boolean bl = isArchiveFileElement = fileSystemElement.getFileSystemObject() instanceof FileFileSystemObject && ArchiveUtil.isArchiveFile(file);
        if (isArchiveFileElement) {
            return;
        }
        if (this.fTraceType == null) {
            try {
                traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(path, null, null);
            }
            catch (TmfTraceImportException tmfTraceImportException) {
                // empty catch block
            }
            if (traceTypeHelper == null) {
                if ((this.fImportOptionFlags & 8) != 0) {
                    this.importResource(fileSystemElement, monitor);
                }
                return;
            }
        } else {
            boolean isDirectoryTraceType = TmfTraceType.isDirectoryTraceType((String)this.fTraceType);
            if (fileSystemElement.isDirectory() != isDirectoryTraceType) {
                return;
            }
            traceTypeHelper = TmfTraceType.getTraceType((String)this.fTraceType);
            if (traceTypeHelper == null) {
                throw new TmfTraceImportException(Messages.ImportTraceWizard_TraceTypeNotFound);
            }
            if (!traceTypeHelper.validate(path).isOK()) {
                return;
            }
        }
        if ((importedResource = this.importResource(fileSystemElement, monitor)) != null) {
            TmfTraceTypeUIUtils.setTraceType(importedResource, traceTypeHelper);
            this.fImportedResources.add(importedResource);
        }
    }

    private IResource importResource(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        boolean createLinksInWorkspace;
        IPath tracePath = TraceValidateAndImportOperation.getInitialDestinationPath(fileSystemElement);
        String newName = this.fConflictHandler.checkAndHandleNameClash(tracePath, monitor);
        if (newName == null) {
            return null;
        }
        fileSystemElement.setLabel(newName);
        ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
        FileSystemElement parentFolder = fileSystemElement.getParent();
        IPath containerPath = fileSystemElement.getDestinationContainerPath();
        tracePath = containerPath.addTrailingSeparator().append(fileSystemElement.getLabel());
        boolean bl = createLinksInWorkspace = (this.fImportOptionFlags & 4) != 0;
        if (fileSystemElement.isDirectory() && !createLinksInWorkspace) {
            containerPath = tracePath;
            Object[] array = fileSystemElement.getFiles().getChildren();
            int i = 0;
            while (i < array.length) {
                subList.add((TraceFileSystemElement)((Object)array[i]));
                ++i;
            }
            parentFolder = fileSystemElement;
        } else {
            IFileInfo info;
            if (!fileSystemElement.isDirectory() && (info = EFS.getStore((URI)new File(fileSystemElement.getFileSystemObject().getAbsolutePath()).toURI()).fetchInfo()).getLength() == 0L) {
                return null;
            }
            subList.add(fileSystemElement);
        }
        ImportProvider fileSystemStructureProvider = new ImportProvider();
        IOverwriteQuery myQueryImpl = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        monitor.setTaskName(String.valueOf(Messages.ImportTraceWizard_ImportOperationTaskName) + " " + fileSystemElement.getFileSystemObject().getAbsolutePath());
        ImportOperation operation = new ImportOperation(containerPath, (Object)parentFolder, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
        operation.setContext(this.fShell);
        operation.setCreateContainerStructure(false);
        operation.setOverwriteResources(false);
        operation.setCreateLinks(createLinksInWorkspace);
        operation.setVirtualFolders(false);
        operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
        String sourceLocation = fileSystemElement.getSourceLocation();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(tracePath);
        if (sourceLocation != null) {
            resource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        }
        return resource;
    }

    private static boolean isDirectoryTrace(TraceFileSystemElement fileSystemElement) {
        String path = fileSystemElement.getFileSystemObject().getAbsolutePath();
        return TmfTraceType.isDirectoryTrace((String)path);
    }

    private static IPath getInitialDestinationPath(TraceFileSystemElement fileSystemElement) {
        IPath traceFolderPath = fileSystemElement.getDestinationContainerPath();
        return traceFolderPath.append(fileSystemElement.getFileSystemObject().getName());
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    private class ImportProvider
    implements IImportStructureProvider {
        ImportProvider() {
        }

        public String getLabel(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getLabel();
        }

        public List getChildren(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            Object[] array = resource.getFiles().getChildren();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < array.length) {
                list.add(array[i]);
                ++i;
            }
            return list;
        }

        public InputStream getContents(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getContents(resource.getFileSystemObject());
        }

        public String getFullPath(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getFullPath(resource.getFileSystemObject());
        }

        public boolean isFolder(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.isDirectory();
        }
    }
}

