/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.table;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.table.ViewerCompoundComparator;

public class TmfSimpleTableViewer
extends TmfViewer {
    private static final int DEFAULT_COL_WIDTH = 200;
    private final TableViewer fTableViewer;
    private final Map<String, ViewerCompoundComparator> fComparators = new HashMap<String, ViewerCompoundComparator>();
    private int fDirection;
    private int fSelectedColumn;

    public TmfSimpleTableViewer(TableViewer table) {
        super(table.getControl().getParent());
        this.fTableViewer = table;
        this.createColumns();
        Table tableControl = this.fTableViewer.getTable();
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        this.fDirection = 1024;
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.getControl().addMouseListener((MouseListener)new MouseColumnListener());
        this.refresh();
    }

    protected final void createColumn(String name, ColumnLabelProvider provider, ViewerCompoundComparator viewerComparator) {
        if (this.fComparators.containsKey(name)) {
            throw new IllegalArgumentException("Cannot have two columns with the same name");
        }
        TableViewerColumn col = new TableViewerColumn(this.fTableViewer, 0);
        col.setLabelProvider((CellLabelProvider)provider);
        TableColumn column = col.getColumn();
        column.setWidth(200);
        column.setText(name);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new ColumnSorter(column));
        ViewerCompoundComparator comparator = viewerComparator == null ? ViewerCompoundComparator.STRING_COMPARATOR : viewerComparator;
        this.fComparators.put(name, comparator);
    }

    protected void createColumns() {
    }

    private void flipSortDirection() {
        this.fDirection = this.fDirection == 1024 ? 128 : 1024;
    }

    private int getSortDirection() {
        return this.fDirection;
    }

    @Override
    public final Control getControl() {
        return this.fTableViewer.getControl();
    }

    public final TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public final int getColumnIndex() {
        return this.fSelectedColumn;
    }

    @Override
    public final void refresh() {
        this.fTableViewer.refresh();
    }

    private final class ColumnSorter
    extends SelectionAdapter {
        private final TableColumn fColumn;

        private ColumnSorter(TableColumn column) {
            this.fColumn = column;
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = TmfSimpleTableViewer.this.fTableViewer.getTable();
            table.setSortDirection(TmfSimpleTableViewer.this.getSortDirection());
            TableColumn prevSortcolumn = table.getSortColumn();
            if (prevSortcolumn == this.fColumn) {
                TmfSimpleTableViewer.this.flipSortDirection();
            }
            table.setSortColumn(this.fColumn);
            ViewerCompoundComparator comparator = (ViewerCompoundComparator)((Object)TmfSimpleTableViewer.this.fComparators.get(this.fColumn.getText()));
            if (TmfSimpleTableViewer.this.fDirection == 1024) {
                TmfSimpleTableViewer.this.fTableViewer.setComparator((ViewerComparator)comparator);
            } else {
                TmfSimpleTableViewer.this.fTableViewer.setComparator((ViewerComparator)new InvertSorter(comparator));
            }
        }
    }

    private class InvertSorter
    extends ViewerCompoundComparator {
        private final ViewerComparator fViewerComparator;

        public InvertSorter(ViewerComparator vc) {
            this.fViewerComparator = vc;
        }

        @Override
        public int compare(Object e1, Object e2) {
            return -this.fViewerComparator.compare(null, e1, e2);
        }
    }

    private final class MouseColumnListener
    extends MouseAdapter {
        private MouseColumnListener() {
        }

        public void mouseDown(MouseEvent e) {
            ViewerCell cell = TmfSimpleTableViewer.this.fTableViewer.getCell(new Point(e.x, e.y));
            TmfSimpleTableViewer.this.fSelectedColumn = cell != null ? cell.getColumnIndex() : -1;
        }
    }
}

