/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import java.util.Comparator;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.SortSyncMessageComparator;

public class SyncMessage
extends BaseMessage
implements ITimeRange {
    public static final String SYNC_MESS_TAG = "SyncMessage";
    private SyncMessageReturn fMessageReturn;
    private ITmfTimestamp fEventTime = new TmfTimestamp();
    private boolean fHasTimeInfo = false;

    public SyncMessage() {
        this.setColorPrefId("PREF_SYNC_MESS");
    }

    protected void syncLifelinesEventOccurrence() {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null) {
            int newIndex = 0;
            newIndex = this.getStartLifeline().getEventOccurrence() > this.getEndLifeline().getEventOccurrence() ? this.getStartLifeline().getEventOccurrence() : this.getEndLifeline().getEventOccurrence();
            this.getStartLifeline().setCurrentEventOccurrence(newIndex);
            this.getEndLifeline().setCurrentEventOccurrence(newIndex);
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        }
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    @Override
    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        if (this.getEndLifeline() == null) {
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    @Override
    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        if (this.getStartLifeline() == null) {
            this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    @Override
    protected void setEventOccurrence(int occurrence) {
        this.setStartOccurrence(occurrence);
        this.setEndOccurrence(occurrence);
    }

    protected void setMessageReturn(SyncMessageReturn message) {
        this.fMessageReturn = message;
    }

    public SyncMessageReturn getMessageReturn() {
        return this.fMessageReturn;
    }

    public void setTime(ITmfTimestamp time) {
        this.fEventTime = time;
        this.fHasTimeInfo = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEventTime;
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fEventTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.fHasTimeInfo;
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        SDViewPref pref = SDViewPref.getInstance();
        if (!this.isSelected()) {
            context.setBackground(pref.getBackGroundColor(this.getColorPrefId()));
            context.setForeground(pref.getForeGroundColor(this.getColorPrefId()));
        }
        super.draw(context);
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        if (this.getY() > y + height + 10 + Metrics.getMessageFontHeigth()) {
            return false;
        }
        if ((this.getEndLifeline() == null && this.getStartLifeline() != null || this.getEndLifeline() != null && this.getStartLifeline() == null) && x + width > this.getX() + this.getWidth() && x < this.getX() + this.getWidth()) {
            return true;
        }
        return super.isVisible(x, y, width, height);
    }

    @Override
    public Comparator<GraphNode> getComparator() {
        return new SortSyncMessageComparator();
    }

    @Override
    public String getArrayId() {
        return SYNC_MESS_TAG;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getY() > y;
    }
}

