/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.component;

import java.util.concurrent.CountDownLatch;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;

public class TmfEventThread
implements Runnable {
    private final TmfEventProvider fProvider;
    private final ITmfEventRequest fRequest;
    private final ITmfEventRequest.ExecutionType fExecType;
    private final TmfEventThread fThread;
    private volatile CountDownLatch fLatch = new CountDownLatch(1);
    private volatile boolean isCompleted = false;
    private volatile boolean fIsPaused = false;

    public TmfEventThread(TmfEventProvider provider, ITmfEventRequest request) {
        assert (provider != null);
        assert (request != null);
        this.fProvider = provider;
        this.fRequest = request;
        this.fExecType = request.getExecType();
        this.fThread = null;
    }

    public TmfEventThread(TmfEventThread thread) {
        this.fProvider = thread.fProvider;
        this.fRequest = thread.fRequest;
        this.fExecType = thread.fExecType;
        this.fThread = thread;
    }

    public TmfEventThread getThread() {
        return this.fThread;
    }

    public ITmfEventProvider getProvider() {
        return this.fProvider;
    }

    public ITmfEventRequest getRequest() {
        return this.fRequest;
    }

    public ITmfEventRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    public boolean isRunning() {
        return this.fRequest.isRunning() && !this.isPaused();
    }

    public boolean isPaused() {
        return this.fIsPaused;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public void run() {
        TmfCoreTracer.traceRequest(this.fRequest.getRequestId(), "is being serviced by " + this.fProvider.getName());
        if (this.fRequest.isCancelled()) {
            this.isCompleted = true;
            return;
        }
        this.fRequest.start();
        int nbRequested = this.fRequest.getNbRequested();
        int nbRead = 0;
        ITmfContext context = this.fProvider.armRequest(this.fRequest);
        if (context == null) {
            this.isCompleted = true;
            this.fRequest.cancel();
            return;
        }
        try {
            ITmfEvent event = this.fProvider.getNext(context);
            TmfCoreTracer.traceRequest(this.fRequest.getRequestId(), "read first event");
            while (event != null && !this.fProvider.isCompleted(this.fRequest, event, nbRead)) {
                TmfCoreTracer.traceEvent(this.fProvider, this.fRequest, event);
                if (this.fRequest.getDataType().isInstance(event)) {
                    this.fRequest.handleData(event);
                }
                while (this.fIsPaused) {
                    CountDownLatch latch = this.fLatch;
                    latch.await();
                }
                if (++nbRead >= nbRequested) continue;
                event = this.fProvider.getNext(context);
            }
            this.isCompleted = true;
            if (this.fRequest.isCancelled()) {
                this.fRequest.cancel();
            } else {
                this.fRequest.done();
            }
        }
        catch (Exception e) {
            Activator.logError("Error in " + this.fProvider.getName() + " handling " + this.fRequest, e);
            this.isCompleted = true;
            this.fRequest.fail();
        }
        context.dispose();
    }

    public void suspend() {
        this.fIsPaused = true;
        TmfCoreTracer.traceRequest(this.fRequest.getRequestId(), "SUSPENDED");
    }

    public void resume() {
        this.fIsPaused = false;
        CountDownLatch oldLatch = this.fLatch;
        this.fLatch = new CountDownLatch(1);
        oldLatch.countDown();
        TmfCoreTracer.traceRequest(this.fRequest.getRequestId(), "RESUMED");
    }

    public void cancel() {
        if (!this.fRequest.isCompleted()) {
            this.fRequest.cancel();
        }
    }
}

