/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.project.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.project.model.TraceValidationHelper;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;

public final class TmfTraceType {
    public static final String TMF_TRACE_TYPE_ID = "org.eclipse.linuxtools.tmf.core.tracetype";
    public static final String CATEGORY_ELEM = "category";
    public static final String TYPE_ELEM = "type";
    public static final String EXPERIMENT_ELEM = "experiment";
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String CATEGORY_ATTR = "category";
    public static final String TRACE_TYPE_ATTR = "trace_type";
    public static final String EVENT_TYPE_ATTR = "event_type";
    public static final String EXPERIMENT_TYPE_ATTR = "experiment_type";
    public static final String IS_DIR_ATTR = "isDirectory";
    public static final String DEFAULT_EXPERIMENT_TYPE = "org.eclipse.linuxtools.tmf.core.experiment.generic";
    private static final Map<String, IConfigurationElement> TRACE_TYPE_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, IConfigurationElement> TRACE_CATEGORIES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, TraceTypeHelper> TRACE_TYPES = new LinkedHashMap<String, TraceTypeHelper>();

    static {
        TmfTraceType.populateCategoriesAndTraceTypes();
        TmfTraceType.populateCustomTraceTypes();
    }

    private TmfTraceType() {
    }

    public static String getCategoryName(String categoryId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("category") && element.getAttribute(ID_ATTR).equals(categoryId)) {
                return element.getAttribute(NAME_ATTR);
            }
            ++n2;
        }
        return "";
    }

    public static IConfigurationElement[] getTypeElements() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TYPE_ELEM)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return typeElements.toArray(new IConfigurationElement[typeElements.size()]);
    }

    public static Iterable<String> getTraceTypeIDs() {
        return TRACE_TYPES.keySet();
    }

    public static Iterable<TraceTypeHelper> getTraceTypeHelpers() {
        return TRACE_TYPES.values();
    }

    public static String[] getAvailableTraceTypes() {
        return TmfTraceType.getAvailableTraceTypes(null);
    }

    public static String[] getAvailableTraceTypes(Comparator<String> comparator) {
        ArrayList<String> traceTypes = new ArrayList<String>();
        for (TraceTypeHelper tt : TRACE_TYPES.values()) {
            if (tt.isExperimentType()) continue;
            traceTypes.add(tt.getLabel());
        }
        if (comparator == null) {
            Collections.sort(traceTypes);
        } else {
            Collections.sort(traceTypes, comparator);
        }
        return traceTypes.toArray(new String[traceTypes.size()]);
    }

    public static List<String> getCustomTraceTypes() {
        String traceTypeName;
        CustomTraceDefinition def;
        ArrayList<String> traceTypes = new ArrayList<String>();
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeName = def.definitionName;
            traceTypes.add(traceTypeName);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            traceTypeName = ((CustomXmlTraceDefinition)def).definitionName;
            traceTypes.add(traceTypeName);
            ++n2;
        }
        return traceTypes;
    }

    private static void populateCustomTraceTypes() {
        TraceTypeHelper tt;
        String traceTypeId;
        TmfTrace trace;
        CustomTraceDefinition def;
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
            traceTypeId = ((CustomTxtTrace)trace).getTraceTypeId();
            tt = new TraceTypeHelper(traceTypeId, def.categoryName, def.definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            traceTypeId = ((CustomXmlTrace)trace).getTraceTypeId();
            tt = new TraceTypeHelper(traceTypeId, ((CustomXmlTraceDefinition)def).categoryName, ((CustomXmlTraceDefinition)def).definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
    }

    public static void addCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        CustomTraceDefinition def;
        String traceTypeId = null;
        TmfTrace trace = null;
        if (traceClass.equals(CustomTxtTrace.class)) {
            def = CustomTxtTraceDefinition.load(category, definitionName);
            if (def != null) {
                trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
                traceTypeId = trace.getTraceTypeId();
            }
        } else if (traceClass.equals(CustomXmlTrace.class) && (def = CustomXmlTraceDefinition.load(category, definitionName)) != null) {
            trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            traceTypeId = trace.getTraceTypeId();
        }
        if (traceTypeId != null && trace != null) {
            TraceTypeHelper helper = TRACE_TYPES.get(traceTypeId);
            if (helper != null) {
                helper.getTrace().dispose();
            }
            TraceTypeHelper tt = new TraceTypeHelper(traceTypeId, category, definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
        }
    }

    public static void removeCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        TraceTypeHelper helper;
        String traceTypeId = null;
        if (traceClass.equals(CustomTxtTrace.class)) {
            traceTypeId = CustomTxtTrace.buildTraceTypeId(category, definitionName);
        } else if (traceClass.equals(CustomXmlTrace.class)) {
            traceTypeId = CustomXmlTrace.buildTraceTypeId(category, definitionName);
        }
        if (traceTypeId != null && (helper = TRACE_TYPES.remove(traceTypeId)) != null) {
            helper.getTrace().dispose();
        }
    }

    public static TraceTypeHelper getTraceType(String id) {
        return TRACE_TYPES.get(id);
    }

    private static void populateCategoriesAndTraceTypes() {
        if (TRACE_TYPES.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(TYPE_ELEM)) {
                    String traceTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(traceTypeId, ce);
                } else if (elementName.equals("category")) {
                    String categoryId = ce.getAttribute(ID_ATTR);
                    TRACE_CATEGORIES.put(categoryId, ce);
                } else if (elementName.equals(EXPERIMENT_ELEM)) {
                    String experimentTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(experimentTypeId, ce);
                }
                ++n2;
            }
            for (Map.Entry<String, IConfigurationElement> entry : TRACE_TYPE_ATTRIBUTES.entrySet()) {
                IConfigurationElement ce = entry.getValue();
                String category = TmfTraceType.getCategory(ce);
                String attribute = ce.getAttribute(NAME_ATTR);
                ITmfTrace trace = null;
                TraceElementType elementType = TraceElementType.TRACE;
                try {
                    if (ce.getName().equals(TYPE_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE_ATTR);
                    } else if (ce.getName().equals(EXPERIMENT_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(EXPERIMENT_TYPE_ATTR);
                        elementType = TraceElementType.EXPERIMENT;
                    }
                    if (trace == null) break;
                    TmfSignalManager.deregister(trace);
                    String dirString = ce.getAttribute(IS_DIR_ATTR);
                    boolean isDir = Boolean.parseBoolean(dirString);
                    String typeId = entry.getKey();
                    TraceTypeHelper tt = new TraceTypeHelper(typeId, category, attribute, trace, isDir, elementType);
                    TRACE_TYPES.put(typeId, tt);
                }
                catch (CoreException e) {
                    Activator.logError("Unexpected error during populating trace types", e);
                }
            }
        }
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = TRACE_CATEGORIES.get(categoryId)) != null && !category.getName().equals("")) {
            return category.getAttribute(NAME_ATTR);
        }
        return "";
    }

    public static List<String> getTraceCategories() {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String key : TRACE_TYPES.keySet()) {
            String categoryName = TRACE_TYPES.get(key).getCategoryName();
            if (categoryNames.contains(categoryName)) continue;
            categoryNames.add(categoryName);
        }
        return categoryNames;
    }

    public static List<TraceTypeHelper> getTraceTypes(String categoryName) {
        ArrayList<TraceTypeHelper> traceNames = new ArrayList<TraceTypeHelper>();
        for (TraceTypeHelper traceTypeHelper : TRACE_TYPES.values()) {
            String storedCategoryName;
            if (traceTypeHelper.isExperimentType() || !(storedCategoryName = traceTypeHelper.getCategoryName()).equals(categoryName)) continue;
            traceNames.add(traceTypeHelper);
        }
        return traceNames;
    }

    public static boolean validate(String traceTypeName, String fileName) {
        TraceTypeHelper traceTypeHelper;
        return traceTypeName == null || traceTypeName.isEmpty() || (traceTypeHelper = TRACE_TYPES.get(traceTypeName)) != null && traceTypeHelper.validate(fileName).isOK();
    }

    public static boolean validate(TraceValidationHelper traceToValidate) {
        return TmfTraceType.validate(traceToValidate.getTraceType(), traceToValidate.getTraceToScan());
    }

    public static IConfigurationElement getTraceAttributes(String traceType) {
        return TRACE_TYPE_ATTRIBUTES.get(traceType);
    }

    public static String getTraceTypeId(String label) {
        for (Map.Entry<String, TraceTypeHelper> entry : TRACE_TYPES.entrySet()) {
            if (!entry.getValue().getLabel().equals(label)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isDirectoryTrace(String path) {
        Iterable<TraceTypeHelper> traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            if (!traceTypeHelper.isDirectoryTraceType() || traceTypeHelper.validate(path).getSeverity() == 4) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryTraceType(String traceType) {
        if (traceType != null) {
            TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType(traceType);
            if (traceTypeHelper != null) {
                return traceTypeHelper.isDirectoryTraceType();
            }
            return false;
        }
        throw new IllegalArgumentException("Invalid trace type string: " + traceType);
    }

    public static String getTraceTypeId(IResource resource) throws CoreException {
        String traceTypeId = (String)resource.getPersistentProperties().get(TmfCommonConstants.TRACETYPE);
        return TmfTraceType.buildCompatibilityTraceTypeId(traceTypeId);
    }

    public static String buildCompatibilityTraceTypeId(String traceTypeId) {
        if (traceTypeId != null) {
            String newTraceType = CustomTxtTrace.buildCompatibilityTraceTypeId(traceTypeId);
            if (newTraceType.equals(traceTypeId)) {
                newTraceType = CustomXmlTrace.buildCompatibilityTraceTypeId(traceTypeId);
            }
            return newTraceType;
        }
        return traceTypeId;
    }

    public static enum TraceElementType {
        TRACE,
        EXPERIMENT;

    }
}

