/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;

public class SynchronizationBackend {
    private static final int SYNC_FILE_MAGIC_NUMBER = 233615104;
    private static final int FILE_VERSION = 1;
    private static final int HEADER_SIZE = 20;
    private final File fSyncFile;

    public SynchronizationBackend(File syncFile) throws IOException {
        this(syncFile, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SynchronizationBackend(File syncFile, boolean throwErrors) throws IOException {
        this.fSyncFile = syncFile;
        if (syncFile == null) {
            return;
        }
        if (!syncFile.exists()) {
            if (!throwErrors) return;
            throw new IOException("Selected synchronization file does not exist");
        }
        if (syncFile.length() <= 0L) {
            if (!throwErrors) return;
            throw new IOException("Invalid synchronization file selected, target file is empty");
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            FileInputStream fis = new FileInputStream(syncFile);
            try {
                try (FileChannel fc = fis.getChannel();){
                    ByteBuffer buffer = ByteBuffer.allocate(20);
                    buffer.clear();
                    fc.read(buffer);
                    buffer.flip();
                    int res = buffer.getInt();
                    if (res != 233615104) {
                        throw new IOException("Selected file does notlook like a synchronization file");
                    }
                    res = buffer.getInt();
                    if (res != 1) {
                        throw new IOException("Select synchronization file is of an older format. Synchronization will have to be computed again.");
                    }
                    res = buffer.getInt();
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SynchronizationAlgorithm openExistingSync() throws IOException {
        if (this.fSyncFile == null) {
            return null;
        }
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                fis = new FileInputStream(this.fSyncFile);
                try {
                    block24: {
                        fc = fis.getChannel().position(20L);
                        try {
                            block23: {
                                ois = new ObjectInputStream(fis);
                                try {
                                    v0 = (SynchronizationAlgorithm)ois.readObject();
                                    return v0;
                                }
                                finally {
                                    if (ois == null) break block23;
                                    ois.close();
                                }
                            }
                            if (fc == null) break block24;
                        }
                        catch (Throwable var2_5) {
                            if (var1_1 == null) {
                                var1_1 = var2_5;
                            } else if (var1_1 != var2_5) {
                                var1_1.addSuppressed(var2_5);
                            }
                            if (fc == null) throw var1_1;
                            fc.close();
                            throw var1_1;
                        }
                        fc.close();
                    }
                    if (fis != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var2_6) {
                    if (var1_1 == null) {
                        var1_1 = var2_6;
                    } else if (var1_1 != var2_6) {
                        var1_1.addSuppressed(var2_6);
                    }
                    if (fis == null) throw var1_1;
                    fis.close();
                    throw var1_1;
                }
                fis.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var2_7) {
                if (var1_1 == null) {
                    var1_1 = var2_7;
                    throw var1_1;
                }
                if (var1_1 == var2_7) throw var1_1;
                var1_1.addSuppressed(var2_7);
                throw var1_1;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveSync(SynchronizationAlgorithm syncAlgo) throws FileNotFoundException {
        if (this.fSyncFile == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                FileOutputStream fos = new FileOutputStream(this.fSyncFile, false);
                try {
                    try (FileChannel fc = fos.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(20);
                        buffer.clear();
                        fc.position(0L);
                        buffer.putInt(233615104);
                        buffer.putInt(1);
                        buffer.flip();
                        int res = fc.write(buffer);
                        assert (res <= 20);
                        fc.position(20L);
                        Throwable throwable2 = null;
                        Object var9_15 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                            oos.writeObject(syncAlgo);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            Activator.logError("Error saving trace synchronization data", e);
        }
    }
}

