/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public final class TmfTraceUtils {
    private static final int MAX_NB_BINARY_BYTES = 2048;

    private TmfTraceUtils() {
    }

    @Nullable
    public static <T extends IAnalysisModule> T getAnalysisModuleOfClass(ITmfTrace trace, Class<T> moduleClass, String id) {
        Iterable<IAnalysisModule> modules = TmfTraceUtils.getAnalysisModulesOfClass(trace, moduleClass);
        for (IAnalysisModule module : modules) {
            if (!id.equals(module.getId())) continue;
            return (T)module;
        }
        return null;
    }

    public static <T> Iterable<T> getAnalysisModulesOfClass(ITmfTrace trace, Class<T> moduleClass) {
        Iterable<IAnalysisModule> analysisModules = trace.getAnalysisModules();
        HashSet<T> modules = new HashSet<T>();
        for (IAnalysisModule module : analysisModules) {
            if (!moduleClass.isAssignableFrom(module.getClass())) continue;
            modules.add(moduleClass.cast(module));
        }
        return modules;
    }

    @Nullable
    public static <T extends ITmfEventAspect> Object resolveEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Iterable<ITmfEventAspect> aspects = trace.getEventAspects();
        for (ITmfEventAspect aspect : aspects) {
            Object obj;
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || (obj = aspect.resolve(event)) == null) continue;
            return obj;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isText(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                int count = 0;
                int val = bufferedInputStream.read();
                if (count >= 2048) return true;
                if (val >= 0) {
                }
                return true;
            }
            finally {
                if (bufferedInputStream == null) return false;
                bufferedInputStream.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

