/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.osgi.util.NLS;

public final class OpControlErrorHandler {
    private static OpControlErrorHandler singleton = new OpControlErrorHandler();
    private String errorFilePath = String.valueOf(OprofileCorePlugin.getDefault().getPluginLocation()) + "op_error_key";
    private Map<String, String> errorMap = new HashMap<String, String>();

    private OpControlErrorHandler() {
    }

    public static OpControlErrorHandler getInstance() {
        return singleton;
    }

    public OpcontrolException handleError(String stdout, String stderr) {
        String type = "";
        String fullErr = "";
        IRemoteFileProxy proxy = null;
        if (!stderr.trim().equals("")) {
            fullErr = stderr;
            type = "process.log.stderr";
        } else if (!stdout.trim().equals("")) {
            fullErr = stdout;
            type = "process.log.stdout";
        } else {
            return new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolNonZeroExitCode", null));
        }
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = proxy.getResource(this.errorFilePath);
            InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
            String line = "";
            BufferedReader buff = new BufferedReader(new InputStreamReader(is));
            while ((line = buff.readLine()) != null) {
                String[] parts = line.split("=");
                this.errorMap.put(parts[0], parts[1]);
            }
            buff.close();
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        String error = null;
        for (String key : this.errorMap.keySet()) {
            if (stderr.contains(key)) {
                fullErr = stderr;
                type = "process.log.stderr";
                error = this.errorMap.get(key);
                break;
            }
            if (!stdout.contains(key)) continue;
            fullErr = stdout;
            type = "process.log.stdout";
            error = this.errorMap.get(key);
            break;
        }
        OprofileCorePlugin.log(4, NLS.bind((String)OprofileProperties.getString(type), (Object)"opcontrol", (Object)fullErr));
        if (error != null) {
            return new OpcontrolException(OprofileCorePlugin.createErrorStatus(error, null));
        }
        return new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolNonZeroExitCodeExtraInfo", null));
    }
}

