/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;

public class OpModelSession {
    private static final String DEFAULT_SESSION_STRING = "current";
    private String name;
    private String printTabs = "";
    private OpModelEvent[] events;

    public OpModelSession(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OpModelEvent[] getEvents() {
        return this.events;
    }

    public void setEvents(OpModelEvent[] events) {
        this.events = events;
    }

    public boolean isDefaultSession() {
        return this.name.equals(DEFAULT_SESSION_STRING);
    }

    public void refreshModel() {
        if (this.events != null) {
            int i = 0;
            while (i < this.events.length) {
                this.events[i].refreshModel();
                ++i;
            }
        }
    }

    public String toString(String tabs) {
        this.printTabs = tabs;
        String s = this.toString();
        this.printTabs = "";
        return s;
    }

    public String toString() {
        String s = String.valueOf(this.name) + "\n";
        if (this.events != null) {
            int i = 0;
            while (i < this.events.length) {
                s = String.valueOf(s) + this.printTabs + "Event: ";
                s = String.valueOf(s) + this.events[i].toString(String.valueOf(this.printTabs) + "\t");
                ++i;
            }
        }
        return s;
    }
}

