/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.CachegrindParser;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.CachegrindViewPart;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.Messages;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindOutput;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.osgi.framework.Version;

public class CachegrindLaunchDelegate
implements IValgrindLaunchDelegate {
    protected static final String OUT_PREFIX = "cachegrind_";
    protected static final String OUT_FILE = "cachegrind_%p.txt";
    protected static final FileFilter CACHEGRIND_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(CachegrindLaunchDelegate.OUT_PREFIX);
        }
    };
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private static final String NO = "no";
    private static final String YES = "yes";
    private CachegrindOutput[] outputs;

    public void handleLaunch(ILaunchConfiguration config, ILaunch launch, IPath logDir, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask(Messages.getString("CachegrindLaunchDelegate.Parsing_Cachegrind_Output"), 3);
                File[] cachegrindOutputs = logDir.toFile().listFiles(CACHEGRIND_FILTER);
                if (cachegrindOutputs.length > 0) {
                    this.parseOutput(cachegrindOutputs, monitor);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort(Messages.getString("CachegrindLaunchDelegate.Error_parsing_output"), e, 150);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void parseOutput(File[] cachegrindOutputs, IProgressMonitor monitor) throws IOException {
        this.outputs = new CachegrindOutput[cachegrindOutputs.length];
        int i = 0;
        while (i < cachegrindOutputs.length) {
            this.outputs[i] = new CachegrindOutput();
            CachegrindParser.getParser().parse(this.outputs[i], cachegrindOutputs[i]);
            ++i;
        }
        monitor.worked(2);
    }

    public String[] getCommandArray(ILaunchConfiguration config, Version ver, IPath logDir) throws CoreException {
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("--cachegrind-out-file=" + logDir.append(OUT_FILE).toOSString());
        opts.add("--cache-sim=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.CACHE_SIM", true) ? YES : NO));
        opts.add("--branch-sim=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.BRANCH_SIM", false) ? YES : NO));
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1", false)) {
            opts.add("--I1=" + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_SIZE", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_ASSOC", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_LSIZE", 0));
        }
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1", false)) {
            opts.add("--D1=" + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_SIZE", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_ASSOC", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_LSIZE", 0));
        }
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2", false)) {
            opts.add("--L2=" + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_SIZE", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_ASSOC", 0) + COMMA + config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_LSIZE", 0));
        }
        return opts.toArray(new String[opts.size()]);
    }

    public void initializeView(IValgrindToolView view, String contentDescription, IProgressMonitor monitor) throws CoreException {
        if (this.outputs != null && view instanceof CachegrindViewPart) {
            ((CachegrindViewPart)view).setOutputs(this.outputs);
        }
        monitor.worked(1);
    }

    private void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.linuxtools.valgrind.cachegrind", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.cachegrind", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.linuxtools.valgrind.cachegrind", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }
}

