/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.autotools.ui.LocationAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;

class ResourceLookupTree
implements IResourceChangeListener,
IResourceDeltaVisitor,
IResourceProxyVisitor {
    private static final int UNREF_DELAY = 600000;
    private static final boolean VISIT_CHILDREN = true;
    private static final boolean SKIP_CHILDREN = false;
    private static final IFile[] NO_FILES = new IFile[0];
    private static final int TRIGGER_RECALC = 2408448;
    private final Object fLock = new Object();
    private final Job fUnrefJob;
    private SoftReference<Map<Integer, Object>> fNodeMapRef;
    private Map<Integer, Object> fNodeMap;
    private final Map<String, Extensions> fFileExtensions;
    private Extensions fCDTProjectExtensions;
    private Extensions fDefaultExtensions;
    private Extensions fCurrentExtensions;
    private Node fRootNode = new Node(null, CharArrayUtils.EMPTY, false, false){};
    private boolean fNeedCleanup;
    private Node fLastFolderNode;

    public ResourceLookupTree() {
        this.fFileExtensions = new HashMap<String, Extensions>();
        this.fUnrefJob = new Job("Timer"){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceLookupTree.this.unrefNodeMap();
                return Status.OK_STATUS;
            }
        };
        this.fUnrefJob.setSystem(true);
    }

    public void startup() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Object object = this.fLock;
        synchronized (object) {
            this.fNodeMap = null;
            this.fNodeMapRef = null;
            this.fFileExtensions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        Object object = this.fLock;
        synchronized (object) {
            block17: {
                if (this.fNodeMapRef == null) {
                    return;
                }
                boolean unsetMap = false;
                if (this.fNodeMap == null) {
                    this.fNodeMap = this.fNodeMapRef.get();
                    if (this.fNodeMap == null) {
                        return;
                    }
                    unsetMap = true;
                }
                try {
                    try {
                        delta.accept((IResourceDeltaVisitor)this);
                    }
                    catch (CoreException e) {
                        AutotoolsUIPlugin.log(e);
                        if (this.fNeedCleanup) {
                            this.cleanup();
                        }
                        this.fCurrentExtensions = null;
                        this.fNeedCleanup = false;
                        if (unsetMap) {
                            this.fNodeMap = null;
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (this.fNeedCleanup) {
                        this.cleanup();
                    }
                    this.fCurrentExtensions = null;
                    this.fNeedCleanup = false;
                    if (unsetMap) {
                        this.fNodeMap = null;
                    }
                    throw throwable;
                }
                if (this.fNeedCleanup) {
                    this.cleanup();
                }
                this.fCurrentExtensions = null;
                this.fNeedCleanup = false;
                if (unsetMap) {
                    this.fNodeMap = null;
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        assert (Thread.holdsLock(this.fLock));
        IResource res = delta.getResource();
        if (res instanceof IWorkspaceRoot) {
            return true;
        }
        if (res instanceof IProject) {
            String name = res.getName();
            Extensions exts = this.fFileExtensions.get(name);
            if (exts == null) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: 
                case 2: {
                    this.fFileExtensions.remove(name);
                    this.remove(res);
                    return false;
                }
                case 4: {
                    if ((delta.getFlags() & 0x2CC000) == 0) break;
                    this.fFileExtensions.remove(name);
                    this.remove(res);
                    return false;
                }
            }
            this.fCurrentExtensions = exts;
            return true;
        }
        switch (delta.getKind()) {
            case 1: {
                this.add(res);
                return false;
            }
            case 4: {
                if ((delta.getFlags() & 0x24C000) != 0) {
                    this.remove(res);
                    this.add(res);
                    return false;
                }
                return true;
            }
            case 2: {
                this.remove(res);
                return false;
            }
        }
        return true;
    }

    private void add(IResource res) {
        assert (Thread.holdsLock(this.fLock));
        if (res instanceof IFile) {
            String resName = res.getName();
            String linkedName = null;
            if (res.isLinked()) {
                URI uri = res.getLocationURI();
                if (uri != null && (linkedName = LocationAdapter.URI.extractName(uri)).length() > 0 && this.fCurrentExtensions.isRelevant(linkedName)) {
                    if (linkedName.equals(resName)) {
                        this.createFileNode(res.getFullPath(), null);
                    } else {
                        this.createFileNode(res.getFullPath(), linkedName);
                    }
                }
            } else if (this.fCurrentExtensions.isRelevant(resName)) {
                this.createFileNode(res.getFullPath(), null);
            }
        } else {
            try {
                res.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException e) {
                AutotoolsUIPlugin.log(e);
            }
        }
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        if (proxy.getType() == 1 && this.fCurrentExtensions.isRelevant(proxy.getName())) {
            if (proxy.isLinked()) {
                IResource res = proxy.requestResource();
                if (res instanceof IFile) {
                    this.add(res);
                }
                return true;
            }
            this.createFileNode(proxy.requestFullPath(), null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unrefNodeMap() {
        Object object = this.fLock;
        synchronized (object) {
            this.fNodeMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateNodeMapCollection() {
        Object object = this.fLock;
        synchronized (object) {
            this.fNodeMap = null;
            this.fNodeMapRef = new SoftReference<Object>(null);
        }
    }

    private void initializeProjects(IProject[] projects) {
        assert (Thread.holdsLock(this.fLock));
        if (this.fNodeMap == null) {
            if (this.fNodeMapRef != null) {
                this.fNodeMap = this.fNodeMapRef.get();
            }
            if (this.fNodeMap == null) {
                this.fFileExtensions.clear();
                this.fNodeMap = new HashMap<Integer, Object>();
                this.fNodeMapRef = new SoftReference<Map<Integer, Object>>(this.fNodeMap);
            }
        }
        this.fUnrefJob.cancel();
        this.fUnrefJob.schedule(600000L);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && !this.fFileExtensions.containsKey(project.getName())) {
                Extensions ext = this.fDefaultExtensions;
                try {
                    if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                        ext = this.fCDTProjectExtensions;
                    }
                }
                catch (CoreException e) {
                    AutotoolsUIPlugin.log(e);
                }
                this.fCurrentExtensions = ext;
                this.add((IResource)project);
                this.fFileExtensions.put(project.getName(), ext);
                this.fCurrentExtensions = null;
            }
            ++n2;
        }
    }

    private void initFileExtensions() {
        if (this.fDefaultExtensions == null) {
            IContentType basedOn;
            IContentType ctt;
            HashSet<String> cdtContentTypes = new HashSet<String>();
            String[] registeredContentTypes = CoreModel.getRegistedContentTypeIds();
            cdtContentTypes.addAll(Arrays.asList(registeredContentTypes));
            IContentTypeManager ctm = Platform.getContentTypeManager();
            IContentType[] ctts = ctm.getAllContentTypes();
            HashSet<String> result = new HashSet<String>();
            IContentType[] iContentTypeArray = ctts;
            int n = ctts.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    basedOn = ctt = iContentTypeArray[n2];
                    while (basedOn != null) {
                        if (!cdtContentTypes.contains(basedOn.getId())) {
                            basedOn = basedOn.getBaseType();
                            continue;
                        }
                        break block7;
                    }
                    this.addFileSpecs(ctt, result);
                }
                ++n2;
            }
            this.fCDTProjectExtensions = new Extensions(result, true);
            result = new HashSet();
            iContentTypeArray = ctts;
            n = ctts.length;
            n2 = 0;
            while (n2 < n) {
                basedOn = ctt = iContentTypeArray[n2];
                while (basedOn != null) {
                    if (cdtContentTypes.contains(basedOn.getId())) {
                        this.addFileSpecs(ctt, result);
                        break;
                    }
                    basedOn = basedOn.getBaseType();
                }
                ++n2;
            }
            this.fDefaultExtensions = new Extensions(result, false);
        }
    }

    private void addFileSpecs(IContentType ctt, Set<String> result) {
        String[] fspecs;
        String[] stringArray = fspecs = ctt.getFileSpecs(8);
        int n = fspecs.length;
        int n2 = 0;
        while (n2 < n) {
            String fspec = stringArray[n2];
            result.add(fspec.toUpperCase());
            ++n2;
        }
    }

    private void createFileNode(IPath fullPath, String fileLink) {
        String[] segments = fullPath.segments();
        boolean isFileLinkTarget = fileLink != null;
        char[][] charArraySegments = this.toCharArrayArray(segments, fileLink);
        this.createNode(charArraySegments, charArraySegments.length, true, isFileLinkTarget);
    }

    private char[][] toCharArrayArray(String[] segments, String fileLink) {
        char[][] chsegs;
        int segmentLen = segments.length;
        if (fileLink != null) {
            chsegs = new char[segmentLen + 1][];
            chsegs[segmentLen] = fileLink.toCharArray();
        } else {
            chsegs = new char[segmentLen][];
        }
        int i = 0;
        while (i < segmentLen) {
            chsegs[i] = segments[i].toCharArray();
            ++i;
        }
        return chsegs;
    }

    private Node createNode(char[][] segments, int segmentCount, boolean hasFileLocationName, boolean isFileLinkTarget) {
        assert (Thread.holdsLock(this.fLock));
        if (segmentCount == 0) {
            return this.fRootNode;
        }
        if (!hasFileLocationName && this.fLastFolderNode != null && this.isNodeForSegments(this.fLastFolderNode, segments, segmentCount, isFileLinkTarget)) {
            return this.fLastFolderNode;
        }
        char[] name = segments[segmentCount - 1];
        int hash = this.hashCode(name);
        Object obj = this.fNodeMap.get(hash);
        Node[] nodes = null;
        int len = 0;
        if (obj != null) {
            Node node;
            if (obj instanceof Node) {
                node = (Node)obj;
                if (this.isNodeForSegments(node, segments, segmentCount, isFileLinkTarget)) {
                    if (!hasFileLocationName) {
                        this.fLastFolderNode = node;
                    }
                    return node;
                }
                Node[] nodeArray = new Node[2];
                nodeArray[0] = node;
                nodes = nodeArray;
                this.fNodeMap.put(hash, nodes);
                len = 1;
            } else {
                nodes = (Node[])obj;
                len = 0;
                while (len < nodes.length) {
                    node = nodes[len];
                    if (node == null) break;
                    if (this.isNodeForSegments(node, segments, segmentCount, isFileLinkTarget)) {
                        if (!hasFileLocationName) {
                            this.fLastFolderNode = node;
                        }
                        return node;
                    }
                    ++len;
                }
            }
        }
        Node parent = this.createNode(segments, segmentCount - 1, false, false);
        Node node = new Node(parent, name, hasFileLocationName, isFileLinkTarget);
        if (nodes == null) {
            this.fNodeMap.put(hash, node);
        } else {
            if (len == nodes.length) {
                Node[] newNodes = new Node[len + 2];
                System.arraycopy(nodes, 0, newNodes, 0, len);
                nodes = newNodes;
                this.fNodeMap.put(hash, nodes);
            }
            nodes[len] = node;
        }
        if (!hasFileLocationName) {
            this.fLastFolderNode = node;
        }
        return node;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNodeForSegments(Node node, char[][] segments, int segmentLength, boolean isFileLinkTarget) {
        if (!ResourceLookupTree.$assertionsDisabled && !Thread.holdsLock(this.fLock)) {
            throw new AssertionError();
        }
        if (node.fIsFileLinkTarget == isFileLinkTarget) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (!CharArrayUtils.equals((char[])segments[--segmentLength], (char[])node.fResourceName)) {
                return false;
            }
            node = node.fParent;
lbl8:
            // 2 sources

            ** while (segmentLength > 0 && node != null)
        }
lbl9:
        // 1 sources

        return node == this.fRootNode;
    }

    private void remove(IResource res) {
        assert (Thread.holdsLock(this.fLock));
        char[] name = res.getName().toCharArray();
        int hash = this.hashCode(name);
        Object obj = this.fNodeMap.get(hash);
        if (obj == null) {
            return;
        }
        IPath fullPath = res.getFullPath();
        int segmentCount = fullPath.segmentCount();
        if (segmentCount == 0) {
            return;
        }
        char[][] segments = this.toCharArrayArray(fullPath.segments(), null);
        if (obj instanceof Node) {
            Node node = (Node)obj;
            if (!node.fDeleted && this.isNodeForSegments(node, segments, segmentCount, false)) {
                node.fDeleted = true;
                if (node.fHasChildren) {
                    this.fNeedCleanup = true;
                }
                this.fNodeMap.remove(hash);
            }
        } else {
            Node[] nodes = (Node[])obj;
            int i = 0;
            while (i < nodes.length) {
                Node node = nodes[i];
                if (node == null) {
                    return;
                }
                if (!node.fDeleted && this.isNodeForSegments(node, segments, segmentCount, false)) {
                    this.remove(nodes, i);
                    if (nodes[0] == null) {
                        this.fNodeMap.remove(hash);
                    }
                    node.fDeleted = true;
                    if (node.fHasChildren) {
                        this.fNeedCleanup = true;
                    }
                    return;
                }
                ++i;
            }
        }
    }

    private void remove(Node[] nodes, int i) {
        int idx = this.lastValid(nodes, i);
        if (idx > 0) {
            nodes[i] = nodes[idx];
            nodes[idx] = null;
        }
    }

    private int lastValid(Node[] nodes, int left) {
        int right = nodes.length - 1;
        while (left < right) {
            int mid = (left + right + 1) / 2;
            if (nodes[mid] == null) {
                right = mid - 1;
                continue;
            }
            left = mid;
        }
        return right;
    }

    private void cleanup() {
        assert (Thread.holdsLock(this.fLock));
        this.fLastFolderNode = null;
        Iterator<Object> iterator = this.fNodeMap.values().iterator();
        block0: while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Node) {
                if (!this.isDeleted((Node)obj)) continue;
                iterator.remove();
                continue;
            }
            Node[] nodes = (Node[])obj;
            int j = 0;
            int i = 0;
            while (i < nodes.length) {
                Node node = nodes[i];
                if (node == null) {
                    if (j != 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!this.isDeleted(node)) {
                    if (i != j) {
                        nodes[j] = node;
                        nodes[i] = null;
                    }
                    ++j;
                } else {
                    nodes[i] = null;
                }
                ++i;
            }
        }
    }

    private boolean isDeleted(Node node) {
        while (node != null) {
            if (node.fDeleted) {
                return true;
            }
            node = node.fParent;
        }
        return false;
    }

    private int hashCode(char[] name) {
        int h = 0;
        int len = name.length;
        int i = 0;
        while (i < len) {
            h = 31 * h + Character.toUpperCase(name[i]);
            ++i;
        }
        return h;
    }

    public IFile[] findFilesForLocationURI(URI location) {
        return this.findFilesForLocation(location, LocationAdapter.URI);
    }

    public IFile[] findFilesForLocation(IPath location) {
        return this.findFilesForLocation(location, LocationAdapter.PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IFile[] findFilesForLocation(T location, LocationAdapter<T> adapter) {
        this.initFileExtensions();
        String name = adapter.extractName(location);
        Node[] candidates = null;
        Object object = this.fLock;
        synchronized (object) {
            IFile[] result;
            this.initializeProjects(ResourcesPlugin.getWorkspace().getRoot().getProjects());
            Object obj = this.fNodeMap.get(this.hashCode(name.toCharArray()));
            if (obj != null && (result = this.extractMatchesForLocation(candidates = this.convert(obj), location, adapter)).length > 0) {
                return result;
            }
        }
        return adapter.platformsFindFilesForLocation(location);
    }

    private Node[] convert(Object obj) {
        if (obj instanceof Node) {
            return new Node[]{(Node)obj};
        }
        Node[] nodes = (Node[])obj;
        int len = this.lastValid(nodes, -1) + 1;
        Node[] result = new Node[len];
        System.arraycopy(nodes, 0, result, 0, len);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFile[] findFilesByName(IPath relativeLocation, IProject[] projects, boolean ignoreCase) {
        Node[] candidates;
        int segCount = relativeLocation.segmentCount();
        if (segCount < 1) {
            return NO_FILES;
        }
        String name = relativeLocation.lastSegment();
        this.initFileExtensions();
        Object object = this.fLock;
        synchronized (object) {
            this.initializeProjects(projects);
            Object obj = this.fNodeMap.get(this.hashCode(name.toCharArray()));
            if (obj == null) {
                return NO_FILES;
            }
            candidates = this.convert(obj);
        }
        String suffix = relativeLocation.toString();
        while (suffix.startsWith("../")) {
            suffix = suffix.substring(3);
        }
        HashSet<String> prjset = new HashSet<String>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            prjset.add(prj.getName());
            ++n2;
        }
        return this.extractMatchesForName(candidates, name, suffix, ignoreCase, prjset);
    }

    private IFile[] extractMatchesForName(Node[] candidates, String name, String suffix, boolean ignoreCase, Set<String> prjSet) {
        char[] n1 = name.toCharArray();
        int namelen = n1.length;
        int resultIdx = 0;
        if (ignoreCase) {
            int j = 0;
            while (j < namelen) {
                n1[j] = Character.toUpperCase(n1[j]);
                ++j;
            }
        }
        int suffixLen = suffix.length();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] result = null;
        int i = 0;
        while (i < candidates.length) {
            block10: {
                char[] n2;
                Node node = candidates[i];
                if (node.fHasFileLocationName && this.checkProject(node, prjSet) && namelen == (n2 = node.fResourceName).length) {
                    String path;
                    int len;
                    int j = 0;
                    while (j < n2.length) {
                        char c;
                        char c2 = c = ignoreCase ? Character.toUpperCase(n2[j]) : n2[j];
                        if (c == n1[j]) {
                            ++j;
                            continue;
                        }
                        break block10;
                    }
                    IFile file = root.getFile(this.createPath(node));
                    URI loc = file.getLocationURI();
                    if (loc != null && (len = (path = loc.getPath()).length()) >= suffixLen && suffix.regionMatches(ignoreCase, 0, path, len - suffixLen, suffixLen)) {
                        if (result == null) {
                            result = new IFile[candidates.length - i];
                        }
                        result[resultIdx++] = root.getFile(this.createPath(node));
                    }
                }
            }
            ++i;
        }
        if (result == null) {
            return NO_FILES;
        }
        if (resultIdx < result.length) {
            IFile[] copy = new IFile[resultIdx];
            System.arraycopy(result, 0, copy, 0, resultIdx);
            return copy;
        }
        return result;
    }

    private boolean checkProject(Node node, Set<String> prjSet) {
        Node n;
        while ((n = node.fParent) != this.fRootNode) {
            if (n == null) {
                return false;
            }
            node = n;
        }
        return prjSet.contains(new String(node.fResourceName));
    }

    private IPath createPath(Node node) {
        if (node == this.fRootNode) {
            return Path.ROOT;
        }
        if (node.fIsFileLinkTarget) {
            return this.createPath(node.fParent);
        }
        return this.createPath(node.fParent).append(new String(node.fResourceName));
    }

    private <T> IFile[] extractMatchesForLocation(Node[] candidates, T location, LocationAdapter<T> adapter) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String searchPath = adapter.getCanonicalPath(location);
        IFile[] result = null;
        int resultIdx = 0;
        int i = 0;
        while (i < candidates.length) {
            block7: {
                Node node;
                block8: {
                    String candPath;
                    IFile file;
                    T loc;
                    node = candidates[i];
                    if (!node.fHasFileLocationName || (loc = adapter.getLocation(file = root.getFile(this.createPath(node)))) == null) break block7;
                    if (loc.equals(location)) break block8;
                    if (searchPath == null || node.fCanonicHash != 0 && node.fCanonicHash != searchPath.hashCode() || (candPath = adapter.getCanonicalPath(loc)) == null) break block7;
                    node.fCanonicHash = candPath.hashCode();
                    if (!candPath.equals(searchPath)) break block7;
                }
                if (result == null) {
                    result = new IFile[candidates.length - i];
                }
                result[resultIdx++] = root.getFile(this.createPath(node));
            }
            ++i;
        }
        if (result == null) {
            return NO_FILES;
        }
        if (resultIdx < result.length) {
            IFile[] copy = new IFile[resultIdx];
            System.arraycopy(result, 0, copy, 0, resultIdx);
            return copy;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        ArrayList<String> lines = new ArrayList<String>();
        Object object = this.fLock;
        synchronized (object) {
            Iterator<Object> iterator = this.fNodeMap.values().iterator();
            block3: while (iterator.hasNext()) {
                Node[] nodes = this.convert(iterator.next());
                int i = 0;
                while (i < nodes.length) {
                    Node node = nodes[i];
                    if (node == null) continue block3;
                    lines.add(this.toString(node));
                    ++i;
                }
            }
        }
        Collections.sort(lines);
        System.out.println("Dumping files:");
        for (String line : lines) {
            System.out.println(line);
        }
        System.out.flush();
    }

    private String toString(Node node) {
        if (node == this.fRootNode) {
            return "";
        }
        return String.valueOf(this.toString(node.fParent)) + "/" + new String(node.fResourceName);
    }

    private static class Extensions {
        private final boolean fInvert;
        private final Set<String> fExtensions;

        Extensions(Set<String> extensions, boolean invert) {
            this.fInvert = invert;
            this.fExtensions = extensions;
        }

        boolean isRelevant(String filename) {
            int idx = filename.lastIndexOf(46);
            if (idx < 0) {
                return true;
            }
            return this.fExtensions.contains(filename.substring(idx + 1).toUpperCase()) ^ this.fInvert;
        }
    }

    private static class Node {
        final Node fParent;
        final char[] fResourceName;
        final boolean fHasFileLocationName;
        final boolean fIsFileLinkTarget;
        boolean fDeleted;
        boolean fHasChildren;
        int fCanonicHash;

        Node(Node parent, char[] name, boolean hasFileLocationName, boolean isFileLinkTarget) {
            this.fParent = parent;
            this.fResourceName = name;
            this.fHasFileLocationName = hasFileLocationName;
            this.fIsFileLinkTarget = isFileLinkTarget;
            if (parent != null) {
                parent.fHasChildren = true;
            }
        }
    }
}

