/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ScopedDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;

public final class VariantDefinition
extends ScopedDefinition {
    private final Definition fDefinition;
    private final String fCurrentField;
    private final String fFieldName;

    public VariantDefinition(@NonNull VariantDeclaration declaration, IDefinitionScope definitionScope, String selectedField, @NonNull String fieldName, Definition fieldValue) {
        super(declaration, definitionScope, fieldName);
        this.fFieldName = fieldName;
        this.fCurrentField = selectedField;
        this.fDefinition = fieldValue;
    }

    @Override
    public VariantDeclaration getDeclaration() {
        return (VariantDeclaration)super.getDeclaration();
    }

    public String getCurrentFieldName() {
        return this.fCurrentField;
    }

    public Definition getCurrentField() {
        return this.fDefinition;
    }

    @Override
    public IDefinition lookupDefinition(String lookupPath) {
        IDefinition def;
        if (lookupPath == null) {
            return null;
        }
        if (lookupPath.equals(this.fFieldName)) {
            return this.fDefinition;
        }
        if (this.fDefinition instanceof ScopedDefinition && (def = ((ScopedDefinition)this.fDefinition).lookupDefinition(lookupPath)) != null) {
            return def;
        }
        IDefinitionScope definitionScope = this.getDefinitionScope();
        if (definitionScope instanceof StructDefinition) {
            StructDefinition structDefinition = (StructDefinition)definitionScope;
            return structDefinition.lookupDefinition(lookupPath, this);
        }
        return definitionScope.lookupDefinition(lookupPath);
    }

    @Override
    public String toString() {
        return "{ " + this.getCurrentFieldName() + " = " + this.getCurrentField() + " }";
    }
}

