/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.charting;

import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.Messages;
import org.eclipse.swt.widgets.Composite;

public class HeapChart {
    private static String[] byteUnits = new String[]{Messages.getString("HeapChart.B"), Messages.getString("HeapChart.KiB"), Messages.getString("HeapChart.MiB"), Messages.getString("HeapChart.GiB"), Messages.getString("HeapChart.TiB")};
    private static String[] instrUnits = new String[]{Messages.getString("HeapChart.i"), Messages.getString("HeapChart.Ki"), Messages.getString("HeapChart.Mi"), Messages.getString("HeapChart.Gi"), Messages.getString("HeapChart.Ti")};
    private static String[] secondUnits = new String[]{Messages.getString("HeapChart.ms"), Messages.getString("HeapChart.s")};
    protected static final int BYTE_MULT = 1024;
    protected static final int BYTE_LIMIT = byteUnits.length - 1;
    protected static final int INSTR_MULT = 1000;
    protected static final int INSTR_LIMIT = instrUnits.length - 1;
    protected static final int MS_MULT = 1000;
    protected static final int MS_LIMIT = secondUnits.length - 1;
    protected static final int SCALING_THRESHOLD = 20;
    protected String title;
    protected String xUnits;
    protected String yUnits;
    public double[] time;
    public double[] dataUseful;
    public double[] dataExtra;
    public double[] dataStacks;
    public double[] dataTotal;
    private Composite chartControl;

    public HeapChart(MassifSnapshot[] snapshots, String title) {
        MassifSnapshot.TimeUnit timeUnit = snapshots[0].getUnit();
        long xScaling = this.getXScaling(snapshots, timeUnit);
        long yScaling = this.getYScaling(snapshots);
        this.title = title;
        this.time = new double[snapshots.length];
        this.dataUseful = new double[snapshots.length];
        this.dataExtra = new double[snapshots.length];
        this.dataStacks = null;
        boolean isStack = this.isStackProfiled(snapshots);
        if (isStack) {
            this.dataStacks = new double[snapshots.length];
        }
        this.dataTotal = new double[snapshots.length];
        int i = 0;
        while (i < snapshots.length) {
            this.time[i] = (double)snapshots[i].getTime() / (double)xScaling;
            this.dataUseful[i] = (double)snapshots[i].getHeapBytes() / (double)yScaling;
            this.dataExtra[i] = (double)snapshots[i].getHeapExtra() / (double)yScaling;
            this.dataTotal[i] = this.dataUseful[i] + this.dataExtra[i];
            if (isStack) {
                this.dataStacks[i] = (double)snapshots[i].getStacks() / (double)yScaling;
            }
            ++i;
        }
    }

    private boolean isStackProfiled(MassifSnapshot[] snapshots) {
        return HeapChart.getMaxStack(snapshots) > 0L;
    }

    private long getYScaling(MassifSnapshot[] snapshots) {
        long max = HeapChart.getMaxValue(snapshots);
        int count = 0;
        while (max > 20480L && count < BYTE_LIMIT) {
            max /= 1024L;
            ++count;
        }
        this.yUnits = byteUnits[count];
        return (long)Math.pow(1024.0, count);
    }

    private long getXScaling(MassifSnapshot[] snapshots, MassifSnapshot.TimeUnit unit) {
        String[] units;
        int limit;
        int mult;
        long max = snapshots[snapshots.length - 1].getTime();
        switch (unit) {
            case BYTES: {
                mult = 1024;
                limit = BYTE_LIMIT;
                units = byteUnits;
                break;
            }
            case INSTRUCTIONS: {
                mult = 1000;
                limit = INSTR_LIMIT;
                units = instrUnits;
                break;
            }
            default: {
                mult = 1000;
                limit = MS_LIMIT;
                units = secondUnits;
            }
        }
        int count = 0;
        while (max > (long)(mult * 20) && count < limit) {
            max /= (long)mult;
            ++count;
        }
        this.xUnits = units[count];
        return (long)Math.pow(mult, count);
    }

    private static long getMaxValue(MassifSnapshot[] snapshots) {
        long max = 0L;
        MassifSnapshot[] massifSnapshotArray = snapshots;
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot snapshot = massifSnapshotArray[n2];
            if (snapshot.getTotal() > max) {
                max = snapshot.getTotal();
            }
            ++n2;
        }
        return max;
    }

    private static long getMaxStack(MassifSnapshot[] snapshots) {
        long max = 0L;
        MassifSnapshot[] massifSnapshotArray = snapshots;
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot snapshot = massifSnapshotArray[n2];
            if (snapshot.getTotal() > max) {
                max = snapshot.getStacks();
            }
            ++n2;
        }
        return max;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public static String[] getByteUnits() {
        return byteUnits;
    }

    public static String[] getInstrUnits() {
        return instrUnits;
    }

    public static String[] getSecondUnits() {
        return secondUnits;
    }

    public void setChartControl(Composite control) {
        this.chartControl = control;
    }

    public Composite getChartControl() {
        return this.chartControl;
    }
}

