/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.LinkedList;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.ArraySize;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class TypeDescriptor
implements Serializable {
    private final ParserContext pCtx;
    private String className;
    private char[] classNameArray;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    int endRange;

    public TypeDescriptor(ParserContext pCtx) {
        this.pCtx = pCtx;
    }

    public TypeDescriptor(char[] name, int fields, ParserContext pCtx) {
        this.pCtx = pCtx;
        this.classNameArray = name;
        this.updateClassName(name, fields);
    }

    /*
     * Unable to fully structure code
     */
    public void updateClassName(char[] name, int fields) {
        block9: {
            block7: {
                block8: {
                    this.classNameArray = name;
                    if (name.length == 0 || !ParseTools.isIdentifierPart(name[0]) || Character.isDigit(name[0])) {
                        return;
                    }
                    this.endRange = ArrayTools.findFirst('(', name);
                    if (this.endRange != -1) break block7;
                    this.endRange = ArrayTools.findFirst('[', name);
                    if (this.endRange == -1) break block8;
                    this.className = new String(name, 0, this.endRange);
                    sizes = new LinkedList<char[]>();
                    ** GOTO lbl21
                    {
                        ++this.endRange;
                        do {
                            if (this.endRange < name.length && ParseTools.isWhitespace(name[this.endRange])) continue block0;
                            if (this.endRange == name.length || name[this.endRange] == '{') break block0;
                            if (name[this.endRange] != '[') {
                                throw new CompileException("unexpected token in contstructor", name, this.endRange);
                            }
                            to = ParseTools.balancedCapture(name, this.endRange, '[');
                            sizes.add(ParseTools.subset(name, ++this.endRange, to - this.endRange));
                            this.endRange = to + 1;
lbl21:
                            // 2 sources

                        } while (this.endRange < name.length);
                    }
                    iter = sizes.iterator();
                    this.arraySize = new ArraySize[sizes.size()];
                    i = 0;
                    while (i < this.arraySize.length) {
                        this.arraySize[i] = new ArraySize((char[])iter.next());
                        ++i;
                    }
                    if ((fields & 16) != 0) {
                        this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                        i = 0;
                        while (i < this.compiledArraySize.length) {
                            this.compiledArraySize[i] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[i].value, this.pCtx);
                            ++i;
                        }
                    }
                    return;
                }
                this.className = new String(name);
                break block9;
            }
            this.className = new String(name, 0, this.endRange);
        }
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public int getArrayLength() {
        return this.arraySize.length;
    }

    public ArraySize[] getArraySize() {
        return this.arraySize;
    }

    public ExecutableStatement[] getCompiledArraySize() {
        return this.compiledArraySize;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClass() {
        return this.className != null && this.className.length() != 0;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int endRange) {
        this.endRange = endRange;
    }

    public static Class getClassReference(Class baseType, TypeDescriptor tDescr, VariableResolverFactory factory, ParserContext ctx) throws ClassNotFoundException {
        return ParseTools.findClass(factory, String.valueOf(ParseTools.repeatChar('[', tDescr.arraySize.length)) + "L" + baseType.getName() + ";", ctx);
    }

    public static Class getClassReference(ParserContext ctx, Class cls, TypeDescriptor tDescr) throws ClassNotFoundException {
        if (tDescr.isArray()) {
            cls = ParseTools.findClass(null, String.valueOf(ParseTools.repeatChar('[', tDescr.arraySize.length)) + "L" + cls.getName() + ";", ctx);
        }
        return cls;
    }

    public static Class getClassReference(ParserContext ctx, TypeDescriptor tDescr) throws ClassNotFoundException {
        Class cls;
        if (ctx != null && ctx.hasImport(tDescr.className)) {
            cls = ctx.getImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, String.valueOf(ParseTools.repeatChar('[', tDescr.arraySize.length)) + "L" + cls.getName() + ";", ctx);
            }
        } else if (ctx == null && TypeDescriptor.hasContextFreeImport(tDescr.className)) {
            cls = TypeDescriptor.getContextFreeImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, String.valueOf(ParseTools.repeatChar('[', tDescr.arraySize.length)) + "L" + cls.getName() + ";", ctx);
            }
        } else {
            cls = ParseTools.createClass(tDescr.getClassName(), ctx);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, String.valueOf(ParseTools.repeatChar('[', tDescr.arraySize.length)) + "L" + cls.getName() + ";", ctx);
            }
        }
        return cls;
    }

    public boolean isUndimensionedArray() {
        if (this.arraySize != null) {
            ArraySize[] arraySizeArray = this.arraySize;
            int n = this.arraySize.length;
            int n2 = 0;
            while (n2 < n) {
                ArraySize anArraySize = arraySizeArray[n2];
                if (anArraySize.value.length == 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean hasContextFreeImport(String name) {
        return AbstractParser.LITERALS.containsKey(name) && AbstractParser.LITERALS.get(name) instanceof Class;
    }

    public static Class getContextFreeImport(String name) {
        return (Class)AbstractParser.LITERALS.get(name);
    }

    public char[] getClassNameArray() {
        return this.classNameArray;
    }
}

