/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class CharCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static final Converter stringConverter = new Converter(){

        public Object convert(Object o) {
            if (((String)o).length() > 1) {
                throw new ConversionException("cannot convert a string with a length greater than 1 to java.lang.Character");
            }
            return Character.valueOf(((String)o).charAt(0));
        }
    };

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(Character.class, new Converter(){

            public Object convert(Object o) {
                return new Character(((Character)o).charValue());
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Object convert(Object o) {
                return Character.valueOf((char)((BigDecimal)o).intValue());
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object o) {
                return Character.valueOf((char)((Integer)o).intValue());
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

