/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.builds.core.IArtifact;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ArtifactsLabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ArtifactsPart
extends AbstractBuildEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.builds.ui.editor.menu.Artifacts";
    private MenuManager menuManager;
    private TreeViewer viewer;

    public ArtifactsPart() {
        super(320);
        this.setPartName("Artifacts");
    }

    @Override
    protected Control createContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(toolkit.createTree(composite, 0));
        this.viewer.setAutoExpandLevel(-1);
        GridDataFactory.fillDefaults().hint(300, 100).grab(true, true).applyTo(this.viewer.getControl());
        this.viewer.setContentProvider((IContentProvider)new ArtifactsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ArtifactsLabelProvider(), null, null));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArtifactsPart.this.getPage().getSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IArtifact artifact;
                Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (item instanceof IArtifact && (artifact = (IArtifact)item).getUrl() != null) {
                    BrowserUtil.openUrl((String)artifact.getUrl(), (int)131072);
                }
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = null;
                String name2 = null;
                if (e1 instanceof IArtifact) {
                    name1 = ((IArtifact)e1).getName();
                } else if (e1 instanceof ArtifactFolder) {
                    name1 = ((ArtifactFolder)e1).getName();
                }
                if (e2 instanceof IArtifact) {
                    name2 = ((IArtifact)e2).getName();
                } else if (e1 instanceof ArtifactFolder) {
                    name2 = ((ArtifactFolder)e2).getName();
                }
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.getPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)this.viewer, true);
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        ArtifactFolder root = this.getRootFolder();
        if (root.hasChildren()) {
            this.viewer.setInput((Object)root);
        } else {
            this.viewer.setInput((Object)"No artifacts.");
        }
        int numArtifacts = this.getInput(IBuild.class).getArtifacts().size();
        this.getSection().setText(MessageFormat.format("Artifacts ({0})", numArtifacts));
        toolkit.paintBordersFor(composite);
        return composite;
    }

    private ArtifactFolder getRootFolder() {
        ArtifactFolder root = new ArtifactFolder("Root");
        for (IArtifact artifact : this.getInput(IBuild.class).getArtifacts()) {
            root.add(artifact);
        }
        return root;
    }

    @Override
    protected void fillToolBar(ToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
        toolBarManager.add((IAction)new Action("Collapse All", CommonImages.COLLAPSE_ALL){

            public void run() {
                ArtifactsPart.this.viewer.collapseAll();
            }
        });
    }

    static class ArtifactFolder {
        final Map<String, ArtifactFolder> folders = new HashMap<String, ArtifactFolder>();
        final List<IArtifact> artifacts = new ArrayList<IArtifact>();
        final String name;

        public ArtifactFolder(String name) {
            this.name = name;
        }

        protected Object[] getChildren() {
            ArrayList<Object> all = new ArrayList<Object>(this.artifacts.size() + this.folders.size());
            all.addAll(this.artifacts);
            all.addAll(this.folders.values());
            return all.toArray();
        }

        public boolean hasChildren() {
            return this.artifacts.size() + this.folders.size() > 0;
        }

        public String getName() {
            return this.name;
        }

        ArtifactFolder add(String path, IArtifact artifact) {
            int slash = path.indexOf(47);
            if (slash > 0 && slash + 1 < path.length()) {
                String name = path.substring(0, slash);
                ArtifactFolder folder = this.folders.get(name);
                if (folder == null) {
                    folder = new ArtifactFolder(name);
                    this.folders.put(name, folder);
                }
                path = path.substring(slash + 1);
                folder.add(path, artifact);
            } else {
                this.artifacts.add(artifact);
            }
            return this;
        }

        public ArtifactFolder add(IArtifact artifact) {
            return this.add(artifact.getRelativePath(), artifact);
        }

        public String toString() {
            return this.name;
        }
    }

    static class ArtifactsContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private ArtifactFolder input;

        ArtifactsContentProvider() {
        }

        public void dispose() {
            this.input = null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArtifactFolder) {
                return ((ArtifactFolder)parentElement).getChildren();
            }
            return NO_ELEMENTS;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == this.input) {
                return this.input.getChildren();
            }
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            return NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ArtifactFolder) {
                return ((ArtifactFolder)element).hasChildren();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput instanceof ArtifactFolder ? (ArtifactFolder)newInput : null;
        }
    }
}

