/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class FlipBooleanPropertyEditPolicy
extends EditPolicy {
    private final ObjectInfo m_component;
    private final String m_propertyPath;

    public FlipBooleanPropertyEditPolicy(ObjectInfo component, String propertyPath) {
        this.m_component = component;
        this.m_propertyPath = propertyPath;
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if ("open".equals(request.getType())) {
            ExecutionUtils.run(this.m_component, new RunnableEx(){

                public void run() throws Exception {
                    Object value;
                    Property property = PropertyUtils.getByPath(FlipBooleanPropertyEditPolicy.this.m_component, FlipBooleanPropertyEditPolicy.this.m_propertyPath);
                    if (property != null && (value = property.getValue()) instanceof Boolean) {
                        boolean booleanValue = (Boolean)value;
                        property.setValue(!booleanValue);
                    }
                }
            });
        }
    }
}

