/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.locator.GavHelpedLocator;
import org.apache.maven.model.Model;

public class ArtifactLocator
implements GavHelpedLocator {
    private final ArtifactPackagingMapper mapper;

    public ArtifactLocator(ArtifactPackagingMapper mapper) {
        this.mapper = mapper;
    }

    public File locate(File source, GavCalculator gavCalculator, Gav gav) {
        if (source == null || !source.exists() || gav == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            return null;
        }
        try {
            Model model = new ArtifactContext.ModelReader().readModel(new FileInputStream(source));
            if (model == null) {
                return null;
            }
            String artifactName = gav.getArtifactId() + "-" + gav.getVersion() + "." + this.mapper.getExtensionForPackaging(model.getPackaging());
            File artifact = new File(source.getParent(), artifactName);
            if (!artifact.exists()) {
                return null;
            }
            return artifact;
        }
        catch (IOException e) {
            return null;
        }
    }
}

