/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.wb.core.editor.DesignerEditorListener;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.core.editor.IMultiMode;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.editor.multi.MultiMode;
import org.eclipse.wb.internal.core.editor.multi.MultiPagesMode;
import org.eclipse.wb.internal.core.editor.multi.MultiSourceMode;
import org.eclipse.wb.internal.core.editor.multi.MultiSplitMode;
import org.eclipse.wb.internal.core.editor.multi.VisitedLinesHighlighter;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.views.IDesignCompositeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignerEditor
extends CompilationUnitEditor
implements IDesignerEditor,
IDesignCompositeProvider {
    private static final String CONTEXT_ID = "org.eclipse.wb.core.java.editorScope";
    private MultiMode m_multiMode;
    private boolean m_firstActivation = true;
    private Composite m_rootControl;
    private VisitedLinesHighlighter m_linesHighlighter;
    private final List<DesignerEditorListener> m_designPageListeners = Lists.newArrayList();
    private static final ProblemsLabelDecorator PROBLEMS_DECORATOR = new ProblemsLabelDecorator();

    public DesignerEditor() {
        DesignerPlugin.configurePreEditor();
        this.m_multiMode = this.isPagesMode() ? new MultiPagesMode(this) : new MultiSplitMode(this);
    }

    public void createPartControl(Composite parent) {
        this.m_rootControl = parent;
        this.m_multiMode.create(parent);
        this.m_linesHighlighter = new VisitedLinesHighlighter(this.getSourceViewer());
        this.activateEditorContext();
    }

    private void activateEditorContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(CONTEXT_ID);
        }
    }

    public void setFocus() {
        this.m_multiMode.setFocus();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (!this.canDesignInput()) {
            this.m_multiMode = new MultiSourceMode(this);
        }
        this.m_multiMode.onSetInput();
    }

    private boolean canDesignInput() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        if (compilationUnit == null) {
            return false;
        }
        try {
            compilationUnit.getUnderlyingResource();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    void activated() {
        if (this.m_firstActivation) {
            this.m_firstActivation = false;
            this.m_multiMode.editorActivatedFirstTime();
        }
    }

    public void dispose() {
        super.dispose();
        this.m_multiMode.dispose();
    }

    private boolean isPagesMode() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 0 || layout == 1;
    }

    public Composite getRootControl() {
        return this.m_rootControl;
    }

    void super_createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    ISourceViewer super_getSourceViewer() {
        return super.getSourceViewer();
    }

    public void showSourcePosition(final int position) {
        ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                DesignerEditor.this.selectAndReveal(position, 0);
            }
        });
    }

    public void highlightVisitedNodes(final Collection<ASTNode> nodes) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                if (DesignerEditor.this.m_linesHighlighter != null) {
                    DesignerEditor.this.m_linesHighlighter.setVisitedNodes(nodes);
                }
            }
        });
    }

    @Override
    public IMultiMode getMultiMode() {
        return this.m_multiMode;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        IWorkingCopyManager workingCopyManager = JavaUI.getWorkingCopyManager();
        return workingCopyManager.getWorkingCopy(this.getEditorInput());
    }

    @Override
    public void addDesignPageListener(DesignerEditorListener listener) {
        this.m_designPageListeners.add(listener);
    }

    @Override
    public void removeDesignPageListener(DesignerEditorListener listener) {
        this.m_designPageListeners.remove(listener);
    }

    public List<DesignerEditorListener> getDesignPageListeners() {
        return this.m_designPageListeners;
    }

    public DesignComposite getDesignComposite() {
        return this.m_multiMode.getDesignPage().getDesignComposite();
    }

    public void updatedTitleImage(Image image) {
        Image baseImage = DesignerPlugin.getImage((String)"gui_editor.gif");
        Image decoratedImage = PROBLEMS_DECORATOR.decorateImage(baseImage, (Object)this.getCompilationUnit());
        if (decoratedImage == null) {
            decoratedImage = baseImage;
        }
        this.setTitleImage(decoratedImage);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (DesignerPlugin.getPreferences().getBoolean("editor.formatOnSave")) {
            ICompilationUnit unit = this.getCompilationUnit();
            FormatAllAction formatAction = new FormatAllAction((IWorkbenchSite)this.getSite());
            formatAction.run((IStructuredSelection)new StructuredSelection((Object)unit));
        }
        super.doSave(progressMonitor);
        this.m_multiMode.afterSave();
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        this.m_multiMode.getSourcePage().setAction(actionID, action);
    }

    void super_setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
    }

    public IAction getAction(String actionID) {
        if (this.m_multiMode.isSourceActive()) {
            return super.getAction(actionID);
        }
        if (this.m_multiMode.isDesignActive()) {
            return this.m_multiMode.getDesignPage().getDesignComposite().getAction(actionID);
        }
        return super.getAction(actionID);
    }
}

