/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import java.lang.reflect.Method;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescription
extends AbstractInvocationDescription {
    private Class<?> m_returnClass;
    private MethodOrder m_order = MethodOrder.DEFAULT;
    private Boolean m_executable = null;

    public MethodDescription(Class<?> declaringClass) {
        super(declaringClass);
    }

    public MethodDescription(Method method) throws Exception {
        super(method.getDeclaringClass());
        this.setName(method.getName());
        this.setReturnClass(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            ParameterDescription parameterDescription = new ParameterDescription();
            parameterDescription.setType(parameterType);
            this.addParameter(parameterDescription);
            ++n2;
        }
        this.postProcess();
    }

    @Override
    public void join(AbstractInvocationDescription description) {
        super.join(description);
        MethodDescription methodDescription = (MethodDescription)description;
        if (methodDescription.m_order != MethodOrder.DEFAULT) {
            this.m_order = methodDescription.m_order;
        }
        if (methodDescription.m_executable != null) {
            this.m_executable = methodDescription.m_executable;
        }
    }

    public Class<?> getReturnClass() {
        return this.m_returnClass;
    }

    public void setReturnClass(Class<?> componentClass) {
        this.m_returnClass = componentClass;
    }

    public final MethodOrder getOrder() {
        return this.m_order;
    }

    public void setOrder(MethodOrder order) {
        this.m_order = order;
    }

    public void setOrderSpecification(String specification) {
        this.m_order = MethodOrder.parse(specification);
    }

    public final boolean isExecutable() {
        if (this.m_executable == null) {
            return true;
        }
        return this.m_executable;
    }

    public final void setExecutable(boolean executable) {
        this.m_executable = executable ? Boolean.TRUE : Boolean.FALSE;
    }
}

