/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_26 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 5305, "epsg", 5305,
        "DRUKREF 03 / Thimphu TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.55 +k=1 +x_0=250000 +y_0=");
    add_proj4text (p, 1,
        "-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Thimphu TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",89.55],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5305\"]]");
    p = add_epsg_def (filter, first, last, 5306, "epsg", 5306,
        "DRUKREF 03 / Trashigang TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.75 +k=1 +x_0=250000 +y_0=");
    add_proj4text (p, 1,
        "-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Trashigang TM\",GEOGCS[\"DRUKREF 0");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",91.75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",250000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5306\"]]");
    p = add_epsg_def (filter, first, last, 5307, "epsg", 5307,
        "DRUKREF 03 / Trongsa TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.5 +k=1 +x_0=250000 +y_0=-");
    add_proj4text (p, 1,
        "2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Trongsa TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"5307\"]]");
    p = add_epsg_def (filter, first, last, 5308, "epsg", 5308,
        "DRUKREF 03 / Tsirang TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.16666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Tsirang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.16666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",250000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5308\"]]");
    p = add_epsg_def (filter, first, last, 5309, "epsg", 5309,
        "DRUKREF 03 / Wangdue Phodrang TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.11666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Wangdue Phodrang TM\",GEOGCS[\"DRU");
    add_srs_wkt (p, 1,
        "KREF 03\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1058\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",90.11666666666666],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "250000],PARAMETER[\"false_northing\",-2500000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5309\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5310, "epsg", 5310,
        "DRUKREF 03 / Yangtse TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.56666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Yangtse TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",91.56666666666666],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",250000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5310\"]]");
    p = add_epsg_def (filter, first, last, 5311, "epsg", 5311,
        "DRUKREF 03 / Zhemgang TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.86666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Zhemgang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.86666666666666],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",250000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5311\"]]");
    p = add_epsg_def (filter, first, last, 5316, "epsg", 5316,
        "ETRS89 / Faroe TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-7 +k=0.999997 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Faroe TM\",GEOGCS[\"ETRS89\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Terrestrial_Reference_System_1989\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-7],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.999997],PARAMETER[\"false_easting\",200000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",-6000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5316\"]]");
    p = add_epsg_def (filter, first, last, 5320, "epsg", 5320,
        "NAD83 / Teranet Ontario Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Teranet Ontario Lambert\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",44.5],PARAMETER[\"standard_parallel_2\",54.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-84],PARAMETER[\"false_easting\",1000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5320\"]]");
    p = add_epsg_def (filter, first, last, 5321, "epsg", 5321,
        "NAD83(CSRS) / Teranet Ontario Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Teranet Ontario Lambert\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",44.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",54.5],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"central_meridian\",-84],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5321\"]]");
    p = add_epsg_def (filter, first, last, 5324, "epsg", 5324,
        "ISN2004");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ISN2004\",DATUM[\"Islands_Net_2004\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1060\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"5324\"]]");
    p = add_epsg_def (filter, first, last, 5325, "epsg", 5325,
        "ISN2004 / Lambert 2004");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19");
    add_proj4text (p, 1,
        " +x_0=1700000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / Lambert 2004\",GEOGCS[\"ISN2004\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5324\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",64.25],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_2\",65.75],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "origin\",65],PARAMETER[\"central_meridian\",-19],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",1700000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5325\"]]");
    p = add_epsg_def (filter, first, last, 5329, "epsg", 5329,
        "Segara (Jakarta) / NEIEZ");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 2,
        " +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Segara (Jakarta) / NEIEZ\",GEOGCS[\"Segara (Jak");
    add_srs_wkt (p, 1,
        "arta)\",DATUM[\"Gunung_Segara_Jakarta\",SPHEROID[\"Besse");
    add_srs_wkt (p, 2,
        "l 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "04\"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6820\"]],PRIMEM[\"Jakarta\",106.8077194444444,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8908\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4820\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3.192280555555556],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "97],PARAMETER[\"false_easting\",3900000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",900000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5329\"]]");
    p = add_epsg_def (filter, first, last, 5330, "epsg", 5330,
        "Batavia (Jakarta) / NEIEZ");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 2,
        "0 +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia (Jakarta) / NEIEZ\",GEOGCS[\"Batavia (J");
    add_srs_wkt (p, 1,
        "akarta)\",DATUM[\"Batavia_Jakarta\",SPHEROID[\"Bessel 18");
    add_srs_wkt (p, 2,
        "41\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-377,681,-50,0,0,0,0],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "13\"]],PRIMEM[\"Jakarta\",106.8077194444444,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8908\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4813\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",3.192280555555556],PARAMETER[\"scale_factor\",0.997");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",3900000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",900000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5330\"]]");
    p = add_epsg_def (filter, first, last, 5331, "epsg", 5331,
        "Makassar (Jakarta) / NEIEZ");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 2,
        "6,0,0,0,0 +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Makassar (Jakarta) / NEIEZ\",GEOGCS[\"Makassar ");
    add_srs_wkt (p, 1,
        "(Jakarta)\",DATUM[\"Makassar_Jakarta\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 2,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",106.8077194444444,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4804\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",3.192280555555556],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.997],PARAMETER[\"false_easting\",3900000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",900000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5331\"]]");
    p = add_epsg_def (filter, first, last, 5337, "epsg", 5337,
        "Aratu / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 25S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],TOWGS84[-151.99,287.04,-147.45");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4208\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-33],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5337\"]]");
    p = add_epsg_def (filter, first, last, 5340, "epsg", 5340,
        "POSGAR 2007");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR 2007\",DATUM[\"Posiciones_Geodesicas_Arg");
    add_srs_wkt (p, 1,
        "entinas_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1062\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "5340\"]]");
    p = add_epsg_def (filter, first, last, 5343, "epsg", 5343,
        "POSGAR 2007 / Argentina 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 1\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-72],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",1500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5343\"]]");
    p = add_epsg_def (filter, first, last, 5344, "epsg", 5344,
        "POSGAR 2007 / Argentina 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 2\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-69],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",2500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5344\"]]");
    p = add_epsg_def (filter, first, last, 5345, "epsg", 5345,
        "POSGAR 2007 / Argentina 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 3\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",3500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5345\"]]");
    p = add_epsg_def (filter, first, last, 5346, "epsg", 5346,
        "POSGAR 2007 / Argentina 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 4\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",4500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5346\"]]");
    p = add_epsg_def (filter, first, last, 5347, "epsg", 5347,
        "POSGAR 2007 / Argentina 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 5\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-60],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",5500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5347\"]]");
    p = add_epsg_def (filter, first, last, 5348, "epsg", 5348,
        "POSGAR 2007 / Argentina 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 6\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-57],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",6500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5348\"]]");
    p = add_epsg_def (filter, first, last, 5349, "epsg", 5349,
        "POSGAR 2007 / Argentina 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 7\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",7500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5349\"]]");
    p = add_epsg_def (filter, first, last, 5354, "epsg", 5354,
        "MARGEN");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MARGEN\",DATUM[\"Marco_Geodesico_Nacional\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1063\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5354\"]]");
    p = add_epsg_def (filter, first, last, 5355, "epsg", 5355,
        "MARGEN / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 20S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5355\"]]");
    p = add_epsg_def (filter, first, last, 5356, "epsg", 5356,
        "MARGEN / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 19S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5356\"]]");
    p = add_epsg_def (filter, first, last, 5357, "epsg", 5357,
        "MARGEN / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 21S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5357\"]]");
    p = add_epsg_def (filter, first, last, 5360, "epsg", 5360,
        "SIRGAS-Chile");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile\",DATUM[\"SIRGAS_Chile\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"106");
    add_srs_wkt (p, 3,
        "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"5360\"]]");
    p = add_epsg_def (filter, first, last, 5361, "epsg", 5361,
        "SIRGAS-Chile / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile / UTM zone 19S\",GEOGCS[\"SIRGAS-C");
    add_srs_wkt (p, 1,
        "hile\",DATUM[\"SIRGAS_Chile\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1064\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5360\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5361\"]]");
    p = add_epsg_def (filter, first, last, 5362, "epsg", 5362,
        "SIRGAS-Chile / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile / UTM zone 18S\",GEOGCS[\"SIRGAS-C");
    add_srs_wkt (p, 1,
        "hile\",DATUM[\"SIRGAS_Chile\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1064\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5360\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5362\"]]");
    p = add_epsg_def (filter, first, last, 5365, "epsg", 5365,
        "CR05");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CR05\",DATUM[\"Costa_Rica_2005\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1065\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"5365\"]]");
    p = add_epsg_def (filter, first, last, 5367, "epsg", 5367,
        "CR05 / CRTM05");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CR05 / CRTM05\",GEOGCS[\"CR05\",DATUM[\"Costa_R");
    add_srs_wkt (p, 1,
        "ica_2005\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1065\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5365\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-84],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"5367\"]]");
    p = add_epsg_def (filter, first, last, 5371, "epsg", 5371,
        "MACARIO SOLIS");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MACARIO SOLIS\",DATUM[\"Sistema_Geodesico_Nacio");
    add_srs_wkt (p, 1,
        "nal_de_Panama_MACARIO_SOLIS\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1066\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5371\"]]");
    p = add_epsg_def (filter, first, last, 5373, "epsg", 5373,
        "Peru96");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Peru96\",DATUM[\"Peru96\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1067\"]],PRIMEM");
    add_srs_wkt (p, 3,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 4,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"5373\"]]");
    p = add_epsg_def (filter, first, last, 5381, "epsg", 5381,
        "SIRGAS-ROU98");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-ROU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "30\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"5381\"]]");
    p = add_epsg_def (filter, first, last, 5382, "epsg", 5382,
        "SIRGAS-ROU98 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-ROU98 / UTM zone 21S\",GEOGCS[\"SIRGAS-R");
    add_srs_wkt (p, 1,
        "OU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"5381\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5382\"]]");
    p = add_epsg_def (filter, first, last, 5383, "epsg", 5383,
        "SIRGAS-ROU98 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-ROU98 / UTM zone 22S\",GEOGCS[\"SIRGAS-R");
    add_srs_wkt (p, 1,
        "OU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"5381\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-51],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5383\"]]");
    p = add_epsg_def (filter, first, last, 5387, "epsg", 5387,
        "Peru96 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 18S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5387\"]]");
    p = add_epsg_def (filter, first, last, 5388, "epsg", 5388,
        "Peru96 / UTM zone 17S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 17S (deprecated)\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "eru96\",DATUM[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"5373\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-81],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5388\"]]");
    p = add_epsg_def (filter, first, last, 5389, "epsg", 5389,
        "Peru96 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 19S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5389\"]]");
    p = add_epsg_def (filter, first, last, 5393, "epsg", 5393,
        "SIRGAS_ES2007.8");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS_ES2007.8\",DATUM[\"SIRGAS_ES2007_8\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1069\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5393\"]]");
    p = add_epsg_def (filter, first, last, 5396, "epsg", 5396,
        "SIRGAS 2000 / UTM zone 26S");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 26S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"5396\"]]");
    p = add_epsg_def (filter, first, last, 5451, "epsg", 5451,
        "Ocotepeque 1935");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=213.11,9.37,-74.95,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ocotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"5451\"]]");
    p = add_epsg_def (filter, first, last, 5456, "epsg", 5456,
        "Ocotepeque 1935 / Costa Rica Norte");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.46666666666667 +lat_0=10.46666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-84.33333333333333 +k_0=0.99995696 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=271820.522 +ellps=clrk66 +towgs84=213.11,9.37,-74");
    add_proj4text (p, 3,
        ".95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Costa Rica Norte\",GEOGCS[\"O");
    add_srs_wkt (p, 1,
        "cotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",10.46666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-84.33333333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.99995696],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",271820.522],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"5456\"]]");
    p = add_epsg_def (filter, first, last, 5457, "epsg", 5457,
        "Ocotepeque 1935 / Costa Rica Sur");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=9 +lat_0=9 +lon_0=-83.66666666666667 +k");
    add_proj4text (p, 1,
        "_0=0.99995696 +x_0=500000 +y_0=327987.436 +ellps=clrk66 ");
    add_proj4text (p, 2,
        "+towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Costa Rica Sur\",GEOGCS[\"Oco");
    add_srs_wkt (p, 1,
        "tepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",9],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "83.66666666666667],PARAMETER[\"scale_factor\",0.99995696");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",327987.436],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"5457\"]]");
    p = add_epsg_def (filter, first, last, 5458, "epsg", 5458,
        "Ocotepeque 1935 / Guatemala Norte (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Norte (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "16.81666666666667],PARAMETER[\"central_meridian\",-90.33");
    add_srs_wkt (p, 9,
        "333333333333],PARAMETER[\"scale_factor\",0.99992226],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",292209.579],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5458\"]]");
    p = add_epsg_def (filter, first, last, 5459, "epsg", 5459,
        "Ocotepeque 1935 / Guatemala Sur");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333");
    add_proj4text (p, 1,
        "333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +ellps=c");
    add_proj4text (p, 2,
        "lrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Sur\",GEOGCS[\"Ocot");
    add_srs_wkt (p, 1,
        "epeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",14.9],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.33333333333333],PARAMETER[\"scale_factor\",0.999899");
    add_srs_wkt (p, 10,
        "06],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",325992.681],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5459\"]]");
    p = add_epsg_def (filter, first, last, 5460, "epsg", 5460,
        "Ocotepeque 1935 / El Salvador Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.78333333333333 +lat_0=13.78333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-89 +k_0=0.99996704 +x_0=500000 +y_0=295809.1");
    add_proj4text (p, 2,
        "84 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / El Salvador Lambert\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Ocotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"545");
    add_srs_wkt (p, 7,
        "1\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",13.78333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-89],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "9996704],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",295809.184],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5460\"]]");
    p = add_epsg_def (filter, first, last, 5461, "epsg", 5461,
        "Ocotepeque 1935 / Nicaragua Norte");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.86666666666667 +lat_0=13.86666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-85.5 +k_0=0.99990314 +x_0=500000 +y_0=359891");
    add_proj4text (p, 2,
        ".816 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Nicaragua Norte\",GEOGCS[\"Oc");
    add_srs_wkt (p, 1,
        "otepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",13.86666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-85.5],PARAMETER[\"scale_factor\",0.99990");
    add_srs_wkt (p, 10,
        "314],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",359891.816],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"5461\"]]");
    p = add_epsg_def (filter, first, last, 5462, "epsg", 5462,
        "Ocotepeque 1935 / Nicaragua Sur");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=11.73333333333333 +lat_0=11.73333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-85.5 +k_0=0.9999222800000001 +x_0=500000 +y_");
    add_proj4text (p, 2,
        "0=288876.327 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0");
    add_proj4text (p, 3,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Nicaragua Sur\",GEOGCS[\"Ocot");
    add_srs_wkt (p, 1,
        "epeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",11.73333333333333],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-85.5],PARAMETER[\"scale_factor\",0.99992");
    add_srs_wkt (p, 10,
        "228],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",288876.327],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"5462\"]]");
    p = add_epsg_def (filter, first, last, 5463, "epsg", 5463,
        "SAD69 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-81],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5463\"]]");
    p = add_epsg_def (filter, first, last, 5464, "epsg", 5464,
        "Sibun Gorge 1922");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sibun Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1858\",6378293.645208759,294.2606763692");
    add_srs_wkt (p, 2,
        "569,AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 3,
        "071\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"5464\"]]");
    p = add_epsg_def (filter, first, last, 5466, "epsg", 5466,
        "Sibun Gorge 1922 / Colony Grid (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sibun Gorge 1922 / Colony Grid (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Sibun Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Clarke 1858\",6378293.645208759,294.26067636925");
    add_srs_wkt (p, 3,
        "69,AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"10");
    add_srs_wkt (p, 4,
        "71\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"5464\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",1");
    add_srs_wkt (p, 8,
        "7.06124194444444],PARAMETER[\"central_meridian\",-88.631");
    add_srs_wkt (p, 9,
        "8575],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",66220.02833082761],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "135779.5099885299],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5466\"]]");
    p = add_epsg_def (filter, first, last, 5467, "epsg", 5467,
        "Panama-Colon 1911");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Panama-Colon 1911\",DATUM[\"Panama_Colon_1911\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982139006,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AUTHORITY[\"EPSG\",\"5467\"]]");
    p = add_epsg_def (filter, first, last, 5469, "epsg", 5469,
        "Panama-Colon 1911 / Panama Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=8.416666666666666 +lat_0=8.416666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-80 +k_0=0.99989909 +x_0=500000 +y_0=294865.3");
    add_proj4text (p, 2,
        "03 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Panama-Colon 1911 / Panama Lambert\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "anama-Colon 1911\",DATUM[\"Panama_Colon_1911\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5467\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",8.416666");
    add_srs_wkt (p, 8,
        "666666666],PARAMETER[\"central_meridian\",-80],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.99989909],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",294865.303],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5469\"]]");
    p = add_epsg_def (filter, first, last, 5472, "epsg", 5472,
        "Panama-Colon 1911 / Panama Polyconic");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=8.25 +lon_0=-81 +x_0=914391.7962 +y_0=");
    add_proj4text (p, 1,
        "999404.7217154861 +ellps=clrk66 +to_meter=0.9143917962 +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Panama-Colon 1911 / Panama Polyconic\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Panama-Colon 1911\",DATUM[\"Panama_Colon_1911\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5467\"]],PROJECTION[\"Polyconic\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",8.25],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-81],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",1092972.1],UNIT[\"Clarke's yar");
    add_srs_wkt (p, 10,
        "d\",0.9143917962,AUTHORITY[\"EPSG\",\"9037\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5472\"]]");
    p = add_epsg_def (filter, first, last, 5479, "epsg", 5479,
        "RSRGD2000 / MSLC2000");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-78 +lon_0=163 +x_0=7000000 +y_0=5000000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / MSLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",-76.66666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",-79.33333333333333],PARAMETER[\"latitude_of_origin\",-7");
    add_srs_wkt (p, 10,
        "8],PARAMETER[\"central_meridian\",163],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",7000000],PARAMETER[\"false_northing\",5000000");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"5479\"]]");
    p = add_epsg_def (filter, first, last, 5480, "epsg", 5480,
        "RSRGD2000 / BCLC2000");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-73.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-74.5 +lon_0=165 +x_0=5000000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / BCLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",-73.66666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",-75.33333333333333],PARAMETER[\"latitude_of_origin\",-7");
    add_srs_wkt (p, 10,
        "4.5],PARAMETER[\"central_meridian\",165],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",5000000],PARAMETER[\"false_northing\",30000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5480\"]]");
    p = add_epsg_def (filter, first, last, 5481, "epsg", 5481,
        "RSRGD2000 / PCLC2000");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-70.66666666666667 +lat_2=-72.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-71.5 +lon_0=166 +x_0=3000000 +y_0=1000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / PCLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",-70.66666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",-72.33333333333333],PARAMETER[\"latitude_of_origin\",-7");
    add_srs_wkt (p, 10,
        "1.5],PARAMETER[\"central_meridian\",166],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",3000000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5481\"]]");
    p = add_epsg_def (filter, first, last, 5482, "epsg", 5482,
        "RSRGD2000 / RSPS2000");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=180 +k=0.994 +");
    add_proj4text (p, 1,
        "x_0=5000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / RSPS2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Polar");
    add_srs_wkt (p, 7,
        "_Stereographic\"],PARAMETER[\"latitude_of_origin\",-90],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",180],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.994],PARAMETER[\"false_easting\",5000000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5482\"]]");
    p = add_epsg_def (filter, first, last, 5489, "epsg", 5489,
        "RGAF09");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGAF09\",DATUM[\"Reseau_Geodesique_des_Antilles");
    add_srs_wkt (p, 1,
        "_Francaises_2009\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1073\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"5489\"]]");
    p = add_epsg_def (filter, first, last, 5490, "epsg", 5490,
        "RGAF09 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGAF09 / UTM zone 20N\",GEOGCS[\"RGAF09\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reseau_Geodesique_des_Antilles_Francaises_2009\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1073\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5489\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5490\"]]");
    p = add_epsg_def (filter, first, last, 5513, "epsg", 5513,
        "S-JTSK / Krovak");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha");
    add_proj4text (p, 1,
        "=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=589,76,480,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK / Krovak\",GEOGCS[\"S-JTSK\",DATUM[\"Sys");
    add_srs_wkt (p, 1,
        "tem_Jednotne_Trigonometricke_Site_Katastralni\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7004\"]],TOWGS84[589,76,480,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6156\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4156\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Krovak\"],PARAMETER[\"latitude_of_center\",49.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"longitude_of_center\",24.83333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"azimuth\",30.28813972222222],PARAMETER[\"pse");
    add_srs_wkt (p, 10,
        "udo_standard_parallel_1\",78.5],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",SOUTH],AXIS[\"Y\",WEST],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"5513\"]]");
    p = add_epsg_def (filter, first, last, 5514, "epsg", 5514,
        "S-JTSK / Krovak East North");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha");
    add_proj4text (p, 1,
        "=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=589,76,480,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK / Krovak East North\",GEOGCS[\"S-JTSK\",");
    add_srs_wkt (p, 1,
        "DATUM[\"System_Jednotne_Trigonometricke_Site_Katastralni");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7004\"]],TOWGS84[589,76,480,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6156\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "156\"]],PROJECTION[\"Krovak\"],PARAMETER[\"latitude_of_c");
    add_srs_wkt (p, 8,
        "enter\",49.5],PARAMETER[\"longitude_of_center\",24.83333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"azimuth\",30.28813972222222],PARA");
    add_srs_wkt (p, 10,
        "METER[\"pseudo_standard_parallel_1\",78.5],PARAMETER[\"s");
    add_srs_wkt (p, 11,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5514\"]]");
    p = add_epsg_def (filter, first, last, 5518, "epsg", 5518,
        "CI1971 / Chatham Islands Map Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y");
    add_proj4text (p, 1,
        "_0=650000 +ellps=intl +towgs84=175,-38,113,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CI1971 / Chatham Islands Map Grid\",GEOGCS[\"Ch");
    add_srs_wkt (p, 1,
        "atham Islands 1971\",DATUM[\"Chatham_Islands_Datum_1971\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[175,-38,113,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6672\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4672\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",-44],PARAMETER[\"central_meridian\",-176.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",350000],PARAMETER[\"false_northing\",650000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5518\"]]");
    p = add_epsg_def (filter, first, last, 5519, "epsg", 5519,
        "CI1979 / Chatham Islands Map Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y");
    add_proj4text (p, 1,
        "_0=650000 +ellps=intl +towgs84=174.05,-25.49,112.57,-0,-");
    add_proj4text (p, 2,
        "0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CI1979 / Chatham Islands Map Grid\",GEOGCS[\"Ch");
    add_srs_wkt (p, 1,
        "atham Islands 1979\",DATUM[\"Chatham_Islands_Datum_1979\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[174.05,-25.49,112.57,-0,-0,0.5");
    add_srs_wkt (p, 4,
        "54,0.2263],AUTHORITY[\"EPSG\",\"6673\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4673\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",-44],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-176.5],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",350000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",650000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AUTHORITY[\"EPSG\",\"5519\"]]");
    p = add_epsg_def (filter, first, last, 5520, "epsg", 5520,
        "DHDN / 3-degree Gauss-Kruger zone 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 1\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",1500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5520\"]]");
    p = add_epsg_def (filter, first, last, 5523, "epsg", 5523,
        "WGS 84 / Gabon TM 2011");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=1500000 ");
    add_proj4text (p, 1,
        "+y_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Gabon TM 2011\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 6,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"central_meridian\",11.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9996],PARAMETER[\"false_easting\",1500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 11,
        "ORTH],AUTHORITY[\"EPSG\",\"5523\"]]");
    p = add_epsg_def (filter, first, last, 5524, "epsg", 5524,
        "Corrego Alegre 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Corrego Alegre 1961\",DATUM[\"Corrego_Alegre_19");
    add_srs_wkt (p, 1,
        "61\",SPHEROID[\"International 1924\",6378388,297,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"5524\"]]");
    p = add_epsg_def (filter, first, last, 5527, "epsg", 5527,
        "SAD69(96)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-67.35,3.88,-38.22");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69(96)\",DATUM[\"South_American_Datum_1969_9");
    add_srs_wkt (p, 1,
        "6\",SPHEROID[\"GRS 1967 Modified\",6378160,298.25,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7050\"]],TOWGS84[-67.35,3.88,-38.22,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1075\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"5527\"]]");
    p = add_epsg_def (filter, first, last, 5530, "epsg", 5530,
        "SAD69(96) / Brazil Polyconic");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / Brazil Polyconic\",GEOGCS[\"SAD69(9");
    add_srs_wkt (p, 1,
        "6)\",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "050\"]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Polyconic\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-54],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",5000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5530\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def (filter, first, last, 5531, "epsg", 5531,
        "SAD69(96) / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 21S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5531\"]]");
    p = add_epsg_def (filter, first, last, 5532, "epsg", 5532,
        "SAD69(96) / UTM zone 22S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 22S (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"SAD69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7050\"]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6618\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5532\"]]");
    p = add_epsg_def (filter, first, last, 5533, "epsg", 5533,
        "SAD69(96) / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 23S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-45],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5533\"]]");
    p = add_epsg_def (filter, first, last, 5534, "epsg", 5534,
        "SAD69(96) / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 24S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-39],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5534\"]]");
    p = add_epsg_def (filter, first, last, 5535, "epsg", 5535,
        "SAD69(96) / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 25S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-33],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5535\"]]");
    p = add_epsg_def (filter, first, last, 5536, "epsg", 5536,
        "Corrego Alegre 1961 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 21S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5536\"]]");
    p = add_epsg_def (filter, first, last, 5537, "epsg", 5537,
        "Corrego Alegre 1961 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 22S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-51],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5537\"]]");
    p = add_epsg_def (filter, first, last, 5538, "epsg", 5538,
        "Corrego Alegre 1961 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 23S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-45],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5538\"]]");
    p = add_epsg_def (filter, first, last, 5539, "epsg", 5539,
        "Corrego Alegre 1961 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 24S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-39],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5539\"]]");
    p = add_epsg_def (filter, first, last, 5546, "epsg", 5546,
        "PNG94");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PNG94\",DATUM[\"Papua_New_Guinea_Geodetic_Datum");
    add_srs_wkt (p, 1,
        "_1994\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1076\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5546\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 5550, "epsg", 5550,
        "PNG94 / PNGMG94 zone 54");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 54\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",141],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5550\"]]");
    p = add_epsg_def (filter, first, last, 5551, "epsg", 5551,
        "PNG94 / PNGMG94 zone 55");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 55\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",147],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5551\"]]");
    p = add_epsg_def (filter, first, last, 5552, "epsg", 5552,
        "PNG94 / PNGMG94 zone 56");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 56\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",153],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5552\"]]");
    p = add_epsg_def (filter, first, last, 5559, "epsg", 5559,
        "Ocotepeque 1935 / Guatemala Norte");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +ellps=clrk66 +towgs84=213.11,9.37,-74");
    add_proj4text (p, 3,
        ".95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Norte\",GEOGCS[\"Oc");
    add_srs_wkt (p, 1,
        "otepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[213.11,9.37,-74.95,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",16.81666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-90.33333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.99992226],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",292209.579],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"5559\"]]");
    p = add_epsg_def (filter, first, last, 5561, "epsg", 5561,
        "UCS-2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=25,-141,-78.5,-0,0.3");
    add_proj4text (p, 1,
        "5,0.736,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Kr");
    add_srs_wkt (p, 1,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]]");
    p = add_epsg_def (filter, first, last, 5562, "epsg", 5562,
        "UCS-2000 / Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 4\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",21],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",4500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"5562\"]]");
    p = add_epsg_def (filter, first, last, 5563, "epsg", 5563,
        "UCS-2000 / Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 5\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",27],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",5500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"5563\"]]");
    p = add_epsg_def (filter, first, last, 5564, "epsg", 5564,
        "UCS-2000 / Gauss-Kruger zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 6\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",33],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",6500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"5564\"]]");
    p = add_epsg_def (filter, first, last, 5565, "epsg", 5565,
        "UCS-2000 / Gauss-Kruger zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 7\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",39],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",7500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"5565\"]]");
    p = add_epsg_def (filter, first, last, 5566, "epsg", 5566,
        "UCS-2000 / Gauss-Kruger CM 21E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 21E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",21],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"5566\"]]");
    p = add_epsg_def (filter, first, last, 5567, "epsg", 5567,
        "UCS-2000 / Gauss-Kruger CM 27E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 27E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",27],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"5567\"]]");
    p = add_epsg_def (filter, first, last, 5568, "epsg", 5568,
        "UCS-2000 / Gauss-Kruger CM 33E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 33E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",33],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"5568\"]]");
    p = add_epsg_def (filter, first, last, 5569, "epsg", 5569,
        "UCS-2000 / Gauss-Kruger CM 39E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 39E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,-0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",39],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"5569\"]]");
    p = add_epsg_def (filter, first, last, 5570, "epsg", 5570,
        "UCS-2000 / 3-degree Gauss-Kruger zone 7 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 7 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",21],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",7500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "70\"]]");
    p = add_epsg_def (filter, first, last, 5571, "epsg", 5571,
        "UCS-2000 / 3-degree Gauss-Kruger zone 8 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 8 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",24],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",8500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "71\"]]");
    p = add_epsg_def (filter, first, last, 5572, "epsg", 5572,
        "UCS-2000 / 3-degree Gauss-Kruger zone 9 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 9 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",27],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",9500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "72\"]]");
    p = add_epsg_def (filter, first, last, 5573, "epsg", 5573,
        "UCS-2000 / 3-degree Gauss-Kruger zone 10 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 10 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",30],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",10500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "73\"]]");
    p = add_epsg_def (filter, first, last, 5574, "epsg", 5574,
        "UCS-2000 / 3-degree Gauss-Kruger zone 11 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 11 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",33],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",11500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "74\"]]");
    p = add_epsg_def (filter, first, last, 5575, "epsg", 5575,
        "UCS-2000 / 3-degree Gauss-Kruger zone 12 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 12 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",12500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "75\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

