/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_28 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 6054, "epsg", 6054,
        "GR96 / EPSG Arctic zone 3-31");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-39 +x_0=31500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-31\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",80.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",78.70733752777778],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-39],PARAMETER[\"false_easting\",31500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6054\"]]");
    p = add_epsg_def (filter, first, last, 6055, "epsg", 6055,
        "GR96 / EPSG Arctic zone 3-33");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-10 +x_0=33500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-33\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",80.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",78.70733752777778],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-10],PARAMETER[\"false_easting\",33500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6055\"]]");
    p = add_epsg_def (filter, first, last, 6056, "epsg", 6056,
        "GR96 / EPSG Arctic zone 4-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-64 +x_0=20500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",77],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",73.66666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",75.36440330555556],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-64],PARAMETER[\"false_easting\",20500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",4500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6056\"]]");
    p = add_epsg_def (filter, first, last, 6057, "epsg", 6057,
        "GR96 / EPSG Arctic zone 4-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-39 +x_0=22500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",77],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",73.66666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",75.36440330555556],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-39],PARAMETER[\"false_easting\",22500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",4500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6057\"]]");
    p = add_epsg_def (filter, first, last, 6058, "epsg", 6058,
        "GR96 / EPSG Arctic zone 4-24");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-14 +x_0=24500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-24\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",77],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",73.66666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",75.36440330555556],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-14],PARAMETER[\"false_easting\",24500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",4500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6058\"]]");
    p = add_epsg_def (filter, first, last, 6059, "epsg", 6059,
        "GR96 / EPSG Arctic zone 5-41");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-62 +x_0=41500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-41\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",73.66666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"standard_parallel_2\",70.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",72.02500919444445],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-62],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",41500000],PARAMETER[\"false_northing\",5500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6059\"]]");
    p = add_epsg_def (filter, first, last, 6060, "epsg", 6060,
        "GR96 / EPSG Arctic zone 5-43");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-42 +x_0=43500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-43\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",73.66666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"standard_parallel_2\",70.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",72.02500919444445],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-42],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",43500000],PARAMETER[\"false_northing\",5500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6060\"]]");
    p = add_epsg_def (filter, first, last, 6061, "epsg", 6061,
        "GR96 / EPSG Arctic zone 5-45");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-22 +x_0=45500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-45\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",73.66666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"standard_parallel_2\",70.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",72.02500919444445],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-22],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",45500000],PARAMETER[\"false_northing\",5500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6061\"]]");
    p = add_epsg_def (filter, first, last, 6062, "epsg", 6062,
        "GR96 / EPSG Arctic zone 6-26");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-56 +x_0=26500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-26\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",70.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",67],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",68.68747555555557],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-56],PARAMETER[\"false_easting\",26500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6062\"]]");
    p = add_epsg_def (filter, first, last, 6063, "epsg", 6063,
        "GR96 / EPSG Arctic zone 6-28");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-38 +x_0=28500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-28\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",70.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",67],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",68.68747555555557],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-38],PARAMETER[\"false_easting\",28500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6063\"]]");
    p = add_epsg_def (filter, first, last, 6064, "epsg", 6064,
        "GR96 / EPSG Arctic zone 6-30");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-20 +x_0=30500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-30\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",70.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",67],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",68.68747555555557],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-20],PARAMETER[\"false_easting\",30500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6064\"]]");
    p = add_epsg_def (filter, first, last, 6065, "epsg", 6065,
        "GR96 / EPSG Arctic zone 7-11");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-51 +x_0=11500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-11\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",67],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",63.66666666666666],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",65.35103930555555],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-51],PARAMETER[\"false_easting\",11500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",7500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6065\"]]");
    p = add_epsg_def (filter, first, last, 6066, "epsg", 6066,
        "GR96 / EPSG Arctic zone 7-13");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-34 +x_0=13500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-13\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",67],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",63.66666666666666],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",65.35103930555555],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-34],PARAMETER[\"false_easting\",13500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",7500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6066\"]]");
    p = add_epsg_def (filter, first, last, 6067, "epsg", 6067,
        "GR96 / EPSG Arctic zone 8-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-52 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",63.66666666666");
    add_srs_wkt (p, 8,
        "666],PARAMETER[\"standard_parallel_2\",60.33333333333334");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",62.01530688888889],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-52],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",20500000],PARAMETER[\"false_northing\",8500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6067\"]]");
    p = add_epsg_def (filter, first, last, 6068, "epsg", 6068,
        "GR96 / EPSG Arctic zone 8-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-37 +x_0=22500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",63.66666666666");
    add_srs_wkt (p, 8,
        "666],PARAMETER[\"standard_parallel_2\",60.33333333333334");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",62.01530688888889],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-37],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",22500000],PARAMETER[\"false_northing\",8500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6068\"]]");
    p = add_epsg_def (filter, first, last, 6069, "epsg", 6069,
        "ETRS89 / EPSG Arctic zone 2-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=16 +x_0=22500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 2-22\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",83.66666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",80.33333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",82.05842488888888],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 11,
        "n\",16],PARAMETER[\"false_easting\",22500000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6069\"]]");
    p = add_epsg_def (filter, first, last, 6070, "epsg", 6070,
        "ETRS89 / EPSG Arctic zone 3-11");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=21 +x_0=11500000 +y_0=3500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 3-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",80.33333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70");
    add_srs_wkt (p, 10,
        "733752777778],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",11500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6070\"]]");
    p = add_epsg_def (filter, first, last, 6071, "epsg", 6071,
        "ETRS89 / EPSG Arctic zone 4-26");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=10 +x_0=26500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-26\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",77],PARAMETER[\"standard_parallel_2\",7");
    add_srs_wkt (p, 9,
        "3.66666666666667],PARAMETER[\"latitude_of_origin\",75.36");
    add_srs_wkt (p, 10,
        "440330555556],PARAMETER[\"central_meridian\",10],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",26500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6071\"]]");
    p = add_epsg_def (filter, first, last, 6072, "epsg", 6072,
        "ETRS89 / EPSG Arctic zone 4-28");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=34 +x_0=28500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-28\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",77],PARAMETER[\"standard_parallel_2\",7");
    add_srs_wkt (p, 9,
        "3.66666666666667],PARAMETER[\"latitude_of_origin\",75.36");
    add_srs_wkt (p, 10,
        "440330555556],PARAMETER[\"central_meridian\",34],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",28500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6072\"]]");
    p = add_epsg_def (filter, first, last, 6073, "epsg", 6073,
        "ETRS89 / EPSG Arctic zone 5-11");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=14 +x_0=11500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",73.66666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",70.33333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",72.02500919444445],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 11,
        "n\",14],PARAMETER[\"false_easting\",11500000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6073\"]]");
    p = add_epsg_def (filter, first, last, 6074, "epsg", 6074,
        "ETRS89 / EPSG Arctic zone 5-13");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=34 +x_0=13500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-13\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",73.66666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",70.33333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",72.02500919444445],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 11,
        "n\",34],PARAMETER[\"false_easting\",13500000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6074\"]]");
    p = add_epsg_def (filter, first, last, 6075, "epsg", 6075,
        "WGS 84 / EPSG Arctic zone 2-24");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=53 +x_0=24500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-24\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",83.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",80.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",82.05842488888888],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",53],PARAMETER[\"false_easting\",24500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6075\"]]");
    p = add_epsg_def (filter, first, last, 6076, "epsg", 6076,
        "WGS 84 / EPSG Arctic zone 2-26");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=93 +x_0=26500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-26\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",83.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",80.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",82.05842488888888],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",93],PARAMETER[\"false_easting\",26500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6076\"]]");
    p = add_epsg_def (filter, first, last, 6077, "epsg", 6077,
        "WGS 84 / EPSG Arctic zone 3-13");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=52 +x_0=13500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-13\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",52],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",13500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6077\"]]");
    p = add_epsg_def (filter, first, last, 6078, "epsg", 6078,
        "WGS 84 / EPSG Arctic zone 3-15");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=83 +x_0=15500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",83],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",15500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6078\"]]");
    p = add_epsg_def (filter, first, last, 6079, "epsg", 6079,
        "WGS 84 / EPSG Arctic zone 3-17");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=114 +x_0=17500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",114],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",17500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6079\"]]");
    p = add_epsg_def (filter, first, last, 6080, "epsg", 6080,
        "WGS 84 / EPSG Arctic zone 3-19");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=145 +x_0=19500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",145],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",19500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6080\"]]");
    p = add_epsg_def (filter, first, last, 6081, "epsg", 6081,
        "WGS 84 / EPSG Arctic zone 4-30");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=58 +x_0=30500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-30\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",58],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",30500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6081\"]]");
    p = add_epsg_def (filter, first, last, 6082, "epsg", 6082,
        "WGS 84 / EPSG Arctic zone 4-32");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=82 +x_0=32500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-32\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",82],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",32500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6082\"]]");
    p = add_epsg_def (filter, first, last, 6083, "epsg", 6083,
        "WGS 84 / EPSG Arctic zone 4-34");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=106 +x_0=34500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-34\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",106],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",34500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6083\"]]");
    p = add_epsg_def (filter, first, last, 6084, "epsg", 6084,
        "WGS 84 / EPSG Arctic zone 4-36");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=130 +x_0=36500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-36\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",130],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",36500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6084\"]]");
    p = add_epsg_def (filter, first, last, 6085, "epsg", 6085,
        "WGS 84 / EPSG Arctic zone 4-38");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=154 +x_0=38500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-38\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",154],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",38500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6085\"]]");
    p = add_epsg_def (filter, first, last, 6086, "epsg", 6086,
        "WGS 84 / EPSG Arctic zone 4-40");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=179 +x_0=40500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-40\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",179],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",40500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6086\"]]");
    p = add_epsg_def (filter, first, last, 6087, "epsg", 6087,
        "WGS 84 / EPSG Arctic zone 5-15");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=54 +x_0=15500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",54],PARAMETER[\"false_easting\",15500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6087\"]]");
    p = add_epsg_def (filter, first, last, 6088, "epsg", 6088,
        "WGS 84 / EPSG Arctic zone 5-17");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=74 +x_0=17500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",74],PARAMETER[\"false_easting\",17500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6088\"]]");
    p = add_epsg_def (filter, first, last, 6089, "epsg", 6089,
        "WGS 84 / EPSG Arctic zone 5-19");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=95 +x_0=19500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",95],PARAMETER[\"false_easting\",19500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6089\"]]");
    p = add_epsg_def (filter, first, last, 6090, "epsg", 6090,
        "WGS 84 / EPSG Arctic zone 5-21");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=116 +x_0=21500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",116],PARAMETER[\"false_easting\",21500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6090\"]]");
    p = add_epsg_def (filter, first, last, 6091, "epsg", 6091,
        "WGS 84 / EPSG Arctic zone 5-23");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=137 +x_0=23500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",137],PARAMETER[\"false_easting\",23500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6091\"]]");
    p = add_epsg_def (filter, first, last, 6092, "epsg", 6092,
        "WGS 84 / EPSG Arctic zone 5-25");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=158 +x_0=25500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-25\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",158],PARAMETER[\"false_easting\",25500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6092\"]]");
    p = add_epsg_def (filter, first, last, 6093, "epsg", 6093,
        "WGS 84 / EPSG Arctic zone 5-27");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=179 +x_0=27500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",73.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",70.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",72.02500919444445],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",179],PARAMETER[\"false_easting\",27500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6093\"]]");
    p = add_epsg_def (filter, first, last, 6094, "epsg", 6094,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-29");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-163 +x_0=29500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-29\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",73.66666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",70.33333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",72.02500919444445],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-163],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",29500000],PARAMETER[\"false_northing\",5500000],UNIT[");
    add_srs_wkt (p, 13,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "094\"]]");
    p = add_epsg_def (filter, first, last, 6095, "epsg", 6095,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-31");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-147 +x_0=31500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-31\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",73.66666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",70.33333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",72.02500919444445],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-147],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",31500000],PARAMETER[\"false_northing\",5500000],UNIT[");
    add_srs_wkt (p, 13,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "095\"]]");
    p = add_epsg_def (filter, first, last, 6096, "epsg", 6096,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-14");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-165 +x_0=14500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-14\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",70.33333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",67],PARAMETER[\"latit");
    add_srs_wkt (p, 10,
        "ude_of_origin\",68.68747555555557],PARAMETER[\"central_m");
    add_srs_wkt (p, 11,
        "eridian\",-165],PARAMETER[\"false_easting\",14500000],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"6096\"]]");
    p = add_epsg_def (filter, first, last, 6097, "epsg", 6097,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-16");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-147 +x_0=16500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-16\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",70.33333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",67],PARAMETER[\"latit");
    add_srs_wkt (p, 10,
        "ude_of_origin\",68.68747555555557],PARAMETER[\"central_m");
    add_srs_wkt (p, 11,
        "eridian\",-147],PARAMETER[\"false_easting\",16500000],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"6097\"]]");
    p = add_epsg_def (filter, first, last, 6098, "epsg", 6098,
        "NAD83(CSRS) / EPSG Arctic zone 1-23");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-90 +x_0=23500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 1-23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",87],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_2\",83.66666666666667],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",85.43711833333333],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",23500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6098\"]]");
    p = add_epsg_def (filter, first, last, 6099, "epsg", 6099,
        "NAD83(CSRS) / EPSG Arctic zone 2-14");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-115 +x_0=14500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",83.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",80.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",82.05842488888888],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-115],PARAMETER[\"false_easting\",14500000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",2500000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6099\"]]");
    p = add_epsg_def (filter, first, last, 6100, "epsg", 6100,
        "NAD83(CSRS) / EPSG Arctic zone 2-16");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-75 +x_0=16500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",83.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",80.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",82.05842488888888],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-75],PARAMETER[\"false_easting\",16500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6100\"]]");
    p = add_epsg_def (filter, first, last, 6101, "epsg", 6101,
        "NAD83(CSRS) / EPSG Arctic zone 3-25");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-129 +x_0=25500000 +y_0=3500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",80.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",77],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",78.70733752777778],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 11,
        "9],PARAMETER[\"false_easting\",25500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6101\"]]");
    p = add_epsg_def (filter, first, last, 6102, "epsg", 6102,
        "NAD83(CSRS) / EPSG Arctic zone 3-27");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-99 +x_0=27500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",80.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",77],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",78.70733752777778],PARAMETER[\"central_meridian\",-99");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",27500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6102\"]]");
    p = add_epsg_def (filter, first, last, 6103, "epsg", 6103,
        "NAD83(CSRS) / EPSG Arctic zone 3-29");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",80.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",77],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",78.70733752777778],PARAMETER[\"central_meridian\",-69");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",29500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6103\"]]");
    p = add_epsg_def (filter, first, last, 6104, "epsg", 6104,
        "NAD83(CSRS) / EPSG Arctic zone 4-14");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-129 +x_0=14500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",77],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_2\",73.66666666666667],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",75.36440330555556],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 11,
        "9],PARAMETER[\"false_easting\",14500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6104\"]]");
    p = add_epsg_def (filter, first, last, 6105, "epsg", 6105,
        "NAD83(CSRS) / EPSG Arctic zone 4-16");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-104 +x_0=16500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",77],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_2\",73.66666666666667],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",75.36440330555556],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 11,
        "4],PARAMETER[\"false_easting\",16500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6105\"]]");
    p = add_epsg_def (filter, first, last, 6106, "epsg", 6106,
        "NAD83(CSRS) / EPSG Arctic zone 4-18");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-79 +x_0=18500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",77],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_2\",73.66666666666667],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",75.36440330555556],PARAMETER[\"central_meridian\",-79");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",18500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6106\"]]");
    p = add_epsg_def (filter, first, last, 6107, "epsg", 6107,
        "NAD83(CSRS) / EPSG Arctic zone 5-33");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-131 +x_0=33500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-33\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",73.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",70.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",72.02500919444445],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-131],PARAMETER[\"false_easting\",33500000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6107\"]]");
    p = add_epsg_def (filter, first, last, 6108, "epsg", 6108,
        "NAD83(CSRS) / EPSG Arctic zone 5-35");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-111 +x_0=35500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-35\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",73.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",70.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",72.02500919444445],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-111],PARAMETER[\"false_easting\",35500000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6108\"]]");
    p = add_epsg_def (filter, first, last, 6109, "epsg", 6109,
        "NAD83(CSRS) / EPSG Arctic zone 5-37");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-91 +x_0=37500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-37\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",73.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",70.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",72.02500919444445],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-91],PARAMETER[\"false_easting\",37500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6109\"]]");
    p = add_epsg_def (filter, first, last, 6110, "epsg", 6110,
        "NAD83(CSRS) / EPSG Arctic zone 5-39");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-71 +x_0=39500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-39\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",73.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",70.33333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",72.02500919444445],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-71],PARAMETER[\"false_easting\",39500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6110\"]]");
    p = add_epsg_def (filter, first, last, 6111, "epsg", 6111,
        "NAD83(CSRS) / EPSG Arctic zone 6-18");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-132 +x_0=18500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",70.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",67],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",68.68747555555557],PARAMETER[\"central_meridian\",-13");
    add_srs_wkt (p, 11,
        "2],PARAMETER[\"false_easting\",18500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6111\"]]");
    p = add_epsg_def (filter, first, last, 6112, "epsg", 6112,
        "NAD83(CSRS) / EPSG Arctic zone 6-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-113 +x_0=20500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",70.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",67],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",68.68747555555557],PARAMETER[\"central_meridian\",-11");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_easting\",20500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6112\"]]");
    p = add_epsg_def (filter, first, last, 6113, "epsg", 6113,
        "NAD83(CSRS) / EPSG Arctic zone 6-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-94 +x_0=22500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",70.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",67],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",68.68747555555557],PARAMETER[\"central_meridian\",-94");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",22500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6113\"]]");
    p = add_epsg_def (filter, first, last, 6114, "epsg", 6114,
        "NAD83(CSRS) / EPSG Arctic zone 6-24");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-75 +x_0=24500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",70.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",67],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",68.68747555555557],PARAMETER[\"central_meridian\",-75");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",24500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6114\"]]");
    p = add_epsg_def (filter, first, last, 6115, "epsg", 6115,
        "WGS 84 / EPSG Arctic zone 1-27");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=30 +x_0=27500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",87],PARAMETER[\"standard_parallel_2\",83.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",85.43711");
    add_srs_wkt (p, 9,
        "833333333],PARAMETER[\"central_meridian\",30],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",27500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6115\"]]");
    p = add_epsg_def (filter, first, last, 6116, "epsg", 6116,
        "WGS 84 / EPSG Arctic zone 1-29");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=90 +x_0=29500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-29\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",87],PARAMETER[\"standard_parallel_2\",83.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",85.43711");
    add_srs_wkt (p, 9,
        "833333333],PARAMETER[\"central_meridian\",90],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",29500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6116\"]]");
    p = add_epsg_def (filter, first, last, 6117, "epsg", 6117,
        "WGS 84 / EPSG Arctic zone 1-31");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=150 +x_0=31500000 +y_0=1500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-31\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",87],PARAMETER[\"standard_parallel_2\",83.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",85.43711");
    add_srs_wkt (p, 9,
        "833333333],PARAMETER[\"central_meridian\",150],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",31500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6117\"]]");
    p = add_epsg_def (filter, first, last, 6118, "epsg", 6118,
        "WGS 84 / EPSG Arctic zone 1-21");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-150 +x_0=21500000 +y_0=1500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",87],PARAMETER[\"standard_parallel_2\",83.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",85.43711");
    add_srs_wkt (p, 9,
        "833333333],PARAMETER[\"central_meridian\",-150],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",21500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6118\"]]");
    p = add_epsg_def (filter, first, last, 6119, "epsg", 6119,
        "WGS 84 / EPSG Arctic zone 2-28");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=133 +x_0=28500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-28\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",83.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",80.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",82.05842488888888],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",133],PARAMETER[\"false_easting\",28500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6119\"]]");
    p = add_epsg_def (filter, first, last, 6120, "epsg", 6120,
        "WGS 84 / EPSG Arctic zone 2-10");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=166 +x_0=10500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-10\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",83.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",80.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",82.05842488888888],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",166],PARAMETER[\"false_easting\",10500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6120\"]]");
    p = add_epsg_def (filter, first, last, 6121, "epsg", 6121,
        "WGS 84 / EPSG Arctic zone 2-12");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-154 +x_0=12500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",83.66666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",80.33333333333333],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",82.05842488888888],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-154],PARAMETER[\"false_easting\",12500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6121\"]]");
    p = add_epsg_def (filter, first, last, 6122, "epsg", 6122,
        "WGS 84 / EPSG Arctic zone 3-21");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=176 +x_0=21500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",176],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",21500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6122\"]]");
    p = add_epsg_def (filter, first, last, 6123, "epsg", 6123,
        "WGS 84 / EPSG Arctic zone 3-23");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-153 +x_0=23500000 +y_0=3500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",80.33333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 9,
        "752777778],PARAMETER[\"central_meridian\",-153],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",23500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6123\"]]");
    p = add_epsg_def (filter, first, last, 6124, "epsg", 6124,
        "WGS 84 / EPSG Arctic zone 4-12");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-155 +x_0=12500000 +y_0=4500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 7,
        "_parallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 9,
        "330555556],PARAMETER[\"central_meridian\",-155],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",12500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6124\"]]");
    p = add_epsg_def (filter, first, last, 6125, "epsg", 6125,
        "ETRS89 / EPSG Arctic zone 5-47");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-5 +x_0=47500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-47\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",73.66666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",70.33333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",72.02500919444445],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 11,
        "n\",-5],PARAMETER[\"false_easting\",47500000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6125\"]]");
    p = add_epsg_def (filter, first, last, 6128, "epsg", 6128,
        "Grand Cayman National Grid 1959");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.3");
    add_proj4text (p, 1,
        "79,-27.584,-7.862,8.163,6.042,-13.925 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grand Cayman National Grid 1959\",GEOGCS[\"GCGD");
    add_srs_wkt (p, 1,
        "59\",DATUM[\"Grand_Cayman_Geodetic_Datum_1959\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],TOWGS84[-179.483,-69.379,-27.584,-7.86");
    add_srs_wkt (p, 4,
        "2,8.163,6.042,-13.925],AUTHORITY[\"EPSG\",\"6723\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4723\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-81],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",1640419.9475],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"6128\"]]");
    p = add_epsg_def (filter, first, last, 6129, "epsg", 6129,
        "Sister Islands National Grid 1961");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,");
    add_proj4text (p, 1,
        "180.304,-0.393,-2.323,2.96,-24.081 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sister Islands National Grid 1961\",GEOGCS[\"SI");
    add_srs_wkt (p, 1,
        "GD61\",DATUM[\"Sister_Islands_Geodetic_Datum_1961\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7008\"]],TOWGS84[8.853,-52.644,180.304,-0.");
    add_srs_wkt (p, 4,
        "393,-2.323,2.96,-24.081],AUTHORITY[\"EPSG\",\"6726\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 6,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 7,
        "\"]],AUTHORITY[\"EPSG\",\"4726\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-81],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",1640419.9475],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6129\"]]");
    p = add_epsg_def (filter, first, last, 6135, "epsg", 6135,
        "CIGD11");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CIGD11\",DATUM[\"Cayman_Islands_Geodetic_Datum_");
    add_srs_wkt (p, 1,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"1100\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6135\"]]");
    p = add_epsg_def (filter, first, last, 6141, "epsg", 6141,
        "Cayman Islands National Grid 2011 (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19.33333333333333 +lat_2=19.7 +lat_0=19");
    add_proj4text (p, 1,
        ".33333333333333 +lon_0=80.56666666666666 +x_0=899160 +y_");
    add_proj4text (p, 2,
        "0=579120 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cayman Islands National Grid 2011 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"CIGD11\",DATUM[\"Cayman_Islands_Geodetic_Datum");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1100\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6135\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",19.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",19.7],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 10,
        "in\",19.33333333333333],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 11,
        "0.56666666666666],PARAMETER[\"false_easting\",2950000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",1900000],UNIT[\"foot\",0.304");
    add_srs_wkt (p, 13,
        "8,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6141\"]]");
    p = add_epsg_def (filter, first, last, 6204, "epsg", 6204,
        "Macedonian State Coordinate System");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Macedonian State Coordinate System\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",21],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"6204\"]]");
    p = add_epsg_def (filter, first, last, 6207, "epsg", 6207,
        "Nepal 1981");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=293.17,726.18,245.36,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nepal 1981\",DATUM[\"Nepal_1981\",SPHEROID[\"Ev");
    add_srs_wkt (p, 1,
        "erest 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7015\"]],TOWGS84[293.17,726.18,245.36,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"1111\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"6207\"]]");
    p = add_epsg_def (filter, first, last, 6210, "epsg", 6210,
        "SIRGAS 2000 / UTM zone 23N");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 23N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "6210\"]]");
    p = add_epsg_def (filter, first, last, 6211, "epsg", 6211,
        "SIRGAS 2000 / UTM zone 24N");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 24N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "6211\"]]");
    p = add_epsg_def (filter, first, last, 6316, "epsg", 6316,
        "Macedonia State Coordinate System zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Macedonia State Coordinate System zone 7\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"103");
    add_srs_wkt (p, 4,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",7500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"6316\"]]");
    p = add_epsg_def (filter, first, last, 6318, "epsg", 6318,
        "NAD83(2011)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    p = add_epsg_def (filter, first, last, 6322, "epsg", 6322,
        "NAD83(PA11)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(PA11)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_PA11\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1117\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6322\"]]");
    p = add_epsg_def (filter, first, last, 6325, "epsg", 6325,
        "NAD83(MA11)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(MA11)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_MA11\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1118\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6325\"]]");
    p = add_epsg_def (filter, first, last, 6328, "epsg", 6328,
        "NAD83(2011) / UTM zone 59N");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 59N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",171],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6328\"]]");
    p = add_epsg_def (filter, first, last, 6329, "epsg", 6329,
        "NAD83(2011) / UTM zone 60N");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 60N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",177],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6329\"]]");
    p = add_epsg_def (filter, first, last, 6330, "epsg", 6330,
        "NAD83(2011) / UTM zone 1N");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 1N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-177],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6330\"]]");
    p = add_epsg_def (filter, first, last, 6331, "epsg", 6331,
        "NAD83(2011) / UTM zone 2N");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 2N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-171],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6331\"]]");
    p = add_epsg_def (filter, first, last, 6332, "epsg", 6332,
        "NAD83(2011) / UTM zone 3N");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 3N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-165],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6332\"]]");
    p = add_epsg_def (filter, first, last, 6333, "epsg", 6333,
        "NAD83(2011) / UTM zone 4N");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 4N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-159],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6333\"]]");
    p = add_epsg_def (filter, first, last, 6334, "epsg", 6334,
        "NAD83(2011) / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 5N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-153],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6334\"]]");
    p = add_epsg_def (filter, first, last, 6335, "epsg", 6335,
        "NAD83(2011) / UTM zone 6N");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 6N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-147],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6335\"]]");
    p = add_epsg_def (filter, first, last, 6336, "epsg", 6336,
        "NAD83(2011) / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 7N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-141],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6336\"]]");
    p = add_epsg_def (filter, first, last, 6337, "epsg", 6337,
        "NAD83(2011) / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 8N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-135],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6337\"]]");
    p = add_epsg_def (filter, first, last, 6338, "epsg", 6338,
        "NAD83(2011) / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 9N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-129],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6338\"]]");
    p = add_epsg_def (filter, first, last, 6339, "epsg", 6339,
        "NAD83(2011) / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 10N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-123],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"6339\"]]");
    p = add_epsg_def (filter, first, last, 6340, "epsg", 6340,
        "NAD83(2011) / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 11N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-117],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"6340\"]]");
    p = add_epsg_def (filter, first, last, 6341, "epsg", 6341,
        "NAD83(2011) / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 12N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-111],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"6341\"]]");
    p = add_epsg_def (filter, first, last, 6342, "epsg", 6342,
        "NAD83(2011) / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 13N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-105],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"6342\"]]");
    p = add_epsg_def (filter, first, last, 6343, "epsg", 6343,
        "NAD83(2011) / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 14N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-99],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6343\"]]");
    p = add_epsg_def (filter, first, last, 6344, "epsg", 6344,
        "NAD83(2011) / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 15N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-93],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6344\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

