var dev_guides =
[
    [ "Building OCCT from sources", "occt_dev_guides__building.html", "occt_dev_guides__building" ],
    [ "Documentation System", "occt_dev_guides__documentation.html", [
      [ "Introduction", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_1", null ],
      [ "Prerequisites", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_2", null ],
      [ "Documentation Generation", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_2_1", null ],
      [ "Documentation Conventions", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3", [
        [ "File Format", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3_1", null ],
        [ "Directory Structure", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3_2", null ]
      ] ],
      [ "Adding a New Document", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_4", null ],
      [ "Additional Resources", "occt_dev_guides__documentation.html#OCCT_DOC_SECTION_5", null ],
      [ "Appendix 1: Document Syntax", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A", [
        [ "Headers and hierarchic document structure", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_1", null ],
        [ "Plain Text", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_2", null ],
        [ "Lists", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_3", null ],
        [ "Tables", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_4", null ],
        [ "Code Blocks", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_5", null ],
        [ "References", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_6", null ],
        [ "Images", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_7", null ],
        [ "Table Of Contents", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_8", null ],
        [ "Formulas", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_9", null ]
      ] ]
    ] ],
    [ "Coding Rules", "occt_dev_guides__coding_rules.html", [
      [ "Introduction", "occt_dev_guides__coding_rules.html#occt_coding_rules_1", [
        [ "Scope of the document", "occt_dev_guides__coding_rules.html#occt_coding_rules_1_1", null ]
      ] ],
      [ "Naming Conventions", "occt_dev_guides__coding_rules.html#occt_coding_rules_2", [
        [ "General naming rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_1", null ],
        [ "Names of development units", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_2", null ],
        [ "Names of variables", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_3", null ]
      ] ],
      [ "Formatting rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_3", null ],
      [ "Documentation rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_4", null ],
      [ "Application design", "occt_dev_guides__coding_rules.html#occt_coding_rules_5", null ],
      [ "General C/C++ rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_6", null ],
      [ "Portability issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_7", null ],
      [ "Stability issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_8", null ],
      [ "Performance issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_9", null ],
      [ "Draw Harness command", "occt_dev_guides__coding_rules.html#occt_coding_rules_10", null ],
      [ "Examples", "occt_dev_guides__coding_rules.html#occt_coding_rules_11", null ]
    ] ],
    [ "Contribution Workflow", "occt_dev_guides__contribution_workflow.html", [
      [ "Introduction", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_1", [
        [ "Use of issue tracker system", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_1_1", null ],
        [ "Access Levels", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_1_2", null ]
      ] ],
      [ "Typical workflow for an issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2", [
        [ "General scheme", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_1", null ],
        [ "Issue registration", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_2", null ],
        [ "Assigning the issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_3", null ],
        [ "Resolving the issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_4", null ],
        [ "Code review", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_5", null ],
        [ "Testing", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_6", null ],
        [ "Integration of a solution", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_7", null ],
        [ "Closing a bug", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_8", null ],
        [ "Reopening a bug", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_2_9", null ]
      ] ],
      [ "Appendix", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3", [
        [ "Issue attributes", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_1", [
          [ "Severity", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_1_1", null ],
          [ "Statuses of issues", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_1_2", null ],
          [ "Resolutions", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_1_3", null ]
        ] ],
        [ "Update and evolution of documentation", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_2", [
          [ "Maintenance of CDL files", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_2_1", null ],
          [ "Maintenance of the User’s Reference Documentation", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_3_2_2", null ]
        ] ]
      ] ]
    ] ],
    [ "Guide to installing and using Git for OCCT development", "occt_dev_guides__git_guide.html", [
      [ "Overview", "occt_dev_guides__git_guide.html#occt_gitguide_1", [
        [ "Purpose", "occt_dev_guides__git_guide.html#occt_gitguide_1_1", null ],
        [ "Git URL", "occt_dev_guides__git_guide.html#occt_gitguide_1_2", null ],
        [ "Content", "occt_dev_guides__git_guide.html#occt_gitguide_1_3", null ],
        [ "Short rules of use", "occt_dev_guides__git_guide.html#occt_gitguide_1_4", null ],
        [ "Version of Git", "occt_dev_guides__git_guide.html#occt_gitguide_1_5", null ]
      ] ],
      [ "Installing Tools for Work with Git", "occt_dev_guides__git_guide.html#occt_gitguide_2", [
        [ "Windows platform", "occt_dev_guides__git_guide.html#occt_gitguide_2_1", [
          [ "Installation of Git for Windows", "occt_dev_guides__git_guide.html#occt_gitguide_2_1_1", null ],
          [ "Installation and configuration of TortoiseGit", "occt_dev_guides__git_guide.html#occt_gitguide_2_1_2", null ]
        ] ],
        [ "Linux platform", "occt_dev_guides__git_guide.html#occt_gitguide_2_2", null ]
      ] ],
      [ "Getting access to the repository", "occt_dev_guides__git_guide.html#occt_gitguide_3", [
        [ "Prerequisites", "occt_dev_guides__git_guide.html#occt_gitguide_3_1", null ],
        [ "How to generate a key", "occt_dev_guides__git_guide.html#occt_gitguide_3_2", [
          [ "Generating key with Putty", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_1", null ],
          [ "Generating key with command-line tools", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_2", null ],
          [ "Generating key with Git GUI", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_3", null ]
        ] ],
        [ "Adding public key in your account", "occt_dev_guides__git_guide.html#occt_gitguide_3_3", null ]
      ] ],
      [ "Work with repository: developer operations", "occt_dev_guides__git_guide.html#occt_gitguide_4", [
        [ "General workflow", "occt_dev_guides__git_guide.html#occt_gitguide_4_1", null ],
        [ "Cloning official repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_2", null ],
        [ "Branch creation", "occt_dev_guides__git_guide.html#occt_gitguide_4_3", null ],
        [ "Branch switching", "occt_dev_guides__git_guide.html#occt_gitguide_4_4", null ],
        [ "Committing branch changes", "occt_dev_guides__git_guide.html#occt_gitguide_4_5", null ],
        [ "Pushing branch to the remote repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_6", null ],
        [ "Synchronizing with remote repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_7", null ],
        [ "Applying a fix made on older version of OCCT", "occt_dev_guides__git_guide.html#occt_gitguide_4_8", null ],
        [ "Rebasing with history clean-up", "occt_dev_guides__git_guide.html#occt_gitguide_4_9", null ]
      ] ],
      [ "Work with repository: Reviewer operations", "occt_dev_guides__git_guide.html#occt_gitguide_5", [
        [ "Review branch changes using GitWeb", "occt_dev_guides__git_guide.html#occt_gitguide_5_1", null ],
        [ "Review branch changes with TortoiseGit", "occt_dev_guides__git_guide.html#occt_gitguide_5_2", null ]
      ] ]
    ] ],
    [ "Automated Testing System", "occt_dev_guides__tests.html", [
      [ "Introduction", "occt_dev_guides__tests.html#testmanual_1", [
        [ "Basic Information", "occt_dev_guides__tests.html#testmanual_1_1", null ],
        [ "Intended Use of Automatic Tests", "occt_dev_guides__tests.html#testmanual_1_2", null ],
        [ "Quick Start", "occt_dev_guides__tests.html#testmanual_1_3", [
          [ "Setup", "occt_dev_guides__tests.html#testmanual_1_3_1", null ],
          [ "Running Tests", "occt_dev_guides__tests.html#testmanual_1_3_2", null ],
          [ "Running a Single Test", "occt_dev_guides__tests.html#testmanual_1_3_3", null ],
          [ "Creating a New Test", "occt_dev_guides__tests.html#testmanual_1_3_4", null ]
        ] ]
      ] ],
      [ "Organization of Test Scripts", "occt_dev_guides__tests.html#testmanual_2", [
        [ "General Layout", "occt_dev_guides__tests.html#testmanual_2_1", null ],
        [ "Test Groups", "occt_dev_guides__tests.html#testmanual_2_2", [
          [ "Group Names", "occt_dev_guides__tests.html#testmanual_2_2_1", null ],
          [ "File \"grids.list\"", "occt_dev_guides__tests.html#testmanual_2_2_2", null ],
          [ "File \"begin\"", "occt_dev_guides__tests.html#testmanual_2_2_3", null ],
          [ "File \"end\"", "occt_dev_guides__tests.html#testmanual_2_2_4", null ],
          [ "File \"parse.rules\"", "occt_dev_guides__tests.html#testmanual_2_2_5", null ],
          [ "Directory \"data\"", "occt_dev_guides__tests.html#testmanual_2_2_6", null ]
        ] ],
        [ "Test Grids", "occt_dev_guides__tests.html#testmanual_2_3", [
          [ "Grid Names", "occt_dev_guides__tests.html#testmanual_2_3_1", null ],
          [ "File \"begin\"", "occt_dev_guides__tests.html#testmanual_2_3_2", null ],
          [ "File \"end\"", "occt_dev_guides__tests.html#testmanual_2_3_3", null ],
          [ "File \"cases.list\"", "occt_dev_guides__tests.html#testmanual_2_3_4", null ],
          [ "Directory \"data\"", "occt_dev_guides__tests.html#testmanual_2_3_5", null ]
        ] ],
        [ "Test Cases", "occt_dev_guides__tests.html#testmanual_2_4", null ]
      ] ],
      [ "Creation And Modification Of Tests", "occt_dev_guides__tests.html#testmanual_3", [
        [ "Choosing Group, Grid, and Test Case Name", "occt_dev_guides__tests.html#testmanual_3_1", null ],
        [ "Adding Data Files Required for a Test", "occt_dev_guides__tests.html#testmanual_3_2", null ],
        [ "Adding new DRAW commands", "occt_dev_guides__tests.html#testmanual_3_3", null ],
        [ "Script Implementation", "occt_dev_guides__tests.html#testmanual_3_4", null ],
        [ "Interpretation of test results", "occt_dev_guides__tests.html#testmanual_3_5", null ],
        [ "Marking BAD cases", "occt_dev_guides__tests.html#testmanual_3_6", null ]
      ] ],
      [ "Advanced Use", "occt_dev_guides__tests.html#testmanual_4", [
        [ "Running Tests on Older Versions of OCCT", "occt_dev_guides__tests.html#testmanual_4_1", null ],
        [ "Adding custom tests", "occt_dev_guides__tests.html#testmanual_4_2", null ],
        [ "Parallel execution of tests", "occt_dev_guides__tests.html#testmanual_4_3", null ],
        [ "Checking non-regression of performance, memory, and visualization", "occt_dev_guides__tests.html#testmanual_4_4", null ]
      ] ],
      [ "APPENDIX", "occt_dev_guides__tests.html#testmanual_5", [
        [ "Test groups", "occt_dev_guides__tests.html#testmanual_5_1", [
          [ "3rdparty", "occt_dev_guides__tests.html#testmanual_5_1_1", null ],
          [ "blend", "occt_dev_guides__tests.html#testmanual_5_1_2", null ],
          [ "boolean", "occt_dev_guides__tests.html#testmanual_5_1_3", null ],
          [ "bugs", "occt_dev_guides__tests.html#testmanual_5_1_4", null ],
          [ "caf", "occt_dev_guides__tests.html#testmanual_5_1_5", null ],
          [ "chamfer", "occt_dev_guides__tests.html#testmanual_5_1_6", null ],
          [ "demo", "occt_dev_guides__tests.html#testmanual_5_1_7", null ],
          [ "draft", "occt_dev_guides__tests.html#testmanual_5_1_8", null ],
          [ "feat", "occt_dev_guides__tests.html#testmanual_5_1_9", null ],
          [ "heal", "occt_dev_guides__tests.html#testmanual_5_1_10", null ],
          [ "mesh", "occt_dev_guides__tests.html#testmanual_5_1_11", null ],
          [ "mkface", "occt_dev_guides__tests.html#testmanual_5_1_12", null ],
          [ "nproject", "occt_dev_guides__tests.html#testmanual_5_1_13", null ],
          [ "offset", "occt_dev_guides__tests.html#testmanual_5_1_14", null ],
          [ "pipe", "occt_dev_guides__tests.html#testmanual_5_1_15", null ],
          [ "prism", "occt_dev_guides__tests.html#testmanual_5_1_16", null ],
          [ "sewing", "occt_dev_guides__tests.html#testmanual_5_1_17", null ],
          [ "thrusection", "occt_dev_guides__tests.html#testmanual_5_1_18", null ],
          [ "xcaf", "occt_dev_guides__tests.html#testmanual_5_1_19", null ]
        ] ],
        [ "Mapping of OCCT functionality to grid names in group *bugs*", "occt_dev_guides__tests.html#testmanual_5_2", null ],
        [ "Recommended approaches to checking test results", "occt_dev_guides__tests.html#testmanual_5_3", [
          [ "Shape validity", "occt_dev_guides__tests.html#testmanual_5_3_1", null ],
          [ "Shape tolerance", "occt_dev_guides__tests.html#testmanual_5_3_2", null ],
          [ "Shape volume, area, or length", "occt_dev_guides__tests.html#testmanual_5_3_3", null ],
          [ "Memory leaks", "occt_dev_guides__tests.html#testmanual_5_3_4", null ],
          [ "Visualization", "occt_dev_guides__tests.html#testmanual_5_3_5", null ],
          [ "Number of free edges", "occt_dev_guides__tests.html#testmanual_5_3_6", null ],
          [ "Compare numbers", "occt_dev_guides__tests.html#testmanual_5_3_7", null ],
          [ "Check number of sub-shapes", "occt_dev_guides__tests.html#testmanual_5_3_8", null ],
          [ "Check pixel color", "occt_dev_guides__tests.html#testmanual_5_3_9", null ]
        ] ]
      ] ]
    ] ],
    [ "Debugging tools and hints", "occt_dev_guides__debug.html", [
      [ "Introduction", "occt_dev_guides__debug.html#occt_debug_intro", null ],
      [ "Compiler macro to enable extended debug messages", "occt_dev_guides__debug.html#occt_debug_macro", null ],
      [ "Calling JIT debugger on exception", "occt_dev_guides__debug.html#occt_debug_exceptions", null ],
      [ "Self-diagnostics in Boolean operations algorithm", "occt_dev_guides__debug.html#occt_debug_bop", null ],
      [ "Functions for calling from debugger", "occt_dev_guides__debug.html#occt_debug_call", [
        [ "Interacting with DRAW", "occt_dev_guides__debug.html#occt_debug_call_draw", null ],
        [ "Saving and dumping shapes and geometric objects", "occt_dev_guides__debug.html#occt_debug_call_brep", null ]
      ] ],
      [ "Using Visual Studio debugger", "occt_dev_guides__debug.html#occt_debug_vstudio", [
        [ "Command window", "occt_dev_guides__debug.html#occt_debug_vstudio_command", null ],
        [ "Customized display of variables content", "occt_dev_guides__debug.html#occt_debug_vstudio_watch", null ]
      ] ],
      [ "Performance measurement tools", "occt_dev_guides__debug.html#occt_debug_perf", null ]
    ] ],
    [ "Workshop Organisation Kit", "occt_dev_guides__wok.html", [
      [ "DEPRECATION WARNING", "occt_dev_guides__wok.html#occt_wok_0", null ],
      [ "Introduction Glossary", "occt_dev_guides__wok.html#occt_wok_1_", [
        [ "About the Development Environment", "occt_dev_guides__wok.html#occt_wok_1_1", null ],
        [ "Brief Overview of Open CASCADE Technology Development Environment", "occt_dev_guides__wok.html#occt_wok_1_2", null ],
        [ "WOK Components", "occt_dev_guides__wok.html#occt_wok_1_3", [
          [ "Entities", "occt_dev_guides__wok.html#occt_wok_1_3_1", null ],
          [ "Files", "occt_dev_guides__wok.html#occt_wok_1_3_2", null ]
        ] ],
        [ "Glossary", "occt_dev_guides__wok.html#occt_wok_1_4", [
          [ "Development Units", "occt_dev_guides__wok.html#occt_wok_1_4_1", null ],
          [ "Workbenches", "occt_dev_guides__wok.html#occt_wok_1_4_2", null ],
          [ "Workshops", "occt_dev_guides__wok.html#occt_wok_1_4_3", null ],
          [ "Factories", "occt_dev_guides__wok.html#occt_wok_1_4_4", null ]
        ] ]
      ] ],
      [ "Elements of the Platform", "occt_dev_guides__wok.html#occt_wok_2_", [
        [ "Development Units", "occt_dev_guides__wok.html#occt_wok_2_1", [
          [ "Directory Structure of a Development Unit", "occt_dev_guides__wok.html#occt_wok_2_1_1", null ],
          [ "Files in a Development Unit", "occt_dev_guides__wok.html#occt_wok_2_1_2", null ],
          [ "Package", "occt_dev_guides__wok.html#occt_wok_2_1_3", null ],
          [ "Schema", "occt_dev_guides__wok.html#occt_wok_2_1_4", null ],
          [ "Executable", "occt_dev_guides__wok.html#occt_wok_2_1_5", null ],
          [ "Toolkit", "occt_dev_guides__wok.html#occt_wok_2_1_6", null ],
          [ "Nocdlpack", "occt_dev_guides__wok.html#occt_wok_2_1_7", null ],
          [ "Interface", "occt_dev_guides__wok.html#occt_wok_2_1_8", null ],
          [ "Jni", "occt_dev_guides__wok.html#occt_wok_2_1_9", null ],
          [ "Delivering Parcels", "occt_dev_guides__wok.html#occt_wok_2_1_10", null ]
        ] ],
        [ "Workbenches", "occt_dev_guides__wok.html#occt_wok_2_2", [
          [ "Roots", "occt_dev_guides__wok.html#occt_wok_2_2_1", null ],
          [ "Directories", "occt_dev_guides__wok.html#occt_wok_2_2_2", null ]
        ] ],
        [ "Workshops", "occt_dev_guides__wok.html#occt_wok_2_2_3", null ],
        [ "Factories", "occt_dev_guides__wok.html#occt_wok_2_2_4", null ]
      ] ],
      [ "Development Process", "occt_dev_guides__wok.html#occt_wok_3", [
        [ "WOK Environment", "occt_dev_guides__wok.html#occt_wok_3_1", null ],
        [ "Steps", "occt_dev_guides__wok.html#occt_wok_3_2", null ],
        [ "Getting Started", "occt_dev_guides__wok.html#occt_wok_3_3", [
          [ "Entity Names", "occt_dev_guides__wok.html#occt_wok_3_3_1", null ],
          [ "Entering the Factory", "occt_dev_guides__wok.html#occt_wok_3_3_2", null ],
          [ "Creating a New Workshop", "occt_dev_guides__wok.html#occt_wok_3_3_3", null ],
          [ "Selecting Parcels", "occt_dev_guides__wok.html#occt_wok_3_3_4", null ],
          [ "Opening a Workshop", "occt_dev_guides__wok.html#occt_wok_3_3_5", null ],
          [ "Creating a New Workbench", "occt_dev_guides__wok.html#occt_wok_3_3_6", null ],
          [ "Opening a Workbench", "occt_dev_guides__wok.html#occt_wok_3_3_7", null ],
          [ "Using Existing Resources", "occt_dev_guides__wok.html#occt_wok_3_3_8", null ]
        ] ],
        [ "Creating Software Components", "occt_dev_guides__wok.html#occt_wok_3_4", [
          [ "Creating a Package", "occt_dev_guides__wok.html#occt_wok_3_4_1", null ],
          [ "Creating a Nocdlpack", "occt_dev_guides__wok.html#occt_wok_3_4_2", null ],
          [ "Creating a Schema", "occt_dev_guides__wok.html#occt_wok_3_4_3", null ]
        ] ],
        [ "Building an Executable", "occt_dev_guides__wok.html#occt_wok_3_5", [
          [ "Creating an Executable", "occt_dev_guides__wok.html#occt_wok_3_5_1", null ]
        ] ],
        [ "Test Environments", "occt_dev_guides__wok.html#occt_wok_3_6", [
          [ "Testing an Executable", "occt_dev_guides__wok.html#occt_wok_3_6_1", null ]
        ] ],
        [ "Building a Toolkit", "occt_dev_guides__wok.html#occt_wok_3_7", [
          [ "Creating a Toolkit", "occt_dev_guides__wok.html#occt_wok_3_7_1", null ]
        ] ],
        [ "Building a Delivery Unit", "occt_dev_guides__wok.html#occt_wok_3_8", [
          [ "Creating a Delivery Unit", "occt_dev_guides__wok.html#occt_wok_3_8_1", null ],
          [ "Installing a Parcel", "occt_dev_guides__wok.html#occt_wok_3_8_2", null ]
        ] ],
        [ "Working with Resource", "occt_dev_guides__wok.html#occt_wok_3_9", null ],
        [ "Java wrapping", "occt_dev_guides__wok.html#occt_wok_3_10", [
          [ "Creating an interface", "occt_dev_guides__wok.html#occt_wok_3_10_1", null ],
          [ "Creating a jni", "occt_dev_guides__wok.html#occt_wok_3_10_2", null ]
        ] ],
        [ "More Advanced Use", "occt_dev_guides__wok.html#occt_wok_3_11", [
          [ "Default User Profile", "occt_dev_guides__wok.html#occt_wok_3_11_1", null ],
          [ "Changing Parcel Configuration", "occt_dev_guides__wok.html#occt_wok_3_11_2", null ]
        ] ]
      ] ],
      [ "Available Services", "occt_dev_guides__wok.html#occt_wok_4_", [
        [ "Synopsis", "occt_dev_guides__wok.html#occt_wok_4_1", [
          [ "Common Command Syntax", "occt_dev_guides__wok.html#occt_wok_4_1_1", null ]
        ] ],
        [ "General Services", "occt_dev_guides__wok.html#occt_wok_4_2", [
          [ "wokcd", "occt_dev_guides__wok.html#occt_wok_4_2_1", null ],
          [ "wokclose", "occt_dev_guides__wok.html#occt_wok_4_2_2", null ],
          [ "wokenv", "occt_dev_guides__wok.html#occt_wok_4_2_3", null ],
          [ "wokinfo", "occt_dev_guides__wok.html#occt_wok_4_2_4", null ],
          [ "woklocate", "occt_dev_guides__wok.html#occt_wok_4_2_5", null ],
          [ "wokparam", "occt_dev_guides__wok.html#occt_wok_4_2_6", null ],
          [ "wokprofile", "occt_dev_guides__wok.html#occt_wok_4_2_7", null ]
        ] ],
        [ "Services Associated with Factories", "occt_dev_guides__wok.html#occt_wok_4_3", [
          [ "fcreate", "occt_dev_guides__wok.html#occt_wok_4_3_1", null ],
          [ "finfo", "occt_dev_guides__wok.html#occt_wok_4_3_2", null ],
          [ "frm", "occt_dev_guides__wok.html#occt_wok_4_3_3", null ]
        ] ],
        [ "Services Associated with Warehouses", "occt_dev_guides__wok.html#occt_wok_4_4", [
          [ "Wcreate", "occt_dev_guides__wok.html#occt_wok_4_4_1", null ],
          [ "Winfo", "occt_dev_guides__wok.html#occt_wok_4_4_2", null ],
          [ "Wrm", "occt_dev_guides__wok.html#occt_wok_4_4_3", null ],
          [ "Wdeclare", "occt_dev_guides__wok.html#occt_wok_4_4_4", null ]
        ] ],
        [ "Services Associated with Parcels", "occt_dev_guides__wok.html#occt_wok_4_5", [
          [ "pinfo", "occt_dev_guides__wok.html#occt_wok_4_5_1", null ],
          [ "pinstall", "occt_dev_guides__wok.html#occt_wok_4_5_2", null ]
        ] ],
        [ "Services Associated with Workshops", "occt_dev_guides__wok.html#occt_wok_4_6", [
          [ "screate", "occt_dev_guides__wok.html#occt_wok_4_6_1", null ],
          [ "sinfo", "occt_dev_guides__wok.html#occt_wok_4_6_2", null ],
          [ "srm", "occt_dev_guides__wok.html#occt_wok_4_6_3", null ]
        ] ],
        [ "Services Associated with Workbenches", "occt_dev_guides__wok.html#occt_wok_4_7", [
          [ "wcreate", "occt_dev_guides__wok.html#occt_wok_4_7_1", null ],
          [ "w_info", "occt_dev_guides__wok.html#occt_wok_4_7_2", null ],
          [ "wrm", "occt_dev_guides__wok.html#occt_wok_4_7_3", null ],
          [ "wmove", "occt_dev_guides__wok.html#occt_wok_4_7_4", null ],
          [ "wprocess", "occt_dev_guides__wok.html#occt_wok_4_7_5", null ]
        ] ],
        [ "Services Associated with Development Units", "occt_dev_guides__wok.html#occt_wok_4_8", [
          [ "ucreate", "occt_dev_guides__wok.html#occt_wok_4_8_1", null ],
          [ "uinfo", "occt_dev_guides__wok.html#occt_wok_4_8_2", null ],
          [ "urm", "occt_dev_guides__wok.html#occt_wok_4_8_3", null ],
          [ "umake", "occt_dev_guides__wok.html#occt_wok_4_8_4", null ],
          [ "Specifying Targets (-t) for umake", "occt_dev_guides__wok.html#occt_wok_4_8_5", null ],
          [ "Customizing umake", "occt_dev_guides__wok.html#occt_wok_4_8_6", null ]
        ] ],
        [ "Source Management Services", "occt_dev_guides__wok.html#occt_wok_4_9", [
          [ "wprepare", "occt_dev_guides__wok.html#occt_wok_4_9_1", null ],
          [ "wstore", "occt_dev_guides__wok.html#occt_wok_4_9_2", null ],
          [ "wintegre", "occt_dev_guides__wok.html#occt_wok_4_9_3", null ],
          [ "wnews", "occt_dev_guides__wok.html#occt_wok_4_9_4", null ],
          [ "wget", "occt_dev_guides__wok.html#occt_wok_4_9_5", null ],
          [ "Installation Procedure", "occt_dev_guides__wok.html#occt_wok_4_9_6", null ],
          [ "Integration Procedure", "occt_dev_guides__wok.html#occt_wok_4_9_7", null ]
        ] ],
        [ "Session Services", "occt_dev_guides__wok.html#occt_wok_4_10", [
          [ "Convenience Aliases", "occt_dev_guides__wok.html#occt_wok_4_10_2", null ]
        ] ]
      ] ],
      [ "Using the Graphic Interface", "occt_dev_guides__wok.html#occt_wok_5", [
        [ "Main menu bar", "occt_dev_guides__wok.html#occt_wok_5_1", [
          [ "Menus", "occt_dev_guides__wok.html#occt_wok_5_1_1", null ],
          [ "Application icons", "occt_dev_guides__wok.html#occt_wok_5_1_2", null ],
          [ "Display management", "occt_dev_guides__wok.html#occt_wok_5_1_3", null ]
        ] ],
        [ "Popup menus", "occt_dev_guides__wok.html#occt_wok_5_2", null ]
      ] ],
      [ "Appendix A. Using the Emacs Editor", "occt_dev_guides__wok.html#occt_wok_6", null ],
      [ "Appendix B. Parameters and EDL Files", "occt_dev_guides__wok.html#occt_wok_7", [
        [ "EDL language", "occt_dev_guides__wok.html#occt_wok_7_1", [
          [ "Key Concepts", "occt_dev_guides__wok.html#occt_wok_7_1_1", null ],
          [ "Syntax", "occt_dev_guides__wok.html#occt_wok_7_1_2", null ],
          [ "EDL Actions", "occt_dev_guides__wok.html#occt_wok_7_1_3", null ],
          [ "EDL Conditions", "occt_dev_guides__wok.html#occt_wok_7_1_4", null ]
        ] ],
        [ "WOK Parameters", "occt_dev_guides__wok.html#occt_wok_7_2", [
          [ "Classes of WOK Parameters", "occt_dev_guides__wok.html#occt_wok_7_2_1", null ],
          [ "Defining WOK Parameters", "occt_dev_guides__wok.html#occt_wok_7_2_2", null ],
          [ "Redefining Parameters", "occt_dev_guides__wok.html#occt_wok_7_2_3", null ]
        ] ],
        [ "Using EDL to Define WOK Parameters", "occt_dev_guides__wok.html#occt_wok_7_3", [
          [ "Modification of Link Options - Example", "occt_dev_guides__wok.html#occt_wok_7_3_1", null ]
        ] ]
      ] ],
      [ "Appendix C. Tcl", "occt_dev_guides__wok.html#occt_wok_8", [
        [ "Tcl Overview", "occt_dev_guides__wok.html#occt_wok_8_1", null ],
        [ "Tcl and WOK", "occt_dev_guides__wok.html#occt_wok_8_2", null ],
        [ "Configuring Your Account for Tcl and WOK", "occt_dev_guides__wok.html#occt_wok_8_3", [
          [ "The cshrc File", "occt_dev_guides__wok.html#occt_wok_8_3_1", null ],
          [ "The tclshrc File", "occt_dev_guides__wok.html#occt_wok_8_3_2", null ],
          [ "The WOK_SESSIONID Variable", "occt_dev_guides__wok.html#occt_wok_8_3_3", null ],
          [ "Writing Tcl Steps for a WOK Build", "occt_dev_guides__wok.html#occt_wok_8_3_4", null ],
          [ "Components of a Tcl UMake Step", "occt_dev_guides__wok.html#occt_wok_8_3_5", null ],
          [ "Sample Tcl Steps", "occt_dev_guides__wok.html#occt_wok_8_3_6", null ]
        ] ]
      ] ]
    ] ],
    [ "Component Definition Language (CDL)", "occt_dev_guides__cdl.html", [
      [ "DEPRECATION WARNING", "occt_dev_guides__cdl.html#occt_cdl_0", null ],
      [ "CDL and Application Architecture", "occt_dev_guides__cdl.html#occt_cdl_1", null ],
      [ "Introduction to  CDL", "occt_dev_guides__cdl.html#occt_cdl_2", [
        [ "Purposes of the Language", "occt_dev_guides__cdl.html#occt_cdl_2_1", null ],
        [ "Overview of CDL", "occt_dev_guides__cdl.html#occt_cdl_2_2", [
          [ "Classes", "occt_dev_guides__cdl.html#occt_cdl_2_2_1", null ],
          [ "Categories of Types", "occt_dev_guides__cdl.html#occt_cdl_2_2_2", null ],
          [ "Persistence", "occt_dev_guides__cdl.html#occt_cdl_2_2_3", null ],
          [ "Packages", "occt_dev_guides__cdl.html#occt_cdl_2_2_4", null ],
          [ "Inheritance", "occt_dev_guides__cdl.html#occt_cdl_2_2_5", null ],
          [ "Genericity", "occt_dev_guides__cdl.html#occt_cdl_2_2_6", null ],
          [ "Exceptions", "occt_dev_guides__cdl.html#occt_cdl_2_2_7", null ],
          [ "Completeness", "occt_dev_guides__cdl.html#occt_cdl_2_2_8", null ]
        ] ],
        [ "Lexical Conventions", "occt_dev_guides__cdl.html#occt_cdl_2_3", [
          [ "Syntax  notation", "occt_dev_guides__cdl.html#occt_cdl_2_3_1", null ],
          [ "Lexical  elements", "occt_dev_guides__cdl.html#occt_cdl_2_3_2", null ],
          [ "Comments", "occt_dev_guides__cdl.html#occt_cdl_2_3_3", null ],
          [ "Identifiers", "occt_dev_guides__cdl.html#occt_cdl_2_3_4", null ],
          [ "Keywords", "occt_dev_guides__cdl.html#occt_cdl_2_3_5", null ],
          [ "Constants", "occt_dev_guides__cdl.html#occt_cdl_2_3_6", null ]
        ] ]
      ] ],
      [ "Software  Components", "occt_dev_guides__cdl.html#occt_cdl_3", [
        [ "Predefined Resources", "occt_dev_guides__cdl.html#occt_cdl_3_1", [
          [ "Primitive types", "occt_dev_guides__cdl.html#occt_cdl_3_1_1", null ],
          [ "Manipulating types by reference (by handle)", "occt_dev_guides__cdl.html#occt_cdl_3_1_2", null ],
          [ "Manipulating types by value", "occt_dev_guides__cdl.html#occt_cdl_3_1_3", null ],
          [ "Summary  of properties", "occt_dev_guides__cdl.html#occt_cdl_3_1_4", null ]
        ] ],
        [ "Classes", "occt_dev_guides__cdl.html#occt_cdl_3_2", [
          [ "Class  declaration", "occt_dev_guides__cdl.html#occt_cdl_3_2_1", null ],
          [ "Categories of classes", "occt_dev_guides__cdl.html#occt_cdl_3_2_2", null ]
        ] ],
        [ "Packages", "occt_dev_guides__cdl.html#occt_cdl_3_3", [
          [ "Package  declaration", "occt_dev_guides__cdl.html#occt_cdl_3_3_1", null ],
          [ "Name space", "occt_dev_guides__cdl.html#occt_cdl_3_3_2", null ],
          [ "Declaration of classes", "occt_dev_guides__cdl.html#occt_cdl_3_3_3", null ]
        ] ],
        [ "Other Data Types", "occt_dev_guides__cdl.html#occt_cdl_3_4", [
          [ "Enumerations", "occt_dev_guides__cdl.html#occt_cdl_3_4_1", null ],
          [ "Imports", "occt_dev_guides__cdl.html#occt_cdl_3_4_2", null ],
          [ "Aliases", "occt_dev_guides__cdl.html#occt_cdl_3_4_3", null ],
          [ "Exceptions", "occt_dev_guides__cdl.html#occt_cdl_3_4_4", null ]
        ] ],
        [ "Schemas", "occt_dev_guides__cdl.html#occt_cdl_3_5", null ],
        [ "Executables", "occt_dev_guides__cdl.html#occt_cdl_3_6", null ]
      ] ],
      [ "Defining the Software Components", "occt_dev_guides__cdl.html#occt_cdl_4", [
        [ "Behavior", "occt_dev_guides__cdl.html#occt_cdl_4_1", [
          [ "Object  Constructors", "occt_dev_guides__cdl.html#occt_cdl_4_11", null ],
          [ "Instance Methods", "occt_dev_guides__cdl.html#occt_cdl_4_1_2", null ],
          [ "Class  Methods", "occt_dev_guides__cdl.html#occt_cdl_4_1_3", null ],
          [ "Package  Methods", "occt_dev_guides__cdl.html#occt_cdl_4_1_4", null ],
          [ "Sensitivity to Overloading", "occt_dev_guides__cdl.html#occt_cdl_4_1_5", null ]
        ] ],
        [ "Internal Representation", "occt_dev_guides__cdl.html#occt_cdl_4_2", null ],
        [ "Exceptions", "occt_dev_guides__cdl.html#occt_cdl_4_3", null ],
        [ "Inheritance", "occt_dev_guides__cdl.html#occt_cdl_4_4", [
          [ "Overview", "occt_dev_guides__cdl.html#occt_cdl_4_4_1", null ],
          [ "Redefining methods", "occt_dev_guides__cdl.html#occt_cdl_4_4_2", null ],
          [ "Non-redefinable methods", "occt_dev_guides__cdl.html#occt_cdl_4_4_3", null ],
          [ "Deferred Classes and Methods", "occt_dev_guides__cdl.html#occt_cdl_4_4_4", null ],
          [ "Declaration by Association", "occt_dev_guides__cdl.html#occt_cdl_4_4_5", null ],
          [ "Redefinition of Fields", "occt_dev_guides__cdl.html#occt_cdl_4_4_6", null ]
        ] ],
        [ "Genericity", "occt_dev_guides__cdl.html#occt_cdl_4_5", [
          [ "Overview", "occt_dev_guides__cdl.html#occt_cdl_4_5_1", null ],
          [ "Declaration of a Generic Class", "occt_dev_guides__cdl.html#occt_cdl_4_5_2", null ],
          [ "Instantiation of a Generic Class", "occt_dev_guides__cdl.html#occt_cdl_4_5_3", null ],
          [ "Nested  Generic Classes", "occt_dev_guides__cdl.html#occt_cdl_4_5_4", null ]
        ] ],
        [ "Visibility", "occt_dev_guides__cdl.html#occt_cdl_4_6", [
          [ "Overview", "occt_dev_guides__cdl.html#occt_cdl_4_6_1", null ],
          [ "Visibility of Fields", "occt_dev_guides__cdl.html#occt_cdl_4_6_2", null ],
          [ "Visibility of Methods", "occt_dev_guides__cdl.html#occt_cdl_4_6_3", null ],
          [ "Visibility of Classes, Exceptions and Enumerations", "occt_dev_guides__cdl.html#occt_cdl_4_6_4", null ],
          [ "Friend  Classes and Methods", "occt_dev_guides__cdl.html#occt_cdl_4_6_5", null ]
        ] ]
      ] ],
      [ "Appendix A. Syntax  Summary", "occt_dev_guides__cdl.html#occt_cdl_5", null ],
      [ "Appendix B Comparison of CDL and C++", "occt_dev_guides__cdl.html#occt_cdl_6", null ]
    ] ]
];