/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "CommonFunctions.h"

#include <wx/file.h>
#include <wx/filedlg.h>
#include <wx/dir.h>
#include <pwd.h>

CommonFunctions::CommonFunctions()  // Set defaults
{
    passwd *pw = getpwuid(getuid());
    if (pw)
        oFolder_userM = pw->pw_dir;

    PathCoordination = _T("/.discwrapper/");
}

CommonFunctions::~CommonFunctions()
{
    //(*Destroy(CommonFunctions)
    //*)
}

std::string CommonFunctions::wx2std(wxString s)    // Convert a wxString to std::string
{
    std::string s2;
    if(s.wxString::IsAscii())
    {
        s2=s.wxString::ToAscii();
    }
    else
    {
        const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(s);
        const char *tmp_str = (const char*) tmp_buf;
        s2=std::string(tmp_str, strlen(tmp_str));
    }
    return s2;
}

wxString CommonFunctions::std2wx(std::string s)    // Convert a std::string to wxString
{
    wxString wx;
    const char* my_string=s.c_str();
    wxMBConvUTF8 *wxconv= new wxMBConvUTF8();
    wx=wxString(wxconv->cMB2WC(my_string),wxConvUTF8);
    delete wxconv;
    // test if conversion works of not. In case it fails convert from Ascii
    if(wx.length()==0)
        wx=wxString(wxString::FromAscii(s.c_str()));
    return wx;
}

/*************************************************************
 *  Paths
 *
 *************************************************************/
wxString CommonFunctions::DataPath()     // Find data dir
{
#if defined(__UNIX__)
    if ( wxFile::Exists(_T("/usr/local/share/discwrapper/printermodels")) == true )
        return(_T("/usr/local/share/discwrapper/"));
    else
        return(_T("/usr/share/discwrapper/"));
#elif defined(__WXMSW__)
    return(_T("data/"));
#endif
}

void CommonFunctions::LocalDir()         // Check configure dir
{
#if defined(__UNIX__)
    if ( !wxDir::Exists(std2wx(oFolder_userM)+_T("/.discwrapper/")) )
        wxMkdir(std2wx(oFolder_userM)+_T("/.discwrapper/"));

    if ( !wxDir::Exists(std2wx(oFolder_userM)+_T("/.discwrapper/templates")) )
        wxMkdir(std2wx(oFolder_userM)+_T("/.discwrapper/templates"));

#endif
}


/*************************************************************
 *  Log
 *
 *************************************************************/
void CommonFunctions::DWLog(wxString ToLog)  // Write a wxString to log file
{
    if ( wxFile::Exists(std2wx(oFolder_userM)+_T("/.discwrapper/")+_T("discwrapper.log")) == false )
        return;

    wxFile file;
    wxString path;

    path = std2wx(oFolder_userM)+_T("/.discwrapper/")+_T("discwrapper.log");

    file.Open(path, wxFile::write_append);

    file.Write(ToLog, wxConvUTF8);

    file.Close();
}


/*************************************************************
 *  Extra wxString functions
 *
 *************************************************************/
wxString CommonFunctions::MyAfterFirst(wxString StringToWorkWith, wxString KeyString, int WantedLength, int place, int state)
{
    wxString value = wxEmptyString;

    if ( (StringToWorkWith.Len()-place < KeyString.Len()-state) || (KeyString == wxEmptyString) )
        return(value);

    if ( StringToWorkWith[place] == KeyString[state] )
    {
        if ( state != KeyString.Len()-1 )
            value = MyAfterFirst(StringToWorkWith, KeyString, WantedLength, place+1, state+1);
        else
            return(StringToWorkWith.Mid(place+1, StringToWorkWith.Len()-(place+1)));
    }
    else if ( state != 0 )
        return(wxEmptyString);

    if ( (state == 0) && (value == wxEmptyString) )
        value = MyAfterFirst(StringToWorkWith, KeyString, WantedLength, place+1, state);

    return(value);
}

wxString CommonFunctions::MyBeforeFirst(wxString StringToWorkWith, wxString KeyString, int WantedLength, int place, int state)
{
    wxString value = wxEmptyString;

    if ( (StringToWorkWith.Len()-place < KeyString.Len()-state) || (KeyString == wxEmptyString) )//|| (StringToWorkWith.Len()-place < ) )
        return(value);

    if ( StringToWorkWith[place] == KeyString[state] )
    {
        if ( state != KeyString.Len()-1 )
            value = MyBeforeFirst(StringToWorkWith, KeyString, WantedLength, place+1, state+1);
        else
            return(StringToWorkWith.Mid(0, (place+1)-KeyString.Len()));
    }
    else if ( state != 0 )
        return(wxEmptyString);

    if ( (state == 0) && (value == wxEmptyString) )
        value = MyBeforeFirst(StringToWorkWith, KeyString, WantedLength, place+1, state);

    return(value);
}

bool CommonFunctions::MyMatches(wxString StringToWorkWith, wxString KeyString, int place, int state)
{
    bool value = false;

    if ( (StringToWorkWith.Len()-place < KeyString.Len()-state) || (KeyString == wxEmptyString) )
        return(value);

    if ( StringToWorkWith[place] == KeyString[state] )
    {
        if ( state != KeyString.Len()-1 )
            value = MyMatches(StringToWorkWith, KeyString, place+1, state+1);
        else
            return(true);
    }
    else if ( state != 0 )
        return(false);

    if ( (state == 0) && (value == false) )
        value = MyMatches(StringToWorkWith, KeyString, place+1, state);

    return(value);
}

