/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DWPrintout.h"

DWPrintout::DWPrintout(int pageAmountin, wxString title) : wxPrintout( title )
{
    pageAmount = pageAmountin;
    orient = wxPORTRAIT;
    discpos = wxPoint(0, 0);
}

DWPrintout::~DWPrintout()
{
}

void DWPrintout::SetDC(wxBitmap bitmap, int currentcase)
{
    PDMIB = bitmap;
    CurrentCase = currentcase;
}

void DWPrintout::SetDiscPosition(wxPoint point)
{
    discpos = point;
}

bool DWPrintout::OnPrintPage(int pageNum)
{
    // wxMessageBox(_("Printing page"), _("Printing"));

    wxDC* ptr = GetDC();
    if(ptr==NULL or !ptr->IsOk())
    {
        wxMessageBox(_("DC is not Ok, interrupting printing"), _("Printing"));
        return false;
    }
    wxDC& dc = *ptr;

    dc.Clear();
    float maxX = 300;
    float maxY = 300;
    // float maxX2 = PDMIB.GetWidth();   // Get the width and the height of the current pattern
    // float maxY2 = PDMIB.GetHeight();
    int w, h, wppi, hppi;
    dc.GetSize(&w, &h);
    // wxMessageBox(wxString::Format(_("%i, %i"), w, h));
    GetPPIPrinter(&wppi, &hppi);
    float scaleX=(float)(wppi/maxX);
    float scaleY=(float)(hppi/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w - (PDMIB.GetWidth()*actualScale))/2.0);
    float posY = (float)((h - (PDMIB.GetHeight()*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);


    if ( discpos == wxPoint(0, 0) )
        dc.SetDeviceOrigin( (long)posX, (long)posY );
    else
    {
        float Xcommon = (float)w/2480, Ycommon = (float)h/3508;

        long Xmod = discpos.x*Xcommon, Ymod = discpos.y*Ycommon;

        dc.SetDeviceOrigin( (long)(posX+Xmod), (long)(posY-Ymod) );
    }


    dc.SetBackground(*wxWHITE_BRUSH);
    dc.Clear();
    dc.SetBackgroundMode(wxTRANSPARENT);
    //  wxMessageBox(wxString::Format(_("maxX2:%i\nmaxY2:%i\nw:%i\nh:%i"), PDMIB.GetWidth(), maxY2, w, h), _("TR"));

    dc.DrawBitmap(PDMIB,0,0,0);
    /*    dc.SetPen( wxPen(wxColour(0, 0, 0, wxALPHA_OPAQUE), 50, wxSOLID) );
        dc.SetBrush( *wxTRANSPARENT_BRUSH );
        dc.DrawRectangle(0, 0, 2182, 3224);*/

    return true;
}

void DWPrintout::preparePrint(const bool showPageSetupDialog)
{
    if(showPageSetupDialog)
    {
        wxPageSetupDialogData PSDD;
        PSDD.SetPaperId(wxPAPER_A4);
        wxPageSetupDialog dialog(NULL, &PSDD );
        // if(dialog.ShowModal()==wxID_OK)
        {
            page_setup = dialog.GetPageSetupData();
            orient = page_setup.GetPrintData().GetOrientation();
        }
        /* else
        {
            wxMessageBox(_("User canceled at first dialog."), _("Printing"));
            exit(1);
        }*/
    }
    else
    {
        // don't show page setup dialog, use default values
        wxPrintData printdata;
        printdata.SetPrintMode( wxPRINT_MODE_PRINTER );
        printdata.SetOrientation( wxLANDSCAPE ); // wxPORTRAIT, wxLANDSCAPE
        printdata.SetNoCopies(1);

        page_setup = wxPageSetupDialogData(printdata);
        orient = printdata.GetOrientation();
    }
}

void DWPrintout::OnBeginPrinting()
{
    // set-up coordinate system however we want
    // we'll use it when drawing

    // here i'm using arbitrary an size, use whatever you wish
    if(orient == wxPORTRAIT)
    {
        max_x = 680;
        max_y = 880;
    }
    else
    {
        max_x = 880;
        max_y = 680;
    }

    FitThisSizeToPageMargins(wxSize(max_x, max_y), page_setup);
}

bool DWPrintout::OnBeginDocument(int startPage, int endPage)
{
    //std::cout << "beginning to print document, from page " << startPage << " to " << endPage << std::endl;
    return wxPrintout::OnBeginDocument(startPage, endPage);
}

void DWPrintout::GetPageInfo(int *minPage, int *maxPage, int *pageSelFrom, int *pageSelTo)
{
    // wx will call this to know how many pages can be printed
    *minPage = 1;
    *maxPage = pageAmount;

    *pageSelFrom = 1;
    *pageSelTo = pageAmount;
}

bool DWPrintout::HasPage(int pageNum)
{
    // wx will call this to know how many pages can be printed
    if(pageNum >= 1 and pageNum <= pageAmount)
        return true;
    else
        return false;
}

void DWPrintout::OnEndPrinting()
{
    return;
}
