/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperMain.h"
#include "AboutDialog.h"
#include "AddListDialog.h"
#include "ConfirmCloseDialog.h"
#include "ImageStoreDialog.h"
#include "PreferencesDialog.h"
#include "ImportTextFileDialog.h"

//(*InternalHeaders(DiscWrapperFrame)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/bitmap.h>
#include <wx/icon.h>
#include <wx/image.h>
#include <wx/artprov.h>
//*)

#if defined(__UNIX__)
#include <pwd.h>
#endif

#include <wx/arrstr.h>
#include <wx/bitmap.h>
#include <wx/cmndata.h>
#include <wx/colordlg.h>
#include <wx/colour.h>
#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/dcmemory.h>
#include <wx/dialog.h>
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/event.h>
#include <wx/file.h>
#include <wx/filedlg.h>
#include <wx/font.h>
#include <wx/fontdlg.h>
#include <wx/gdicmn.h>
#include <wx/graphics.h>
#include <wx/log.h>
#include <wx/msgdlg.h>
#include <wx/printdlg.h>
#include <wx/tbarbase.h>
#include <wx/toolbar.h>
#include <wx/wfstream.h>
#include <wx/zipstrm.h>
#include <wx/txtstrm.h>

#include <memory>   // needed by auto_ptr

//(*IdInit(DiscWrapperFrame)
const long DiscWrapperFrame::ID_TOGGLEBUTTON1 = wxNewId();
const long DiscWrapperFrame::ID_CHOICE1 = wxNewId();
const long DiscWrapperFrame::ID_STATICLINE1 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON1 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON2 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON3 = wxNewId();
const long DiscWrapperFrame::ID_STATICLINE2 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON4 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON5 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON6 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON7 = wxNewId();
const long DiscWrapperFrame::ID_STATICLINE3 = wxNewId();
const long DiscWrapperFrame::ID_BITMAPBUTTON8 = wxNewId();
const long DiscWrapperFrame::ID_PANEL3 = wxNewId();
const long DiscWrapperFrame::ID_NOTEBOOK1 = wxNewId();
const long DiscWrapperFrame::ID_PANEL1 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM13 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM7 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM5 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM8 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM9 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM6 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM4 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM3 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM1 = wxNewId();
const long DiscWrapperFrame::ID_MENUITEM2 = wxNewId();
const long DiscWrapperFrame::ID_STATUSBAR1 = wxNewId();
const long DiscWrapperFrame::ID_NEW = wxNewId();
const long DiscWrapperFrame::ID_OPEN = wxNewId();
const long DiscWrapperFrame::ID_SAVE = wxNewId();
const long DiscWrapperFrame::ID_PRINT = wxNewId();
const long DiscWrapperFrame::ID_TOOL_ZIN = wxNewId();
const long DiscWrapperFrame::ID_TOOL_ZOUT = wxNewId();
const long DiscWrapperFrame::ID_TOOL_FIT = wxNewId();
const long DiscWrapperFrame::ID_TOOLBAR1 = wxNewId();
//*)
const long DiscWrapperFrame::ID_PANELF = wxNewId();
const long DiscWrapperFrame::ID_PANELI = wxNewId();
const long DiscWrapperFrame::ID_PANELB = wxNewId();
const long DiscWrapperFrame::ID_PANELD = wxNewId();

const long DiscWrapperFrame::ID_RECENT1 = wxNewId();
const long DiscWrapperFrame::ID_RECENT2 = wxNewId();
const long DiscWrapperFrame::ID_RECENT3 = wxNewId();
const long DiscWrapperFrame::ID_RECENT4 = wxNewId();
const long DiscWrapperFrame::ID_RECENT5 = wxNewId();

const long DiscWrapperFrame::ID_POPNEW1 = wxNewId();
const long DiscWrapperFrame::ID_POPNEW2 = wxNewId();
const long DiscWrapperFrame::ID_POPNEW3 = wxNewId();
const long DiscWrapperFrame::ID_POPNEW4 = wxNewId();
const long DiscWrapperFrame::ID_POPDEL = wxNewId();

const long DiscWrapperFrame::ID_TEXTCTRL = wxNewId();

BEGIN_EVENT_TABLE(DiscWrapperFrame,wxFrame)
    //(*EventTable(DiscWrapperFrame)
    //*)
END_EVENT_TABLE()

DiscWrapperFrame::DiscWrapperFrame(wxWindow* parent,wxChar *Project,bool IsProject,wxWindowID id)  // Create frame and set defaults
{

    /**
     *   Initializing variables...
     *
     **/

    recs = new wxString[5];
    rec = 0;
    LastDir = wxEmptyString;
    ActiveTool = 1;
    SelectedItem = -1;
    FitHorizontal = ChangeTool = LastCatched = DontLog = false;
    CurrentZoom = 1;
    FitDC = true;
    STATUS = _("Idle");
    PrevCoord = NewPlace = dragStartPos = DCdragStartPos = wxPoint(0, 0);
    Behind = 0;
    AlreadyS = 0;

    IsDatabasePresent = false;

    UpdPview = true;
    UpdSize = wxSize(0, 0);

    UR_Drag = false;
    UR_WrongIndex = UR_Max = UR_Current = 0;

    /*
    #if defined(__UNIX__)
        passwd *pw = getpwuid(getuid());
        if (pw)
            CFs.oFolder_userM = pw->pw_dir;

        CFs.PathCoordination = _T("/.discwrapper/");
    #elif defined(__WXMSW__)
        CFs.PathCoordination = _T("");
    #endif*/

    CFs.LocalDir();

    wxFile LogFile;
    LogFile.Create(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("discwrapper.log"), true, wxS_DEFAULT);
    LogFile.Close();

    CFs.DWLog(_T("> Starting up...\n"));

    //(*Initialize(DiscWrapperFrame)
    wxMenuItem* MenuItem7;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem1;
    wxBoxSizer* BoxSizer2;
    wxBoxSizer* BoxSizer1;
    wxMenuBar* MenuBar1;
    wxMenu* Menu2;

    Create(parent, wxID_ANY, _T("DiscWrapper"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE|wxCLIP_CHILDREN|wxFULL_REPAINT_ON_RESIZE, _T("wxID_ANY"));
    SetClientSize(wxSize(700,550));
    SetMinSize(wxSize(700,550));
    {
        wxIcon FrameIcon;
        FrameIcon.CopyFromBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/DW-icon.png"))));
        SetIcon(FrameIcon);
    }
    Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(152,280), wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
    BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
    Panel3 = new wxPanel(Panel1, ID_PANEL3, wxDefaultPosition, wxSize(58,-1), wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANEL3"));
    Panel3->SetMinSize(wxSize(58,-1));
    BoxSizer2 = new wxBoxSizer(wxVERTICAL);
    ToggleButton1 = new wxToggleButton(Panel3, ID_TOGGLEBUTTON1, _("Bend"), wxDefaultPosition, wxSize(48,32), 0, wxDefaultValidator, _T("ID_TOGGLEBUTTON1"));
    ToggleButton1->Disable();
    ToggleButton1->Hide();
    BoxSizer2->Add(ToggleButton1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    Choice1 = new wxChoice(Panel3, ID_CHOICE1, wxDefaultPosition, wxSize(48,32), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
    Choice1->SetSelection( Choice1->Append(_T("-")) );
    Choice1->Append(_("1"));
    Choice1->Append(_("2"));
    Choice1->Append(_("3"));
    Choice1->Append(_("4"));
    Choice1->Append(_("5"));
    Choice1->Disable();
    Choice1->Hide();
    BoxSizer2->Add(Choice1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticLine1 = new wxStaticLine(Panel3, ID_STATICLINE1, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
    StaticLine1->Hide();
    BoxSizer2->Add(StaticLine1, 0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton1 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON1, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/aleft.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON1"));
    BitmapButton1->Disable();
    BitmapButton1->Hide();
    BoxSizer2->Add(BitmapButton1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton2 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON2, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/acenter.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON2"));
    BitmapButton2->SetDefault();
    BitmapButton2->Disable();
    BitmapButton2->Hide();
    BoxSizer2->Add(BitmapButton2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton3 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON3, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/aright.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON3"));
    BitmapButton3->SetDefault();
    BitmapButton3->Disable();
    BitmapButton3->Hide();
    BoxSizer2->Add(BitmapButton3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticLine2 = new wxStaticLine(Panel3, ID_STATICLINE2, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE2"));
    StaticLine2->Hide();
    BoxSizer2->Add(StaticLine2, 0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton4 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON4, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/font.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON4"));
    BitmapButton4->Disable();
    BitmapButton4->Hide();
    BoxSizer2->Add(BitmapButton4, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton5 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON5, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/colour.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON5"));
    BitmapButton5->Disable();
    BitmapButton5->Hide();
    BoxSizer2->Add(BitmapButton5, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton6 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON6, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/pup.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON6"));
    BitmapButton6->Disable();
    BitmapButton6->Hide();
    BoxSizer2->Add(BitmapButton6, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton7 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON7, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/pdown.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON7"));
    BitmapButton7->Disable();
    BitmapButton7->Hide();
    BoxSizer2->Add(BitmapButton7, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticLine3 = new wxStaticLine(Panel3, ID_STATICLINE3, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE3"));
    StaticLine3->Hide();
    BoxSizer2->Add(StaticLine3, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BitmapButton8 = new wxBitmapButton(Panel3, ID_BITMAPBUTTON8, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/fit.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON8"));
    BitmapButton8->Disable();
    BitmapButton8->Hide();
    BoxSizer2->Add(BitmapButton8, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BoxSizer2->Add(48,48,0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    Panel3->SetSizer(BoxSizer2);
    BoxSizer2->SetSizeHints(Panel3);
    BoxSizer1->Add(Panel3, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    Notebook1 = new wxNotebook(Panel1, ID_NOTEBOOK1, wxDefaultPosition, wxDefaultSize, wxNB_BOTTOM, _T("ID_NOTEBOOK1"));
    BoxSizer1->Add(Notebook1, 1, wxTOP|wxBOTTOM|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    Panel1->SetSizer(BoxSizer1);
    BoxSizer1->Fit(Panel1);
    BoxSizer1->SetSizeHints(Panel1);
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
    MenuItem3 = new wxMenuItem(Menu1, wxID_NEW, _("&New...\tCtrl+N"), _("New project"), wxITEM_NORMAL);
    MenuItem3->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_NEW")),wxART_MENU));
    Menu1->Append(MenuItem3);
    MenuItem4 = new wxMenuItem(Menu1, wxID_OPEN, _("&Open...\tCtrl+O"), _("Open a perviously saved project file"), wxITEM_NORMAL);
    MenuItem4->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_OPEN")),wxART_MENU));
    Menu1->Append(MenuItem4);
    MenuItem5 = new wxMenuItem(Menu1, wxID_SAVE, _("&Save\tCtrl+S"), _("Save current project"), wxITEM_NORMAL);
    MenuItem5->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_SAVE")),wxART_MENU));
    Menu1->Append(MenuItem5);
    MenuItem5->Enable(false);
    MenuItem16 = new wxMenuItem(Menu1, wxID_SAVEAS, _("Save &as..."), wxEmptyString, wxITEM_NORMAL);
    MenuItem16->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_SAVE_AS")),wxART_MENU));
    Menu1->Append(MenuItem16);
    MenuItem16->Enable(false);
    MenuItem15 = new wxMenuItem(Menu1, ID_MENUITEM13, _("&Close"), _("Close current project"), wxITEM_NORMAL);
    MenuItem15->SetBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/window-close.png"))));
    Menu1->Append(MenuItem15);
    MenuItem15->Enable(false);
    Menu1->AppendSeparator();
    MenuItem9 = new wxMenuItem(Menu1, ID_MENUITEM7, _("&Export...\tCtrl+E"), _("Export cover to an image"), wxITEM_NORMAL);
    MenuItem9->SetBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/export.png"))));
    Menu1->Append(MenuItem9);
    MenuItem9->Enable(false);
    Menu1->AppendSeparator();
    MenuItem13 = new wxMenuItem(Menu1, wxID_PRINT, _("&Print..."), _("Print currently viewed page"), wxITEM_NORMAL);
    MenuItem13->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_PRINT")),wxART_MENU));
    Menu1->Append(MenuItem13);
    MenuItem13->Enable(false);
    Menu1->AppendSeparator();
    Menu1->AppendSeparator();
    MenuItem1 = new wxMenuItem(Menu1, wxID_EXIT, _("&Quit\tAlt-F4"), _("Quit the application"), wxITEM_NORMAL);
    MenuItem1->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_QUIT")),wxART_MENU));
    Menu1->Append(MenuItem1);
    MenuBar1->Append(Menu1, _("&File"));
    Menu3 = new wxMenu();
    MenuItem11 = new wxMenuItem(Menu3, ID_MENUITEM5, _("&Undo\tCtrl+Z"), wxEmptyString, wxITEM_NORMAL);
    MenuItem11->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_UNDO")),wxART_MENU));
    Menu3->Append(MenuItem11);
    MenuItem11->Enable(false);
    MenuItem12 = new wxMenuItem(Menu3, ID_MENUITEM8, _("&Redo\tCtrl+Y"), wxEmptyString, wxITEM_NORMAL);
    MenuItem12->SetBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_REDO")),wxART_MENU));
    Menu3->Append(MenuItem12);
    MenuItem12->Enable(false);
    Menu3->AppendSeparator();
    MenuItem14 = new wxMenuItem(Menu3, ID_MENUITEM9, _("&Next item\tCtrl+I"), _("Select next item on current page"), wxITEM_NORMAL);
    Menu3->Append(MenuItem14);
    MenuItem14->Enable(false);
    Menu3->AppendSeparator();
    MenuItem7 = new wxMenuItem(Menu3, wxID_PREFERENCES, _("&Preferences..."), wxEmptyString, wxITEM_NORMAL);
    Menu3->Append(MenuItem7);
    MenuBar1->Append(Menu3, _("&Edit"));
    Menu4 = new wxMenu();
    MenuItem8 = new wxMenuItem(Menu4, ID_MENUITEM6, _("&Refresh"), wxEmptyString, wxITEM_NORMAL);
    MenuItem8->SetBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/view-refresh_s.png"))));
    Menu4->Append(MenuItem8);
    MenuItem8->Enable(false);
    MenuItem6 = new wxMenuItem(Menu4, ID_MENUITEM4, _("&Fit best"), wxEmptyString, wxITEM_NORMAL);
    MenuItem6->SetBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-fit-best_s.png"))));
    Menu4->Append(MenuItem6);
    MenuItem6->Enable(false);
    MenuBar1->Append(Menu4, _("&View"));
    Menu5 = new wxMenu();
    MenuItem10 = new wxMenuItem(Menu5, ID_MENUITEM3, _("Labels"), wxEmptyString, wxITEM_RADIO);
    Menu5->Append(MenuItem10);
    MenuItem10->Enable(false);
    MenuItem17 = new wxMenuItem(Menu5, ID_MENUITEM1, _("Directory lists"), _("Add/edit directory lists"), wxITEM_RADIO);
    Menu5->Append(MenuItem17);
    MenuItem17->Enable(false);
    MenuItem18 = new wxMenuItem(Menu5, ID_MENUITEM2, _("Images"), _("Add/edit images"), wxITEM_RADIO);
    Menu5->Append(MenuItem18);
    MenuItem18->Enable(false);
    MenuBar1->Append(Menu5, _("&Tools"));
    Menu2 = new wxMenu();
    MenuItem2 = new wxMenuItem(Menu2, wxID_ABOUT, _("&About\tF1"), _("Show info about this application"), wxITEM_NORMAL);
    MenuItem2->SetBitmap(wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/gtk-about.png"))));
    Menu2->Append(MenuItem2);
    MenuBar1->Append(Menu2, _("&Help"));
    SetMenuBar(MenuBar1);
    StatusBar1 = new wxStatusBar(this, ID_STATUSBAR1, wxST_SIZEGRIP, _T("ID_STATUSBAR1"));
    int __wxStatusBarWidths_1[3] = { -6, -2, -1 };
    int __wxStatusBarStyles_1[3] = { wxSB_NORMAL, wxSB_NORMAL, wxSB_NORMAL };
    StatusBar1->SetFieldsCount(3,__wxStatusBarWidths_1);
    StatusBar1->SetStatusStyles(3,__wxStatusBarStyles_1);
    SetStatusBar(StatusBar1);
    ToolBar1 = new wxToolBar(this, ID_TOOLBAR1, wxDefaultPosition, wxDefaultSize, wxTB_HORIZONTAL|wxTB_TEXT|wxTB_HORZ_TEXT|wxNO_BORDER, _T("ID_TOOLBAR1"));
    ToolBarItem1 = ToolBar1->AddTool(ID_NEW, _("New"), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_NEW")),wxART_TOOLBAR), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_NEW")),wxART_TOOLBAR), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBarItem2 = ToolBar1->AddTool(ID_OPEN, _("Open"), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_OPEN")),wxART_TOOLBAR), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_OPEN")),wxART_TOOLBAR), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBarItem3 = ToolBar1->AddTool(ID_SAVE, _("Save"), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_SAVE")),wxART_TOOLBAR), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_SAVE")),wxART_TOOLBAR), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBar1->AddSeparator();
    ToolBarItem4 = ToolBar1->AddTool(ID_PRINT, _("Print"), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_PRINT")),wxART_TOOLBAR), wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_PRINT")),wxART_TOOLBAR), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBar1->AddSeparator();
    ToolBarItem5 = ToolBar1->AddTool(ID_TOOL_ZIN, _("Zoom in"), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-in_b.png"))), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-in_b.png"))), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBarItem6 = ToolBar1->AddTool(ID_TOOL_ZOUT, _("Zoom out"), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-out_b.png"))), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-out_b.png"))), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBarItem7 = ToolBar1->AddTool(ID_TOOL_FIT, _("Fit best"), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-fit-best_b.png"))), wxBitmap(wxImage(CFs.DataPath()+_T("icons/menu/zoom-fit-best_b.png"))), wxITEM_NORMAL, wxEmptyString, wxEmptyString);
    ToolBar1->Realize();
    SetToolBar(ToolBar1);

    Connect(ID_TOGGLEBUTTON1,wxEVT_COMMAND_TOGGLEBUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::OnBendClick);
    Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnClassSelect);
    Connect(wxID_NEW,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnTool_New_Clicked);
    Connect(wxID_OPEN,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_OPEN);
    Connect(wxID_SAVE,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_SAVE);
    Connect(wxID_SAVEAS,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_SAVE_AS);
    Connect(ID_MENUITEM13,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_Close_Selected);
    Connect(ID_MENUITEM7,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_Export);
    Connect(wxID_PRINT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_PRINT);
    Connect(wxID_EXIT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnQuit);
    Connect(ID_MENUITEM5,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnUndo);
    Connect(ID_MENUITEM8,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnRedo);
    Connect(ID_MENUITEM9,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnSelectNext);
    Connect(wxID_PREFERENCES,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_PREFERENCES);
    Connect(ID_MENUITEM6,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnToolBar_Refresh_Clicked);
    Connect(ID_MENUITEM4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_Zoom_Fit);
    Connect(ID_MENUITEM3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_TEXT_TOOL);
    Connect(ID_MENUITEM1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_LIST_TOOL);
    Connect(ID_MENUITEM2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_IMAGE_TOOL);
    Connect(wxID_ABOUT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnAbout);
    Connect(ID_NEW,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::OnTool_New_Clicked);
    Connect(ID_OPEN,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_OPEN);
    Connect(ID_SAVE,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_SAVE);
    Connect(ID_PRINT,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_PRINT);
    Connect(ID_TOOL_ZIN,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Zoom_In);
    Connect(ID_TOOL_ZOUT,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Zoom_Out);
    Connect(ID_TOOL_FIT,wxEVT_COMMAND_TOOL_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Zoom_Fit);
    Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&DiscWrapperFrame::OnClose);
    //*)

    Connect(ID_BITMAPBUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Text_Align);
    Connect(ID_BITMAPBUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Text_Align);
    Connect(ID_BITMAPBUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_Text_Align);
    Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnClassSelect);
    Connect(ID_BITMAPBUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::OnFontClick);
    Connect(ID_BITMAPBUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::OnColorClick);

    Connect(ID_BITMAPBUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_ImageUp);
    Connect(ID_BITMAPBUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_ImageDown);
    Connect(ID_BITMAPBUTTON8,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DiscWrapperFrame::On_ImageFitIt);

    CFs.DWLog(_T("> Loading defaults\n"));

    int i, j, g, h;
    char *c;
    wxFile file;
    wxString path, temp, stemp;

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("defaults0");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        file.Read(&DClass, sizeof(int));

        file.Read(&j, sizeof(int));
        Dfont.SetPointSize(j);
        file.Read(&j, sizeof(int));
        switch (j)
        {
        case 70:
            Dfont.SetFamily(wxFONTFAMILY_DEFAULT);
            break;
        case 71:
            Dfont.SetFamily(wxFONTFAMILY_DECORATIVE);
            break;
        case 72:
            Dfont.SetFamily(wxFONTFAMILY_ROMAN);
            break;
        case 73:
            Dfont.SetFamily(wxFONTFAMILY_SCRIPT);
            break;
        case 74:
            Dfont.SetFamily(wxFONTFAMILY_SWISS);
            break;
        case 75:
            Dfont.SetFamily(wxFONTFAMILY_MODERN);
            break;
        case 76:
            Dfont.SetFamily(wxFONTFAMILY_TELETYPE);
            break;
        }
        file.Read(&j, sizeof(int));
        Dfont.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch (j)
        {
        case 90:
            Dfont.SetWeight(wxFONTWEIGHT_NORMAL);
            break;
        case 91:
            Dfont.SetWeight(wxFONTWEIGHT_LIGHT);
            break;
        case 92:
            Dfont.SetWeight(wxFONTWEIGHT_BOLD);
            break;
        }

        file.Read(&j, sizeof(int));
        c = new char[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(char));
        temp = wxString::From8BitData(c);
        for ( g = 0 ; g < temp.Len()-(temp.Len()-j) ; g++ )
            stemp += temp[g];
        delete[] c;
        Dfont.SetFaceName(stemp);

        file.Read(&FilesOnly, sizeof(bool));
        file.Read(&Hidden, sizeof(bool));

        unsigned char R, G, B, A;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        DColour.Set(R, G, B, A);

        file.Close();
    }
    else
    {
        DClass = 0;
        Dfont = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        DColour.Set(0, 0, 0, wxALPHA_OPAQUE);
        FilesOnly = Hidden = false;
    }

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("paths");
    if ( wxFile::Exists(path) == true )
    {
        wxChar *x;
        file.Open(path, wxFile::read);

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        ImportPath = wxString(x, j);
        delete[] x;

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        ExportPath = wxString(x, j);
        delete[] x;

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        ProjectPath = wxString(x, j);
        delete[] x;

        file.Close();
    }
    else
    {
        ImportPath = wxEmptyString;
        ExportPath = wxEmptyString;
        ProjectPath = wxEmptyString;
    }

    CFs.DWLog(_T("> Loading list of recent projects\n"));

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("recent");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        file.Read(&rec, sizeof(int));
        h =  rec;
        // recs = new wxString[5];

        for ( i = 0 ; i < rec ; i++ )
        {
            recs[i] = wxEmptyString;

            file.Read(&j, sizeof(int));
            c = new char[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(char));
            temp = wxString::From8BitData(c);
            for ( g = 0 ; g < temp.Len()-(temp.Len()-j) ; g++ )
                recs[i] += temp[g];
            delete[] c;

            if ( wxFile::Exists(recs[i]) == false )
            {
                h--;
                recs[i] = wxEmptyString;
            }
        }

        if ( (h != rec) and (h != 0) )
        {
            wxString *STEMP = new wxString[h];
            j = 0;
            for ( i = 0 ; i < rec ; i++ )
            {
                if ( recs[i] != wxEmptyString )
                {
                    STEMP[j] = recs[i];
                    j++;
                }
            }
            /*delete[] recs;
            recs = new wxString[5];*/
            for ( i = 0 ; i < h ; i++ )
            {
                recs[i] = STEMP[i];
            }
        }
        else if ( h <= 0 )
        {
            //delete[] recs;
            rec = 0;
        }
        rec = h;


        for ( i = 0 ; i < rec ; i++ )
        {
            switch (i)
            {
            case 0:
                Recent1 = new wxMenuItem(Menu1, ID_RECENT1, recs[0], wxEmptyString, wxITEM_NORMAL);
                Menu1->Insert(10, Recent1);
                Connect(ID_RECENT1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents1);
                break;
            case 1:
                Recent2 = new wxMenuItem(Menu1, ID_RECENT2, recs[1], wxEmptyString, wxITEM_NORMAL);
                Menu1->Insert(11, Recent2);
                Connect(ID_RECENT2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents2);
                break;
            case 2:
                Recent3 = new wxMenuItem(Menu1, ID_RECENT3, recs[2], wxEmptyString, wxITEM_NORMAL);
                Menu1->Insert(12, Recent3);
                Connect(ID_RECENT3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents3);
                break;
            case 3:
                Recent4 = new wxMenuItem(Menu1, ID_RECENT4, recs[3], wxEmptyString, wxITEM_NORMAL);
                Menu1->Insert(13, Recent4);
                Connect(ID_RECENT4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents4);
                break;
            case 4:
                Recent5 = new wxMenuItem(Menu1, ID_RECENT5, recs[4], wxEmptyString, wxITEM_NORMAL);
                Menu1->Insert(14, Recent5);
                Connect(ID_RECENT5,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents5);
                break;
            }
        }

        file.Close();
    }


    ToolBar1->EnableTool(ID_SAVE, false);
    ToolBar1->EnableTool(ID_PRINT, false);
    ToolBar1->EnableTool(ID_TOOL_ZIN, false);
    ToolBar1->EnableTool(ID_TOOL_ZOUT, false);
    ToolBar1->EnableTool(ID_TOOL_FIT, false);
    STATUS = _("Idle");
    USB();    //Update Status Bar

    CFs.DWLog(_T("> Ready to work\n\n"));


    PopUp = new wxMenu();
    PopItem1 = new wxMenuItem(PopUp, ID_POPNEW1, _("New label"), _(""), wxITEM_NORMAL);
    PopUp->Append(PopItem1);
    PopItem2 = new wxMenuItem(PopUp, ID_POPNEW2, _("New list"), _(""), wxITEM_NORMAL);
    PopUp->Append(PopItem2);
    PopItem3 = new wxMenuItem(PopUp, ID_POPNEW3, _("New image"), _(""), wxITEM_NORMAL);
    PopUp->Append(PopItem3);
    PopItem4 = new wxMenuItem(PopUp, ID_POPNEW4, _("New image from store"), _(""), wxITEM_NORMAL);
    PopUp->Append(PopItem4);
    PopUp->AppendSeparator();
    PopItem5 = new wxMenuItem(PopUp, ID_POPDEL, _("Delete selected"), _(""), wxITEM_NORMAL);
    PopUp->Append(PopItem5);

    Connect(ID_POPNEW1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnNewLabel);
    Connect(ID_POPNEW2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_NewList);
    Connect(ID_POPNEW3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_NewImage);
    Connect(ID_POPNEW4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::On_ImageS);

    // Preload cursors
    wxImage image(CFs.DataPath()+_T("icons/cursor/SW.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    SWcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/WN.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    WNcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/NE.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    NEcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/ES.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    EScursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/NESW.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    NESWcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/NWSE.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    NWSEcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/NSWE.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    NSWEcursor = wxCursor(image);
    image = wxImage(CFs.DataPath()+_T("icons/cursor/WE.png"), wxBITMAP_TYPE_PNG);
    image.SetMaskColour(0, 0, 0);
    image.SetMask(true);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 10);
    image.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 10);
    WEcursor = wxCursor(image);

    CurrentCursor = _T("wxNullCursor");


    if ( IsProject == true )
        OpenProject(Project);

}

DiscWrapperFrame::~DiscWrapperFrame()
{
    //(*Destroy(DiscWrapperFrame)
    //*)
}

void DiscWrapperFrame::OnQuit(wxCommandEvent& event)    // Exit called from menu
{
    Close();
}

void DiscWrapperFrame::OnClose(wxCloseEvent& event)     // Close
{
    if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        if ( ConfirmClose() == false )
            return;

    if ( SPATH != wxEmptyString )
        UpdateRecents();

    if ( IsDatabasePresent )
        UnloadProject();

    CFs.DWLog(_T("> Exiting\n"));

    Destroy();
}


/*************************************************************
 *  Tool and page switching
 *
 *************************************************************/
void DiscWrapperFrame::OnNotebook1PageChanged(wxNotebookEvent& event)   // Page selection
{
    if ( event.GetOldSelection() != Database->PDP )
    {
        switch (event.GetOldSelection())
        {
        case 0:
            TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
            delete TextCtrl;

            PanelF->Disconnect(ID_PANELF,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelF->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelF->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelF->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelF->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelF->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelF->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelF->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        case 1:
            TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
            delete TextCtrl;

            PanelI->Disconnect(ID_PANELI,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelI->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelI->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelI->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelI->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelI->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelI->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelI->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        case 2:
            TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
            delete TextCtrl;

            PanelB->Disconnect(ID_PANELB,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelB->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelB->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelB->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelB->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelB->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelB->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelB->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        }
    }
    else
    {
        TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
        delete TextCtrl;

        PanelD->Disconnect(ID_PANELD,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
        PanelD->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
        PanelD->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
        PanelD->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
        PanelD->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
        PanelD->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
        PanelD->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
        PanelD->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
    }

    if ( DontLog == false )
        CFs.DWLog(_T(">>> Changing page\n"));

    CurrentZoom = 1;
    FitDC = true;
    SelectedItem = -1;

    UpdPview = true;

    RealiseTool();

    if ( event.GetSelection() != Database->PDP )
    {
        switch (event.GetSelection())
        {
        case 0:
            TextCtrl = new wxTextCtrl(PanelF, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
            TextCtrl->Hide();
            TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);

            PanelF->Connect(ID_PANELF,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelF->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelF->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelF->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelF->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelF->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelF->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelF->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        case 1:
            TextCtrl = new wxTextCtrl(PanelI, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
            TextCtrl->Hide();
            TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);

            PanelI->Connect(ID_PANELI,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelI->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelI->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelI->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelI->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelI->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelI->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelI->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        case 2:
            TextCtrl = new wxTextCtrl(PanelB, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
            TextCtrl->Hide();
            TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);

            PanelB->Connect(ID_PANELB,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
            PanelB->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
            PanelB->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
            PanelB->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
            PanelB->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
            PanelB->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
            PanelB->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
            PanelB->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
            break;
        }
    }
    else
    {
        TextCtrl = new wxTextCtrl(PanelD, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
        TextCtrl->Hide();
        TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);

        PanelD->Connect(ID_PANELD,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
        PanelD->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
        PanelD->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
        PanelD->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
        PanelD->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
        PanelD->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
        PanelD->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
        PanelD->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
    }
}

void DiscWrapperFrame::ShowTool(int toolnumber)
{
    switch (toolnumber)
    {
    case 1:
        ToggleButton1->Show();
        Choice1->Show();
        BitmapButton1->Show();
        BitmapButton2->Show();
        BitmapButton3->Show();
        BitmapButton4->Show();
        BitmapButton5->Show();
        StaticLine1->Show();
        StaticLine2->Show();
        break;
    case 2:
        BitmapButton4->Show();
        BitmapButton5->Show();
        break;
    case 3:
        BitmapButton6->Show();
        BitmapButton7->Show();
        BitmapButton8->Show();
        StaticLine3->Show();
        break;
    }

    Panel3->SetSize(wxSize(58, -1));
}

void DiscWrapperFrame::AbleTool(int toolnumber, bool statetoset)
{
    switch (toolnumber)
    {
    case 1:
        ToggleButton1->Enable(statetoset);
        if ( Notebook1->GetPageText(Notebook1->GetSelection()) != _("Disc") )
            ToggleButton1->Enable(false);
        Choice1->Enable(statetoset);
        BitmapButton1->Enable(statetoset);
        BitmapButton2->Enable(statetoset);
        BitmapButton3->Enable(statetoset);
        BitmapButton4->Enable(statetoset);
        BitmapButton5->Enable(statetoset);
        break;
    case 2:
        BitmapButton4->Enable(statetoset);
        BitmapButton5->Enable(statetoset);
        break;
    case 3:
        BitmapButton6->Enable(statetoset);
        BitmapButton7->Enable(statetoset);
        if ( statetoset )
        {
            int Cpage = GetCurrentPage();
            if ( Database->Page[Cpage].images.GetCount() > 1 )   // Find selected pattern
            {
                if ( Database->Page[Cpage].ImageOrder[Database->Page[Cpage].images.GetCount()-1] == SelectedItem )
                    BitmapButton6->Disable();
                if ( Database->Page[Cpage].ImageOrder[0] == SelectedItem )
                    BitmapButton7->Disable();
            }
            else
            {
                BitmapButton6->Disable();
                BitmapButton7->Disable();
            }

        }
        BitmapButton8->Enable(statetoset);
        break;
    }
}

void DiscWrapperFrame::RealiseTool()
{
    int Cpage = GetCurrentPage();
    SelectedItem = -1;

    if ( ActiveTool == 1 )   //Text tool
    {
        if ( Database->Page[Cpage].labels.GetCount() != 0 )
        {
            SelectedItem = 0;
            AbleTool(1, true);
            ToggleButton1->SetValue(Database->Page[Cpage].labels[0].Bend);
            if ( Notebook1->GetPageText(Notebook1->GetSelection()) != _("Disc") )
                ToggleButton1->Disable();
            Choice1->SetSelection(Database->Page[Cpage].labels[0].Class);
        }
        else
            AbleTool(1, false);

    }
    else if ( ActiveTool == 2 )   //List tool
    {
        if ( Database->Page[Cpage].lists.GetCount() != 0 )
        {
            SelectedItem = 0;
            AbleTool(2, true);
        }
        else
            AbleTool(2, false);

    }
    else
    {
        if ( Database->Page[Cpage].images.GetCount() != 0 )
        {
            SelectedItem = 0;
            AbleTool(3, true);
        }
        else
            AbleTool(3, false);

    }

}

void DiscWrapperFrame::DeleteTool()             // Deactivates the current tool and frees variables for the activating tool
{
    if ( DontLog == false )
        CFs.DWLog(_T(">> Clean up old tool\n"));

    switch (ActiveTool)
    {
    case 1:
        //AbleTool(1, false);

        ToggleButton1->Hide();
        Choice1->Hide();
        BitmapButton1->Hide();
        BitmapButton2->Hide();
        BitmapButton3->Hide();
        BitmapButton4->Hide();
        BitmapButton5->Hide();
        StaticLine1->Hide();
        StaticLine2->Hide();
        break;
    case 2:
        //AbleTool(2, false);

        BitmapButton4->Hide();
        BitmapButton5->Hide();
        break;
    case 3:
        //AbleTool(3, false);

        BitmapButton6->Hide();
        BitmapButton7->Hide();
        BitmapButton8->Hide();
        StaticLine3->Hide();
        break;
    }
}

void DiscWrapperFrame::On_TEXT_TOOL(wxCommandEvent& event)  // Activates Text tool
{
    SetTextTool();
}

void DiscWrapperFrame::SetTextTool()        // Text tool
{
    if ( ActiveTool != 1 )
    {
        DeleteTool();

        if ( DontLog == false )
            CFs.DWLog(_T(">> Set text tool\n"));

        SelectedItem = -1;

        ActiveTool = 1;

        MenuItem10->Check();

        ShowTool(1);

        ToggleButton1->Disable();

        RealiseTool();
    }

}

void DiscWrapperFrame::On_LIST_TOOL(wxCommandEvent& event)  // Activates List tool
{
    SetListTool();
}

void DiscWrapperFrame::SetListTool()        // List tool
{
    if ( ActiveTool != 2 )
    {
        DeleteTool();

        CFs.DWLog(_T(">> Set list tool\n"));

        SelectedItem = -1;

        ActiveTool = 2;

        MenuItem17->Check();

        ShowTool(2);

        RealiseTool();
    }
}

void DiscWrapperFrame::On_IMAGE_TOOL(wxCommandEvent& event) // Activates Image tool
{
    SetImageTool();
}

void DiscWrapperFrame::SetImageTool()       // Image tool
{
    if ( ActiveTool != 3 )
    {
        DeleteTool();

        CFs.DWLog(_T(">> Set image tool\n"));

        SelectedItem = -1;

        ActiveTool = 3;

        MenuItem18->Check();

        ShowTool(3);

        RealiseTool();
    }
}


/*************************************************************
 *  Label
 *
 *************************************************************/
void DiscWrapperFrame::OnNewLabel(wxCommandEvent& event)    // Creates a label
{
    CreateLabel();
    AddToRedoList(8);
    NowOfRedoList(8);
}

void DiscWrapperFrame::CreateLabel()
{
    CFs.DWLog(_T(">>> Adding label\n"));
    if ( ChangeTool == true )
        SetTextTool();

    int Cpage = GetCurrentPage();

    LabelStructure NewItem;

    NewItem.L = wxString::Format(_("New Label #%i"),Database->Page[Cpage].labels.GetCount()+1);

    if ( NewPlace.x < 0 )
        NewItem.X = 0;
    else if ( NewPlace.x > GetBackWidth(Cpage) )
        NewItem.X = GetBackWidth(Cpage);
    else
        NewItem.X = NewPlace.x;
    if ( NewPlace.y < 0 )
        NewItem.Y = 0;
    else if ( NewPlace.y > GetBackHeight(Cpage) )
        NewItem.Y = GetBackHeight(Cpage);
    else
        NewItem.Y = NewPlace.y;

    NewItem.Font = wxFontData();
    NewItem.Font.SetChosenFont(Dfont);
    NewItem.Font.SetInitialFont(NewItem.Font.GetChosenFont());
    NewItem.Colour.SetColour(DColour);
    NewItem.Angle = 0;
    NewItem.Class = DClass;
    NewItem.Align = 0;

    NewItem.Bend = false;
    ToggleButton1->SetValue(NewItem.Bend);
    Choice1->SetSelection(NewItem.Class);

    Database->Page[Cpage].labels.Add(NewItem);

    SelectedItem = Database->Page[Cpage].labels.GetCount()-1;
    if ( SelectedItem == 0 )
        AbleTool(1, true);
}

void DiscWrapperFrame::OnDelLabel(wxCommandEvent& event)    // Deletes a label
{
    AddToRedoList(9);
    NowOfRedoList(9);
    DeleteLabel();
    FixRedoIndex(UR_IndexCorrection);
}

void DiscWrapperFrame::DeleteLabel()
{
    CFs.DWLog(_T(">>> Deleting label\n"));

    int Cpage = GetCurrentPage();

    Database->Page[Cpage].labels.RemoveAt(SelectedItem);

    if ( Database->Page[Cpage].labels.GetCount() > 0 )
    {
        if ( SelectedItem != 0 )
            SelectedItem -= 1;

        Choice1->SetSelection(Database->Page[Cpage].labels[SelectedItem].Class);
        ToggleButton1->SetValue(Database->Page[Cpage].labels[SelectedItem].Bend);
    }
    else
    {
        SelectedItem = -1;
        AbleTool(1, false);
    }

}

void DiscWrapperFrame::OnTextCtrlKillFocus(wxFocusEvent& event)
{
    TextCtrlLoseFocus();
}

void DiscWrapperFrame::TextCtrlLoseFocus()
{
    int Cpage = GetCurrentPage();
    if ( UR_stringT != TextCtrl->GetValue() )
    {
        AddToRedoList(0);
        UR_stringT = TextCtrl->GetValue();
        NowOfRedoList(0);

        Database->Page[Cpage].labels[SelectedItem].L = TextCtrl->GetValue();
        if ( Database->Page[Cpage].labels[SelectedItem].Class != 0 )
        {
            int Mpage, MItem;
            for ( Mpage = 0 ; Mpage < 4 ; Mpage++ )
                for ( MItem = 0 ; MItem < Database->Page[Mpage].labels.GetCount() ; MItem++ )
                    if ( Database->Page[Cpage].labels[SelectedItem].Class == Database->Page[Mpage].labels[MItem].Class )
                        Database->Page[Mpage].labels[MItem].L = Database->Page[Cpage].labels[SelectedItem].L;
        }
    }

    TextCtrl->Hide();

    RDO();
}

void DiscWrapperFrame::On_Text_Align(wxCommandEvent& event)     // Sets text align
{
    CFs.DWLog(_T(">>> Chosing align of label\n"));
    int i;

    if ( ID_BITMAPBUTTON1 == event.GetId() )
        i = 0;
    else if ( ID_BITMAPBUTTON2 == event.GetId() )
        i = 1;
    else if ( ID_BITMAPBUTTON3 == event.GetId() )
        i = 2;

    AddToRedoList(4);

    Database->Page[GetCurrentPage()].labels[SelectedItem].Align = i;

    NowOfRedoList(4);

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::OnClassSelect(wxCommandEvent& event)     // Class selection to labels
{
    CFs.DWLog(_T(">>> Chosing class of label\n"));

    AddToRedoList(2);

    Database->Page[GetCurrentPage()].labels[SelectedItem].Class = Choice1->GetCurrentSelection();

    NowOfRedoList(2);

    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::OnBendClick(wxCommandEvent& event)   // Bend label
{
    int Cpage = GetCurrentPage();

    AddToRedoList(7);
    Database->Page[Cpage].labels[SelectedItem].Bend = ToggleButton1->GetValue();
    if ( ToggleButton1->GetValue() )
    {
        Database->Page[Cpage].labels[SelectedItem].X = 700;
        Database->Page[Cpage].labels[SelectedItem].Angle = 100;
    }
    else
        Database->Page[Cpage].labels[SelectedItem].Angle = 0;

    NowOfRedoList(7);

    RDO();
}


/*************************************************************
 *  List
 *
 *************************************************************/
void DiscWrapperFrame::On_NewList(wxCommandEvent& event)    // Creates a new object type of list
{
    CFs.DWLog(_T(">>> Adding list\n"));
    if ( ChangeTool == true )
        SetListTool();

    AddListDialog dialog1(this);
    dialog1.SetOptions(FilesOnly, Hidden, true);
    if ( dialog1.ShowModal() == wxID_OK )
    {

        Listing1 = dialog1.GetL1();
        Listing2 = dialog1.GetL2();
        Listing3 = dialog1.GetL3();

        if ( dialog1.GetSel() == 0 )
        {
            wxDirDialog dialog(this,_("Choose a folder"), _(""), wxDD_DIR_MUST_EXIST, wxDefaultPosition, wxDefaultSize, _T("wxDirCtrl"));
            if (dialog.ShowModal() == wxID_OK)
            {
                if ( !CreateList(0, dialog.GetPath()) )
                    return;
            }
            else
                return;
        }
        else if ( dialog1.GetSel() == 1 )
        {
            wxFileDialog dialog(this, _("Choose a textfile"), ImportPath, _(""), _("All files (*)|*"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);
            if (dialog.ShowModal() == wxID_OK)
            {
                if ( !CreateList(1, dialog.GetPath()) )
                    return;
            }
            else
                return;
        }
        else if ( dialog1.GetSel() == 2 )
        {
            wxFileDialog dialog(this, _("Choose a K3b project file"), ImportPath, _(""), _("K3b project file (*.k3b)|*.k3b;*.K3b;*.K3B;*.k3B|All files (*)|*"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);
            if (dialog.ShowModal() == wxID_OK)
            {
                if ( !CreateList(2, dialog.GetPath()) )
                    return;
            }
            else
                return;
        }
        else if ( dialog1.GetSel() == 3 )
        {
            CreateList(3, _T("1;200;\nl0;"));
        }
    }
    else
        return;


    AddToRedoList(5);
    NowOfRedoList(5);
}

bool DiscWrapperFrame::CreateList(int type, wxString path)
{
    int Cpage = GetCurrentPage(), i;

    ListStructure NewItem;

    if ( type == 0 )
    {
        wxDir dir(path);

        if ( !dir.IsOpened() )
        {
            wxMessageDialog(this, _("Unable to list/open directory."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            return(false);
        }

        wxString filename, listtemp, listtemp2;
        wxArrayString *arrstemp = new wxArrayString();
        wxArrayString *arrstemp2 = new wxArrayString();

        bool cont = dir.GetFirst(&filename, wxEmptyString, wxDIR_DEFAULT);
        while ( cont )
        {
            listtemp2 = filename[filename.Len()-1];
            listtemp = filename[0];
            if ( ( !Listing2 ) and ( listtemp != _T(".") ) and ( listtemp2 != _T("~")) )
            {
                if ( wxDir::Exists(path+_T("/")+filename) == true )
                {
                    if ( Listing1 )
                        arrstemp2->Add(filename);
                }
                else
                    arrstemp->Add(filename);
            }
            else if ( Listing2 )
            {
                if ( wxDir::Exists(path+_T("/")+filename) == true )
                {
                    if ( Listing1 )
                        arrstemp2->Add(filename);
                }
                else
                    arrstemp->Add(filename);
            }

            cont = dir.GetNext(&filename);
        }
        arrstemp->Sort(false);
        arrstemp2->Sort(false);

        wxString stemp;
        NewItem.L.Add(_T("2;700;150;"));

        for  ( i = 0 ; i < arrstemp2->Count() ; i++ )
            NewItem.L.Add(wxString::Format(_T("l%i"), arrstemp2->Item(i).Len())+_T(";")+arrstemp2->Item(i)+_T("r0;"));
        for  ( i = 0 ; i < arrstemp->Count() ; i++ )
        {
            if ( Listing3 )
            {
                wxFile FILE(path+_T("/")+arrstemp->Item(i));
                float len = FILE.Length()/1000.0;
                if ( len > 1000 )
                {
                    len /= 1000.0;
                    if ( len > 1000 )
                    {
                        len /= 1000.0;
                        stemp = wxString::Format(_T("%.1f GB"), len);
                    }
                    else
                        stemp = wxString::Format(_T("%.1f MB"), len);
                }
                else
                    stemp = wxString::Format(_T("%.1f KB"), len);
            }
            else
                stemp = wxEmptyString;
            NewItem.L.Add(wxString::Format(_T("l%i"), arrstemp->Item(i).Len())+_T(";")+arrstemp->Item(i)+wxString::Format(_T("r%i"), stemp.Len())+_T(";")+stemp);
        }

        delete arrstemp;
        delete arrstemp2;
    }
    else if ( type == 1 )
    {
        ImportTextFileDialog dialog(this, wxID_ANY);
        dialog.SetPath(path);
        if ( dialog.ShowModal() == wxID_OK )
        {
            NewItem.L = dialog.GetData();
        }
        else
            return(false);

    }
    else if ( type == 2 )
    {
        std::auto_ptr<wxZipEntry> entry;

        wxFFileInputStream in(path);
        wxZipInputStream zip(in);

        int success = -1;

        while (entry.reset(zip.GetNextEntry()), entry.get() != NULL)
        {
            wxString name = entry->GetName();

            success = 0;

            if ( name == _T("maindata.xml") )
            {
                success = 1;
                wxTextInputStream textin(zip);
                wxString str = wxEmptyString, str2 = wxEmptyString;
                bool inside = false;

                while ( !zip.Eof() )
                {
                    int i;
                    wxString line = textin.ReadLine();
                    switch (success)
                    {
                    case 1:
                        if ( (line == _T("<k3b_data_project>")) or (line == _T("<k3b_dvd_project>")) )
                        {
                            NewItem.L.Add(_T("1;700;"));
                            success = 2;
                        }
                        else if ( line == _T("<k3b_audio_project>") )
                        {
                            NewItem.L.Add(_T("2;700;200;"));
                            success = 3;
                        }
                        break;
                    case 2:
                    case 4:
                        if ( line.Matches(_T("<file name=\"*\" >")) )
                        {
                            str = wxEmptyString;
                            i = 12;
                            while ( i < line.Len()-3 )
                                str += line[i++];

                            NewItem.L.Add(wxString::Format(_T("l%i"), str.Len())+_T(";")+str);
                            success = 4;
                        }
                        break;
                    case 3:
                    case 5:
                        if ( line == _T("<track>") )
                            inside = true;
                        if ( line == _T("</track>") )
                            inside = false;

                        if ( line.Matches(_T("<index0>*</index0>")) and inside )
                        {
                            str = wxEmptyString;
                            i = 8;
                            while ( i < line.Len()-9 )
                                str += line[i++];
                        }
                        else if ( line.Matches(_T("<title>*</title>")) and inside )
                        {
                            str2 = wxEmptyString;
                            i = 7;
                            while ( i < line.Len()-8 )
                                str2 += line[i++];

                            NewItem.L.Add(wxString::Format(_T("l%i"), str2.Len())+_T(";")+str2+wxString::Format(_T("r%i"), str.Len())+_T(";")+str);
                            success = 5;
                        }
                        break;
                    }
                }

            }
        }

        switch (success)
        {
        case -1:
            wxMessageDialog(this, _("Failed to open archive."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            break;
        case 0:
            wxMessageDialog(this, _("File does not seem to be a K3b project file."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            break;
        case 1:
            wxMessageDialog(this, _("File was found to be a K3b project file, but no data could be extracted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            break;
        case 2:
            wxMessageDialog(this, _("K3b project file type: data, but no data could be extracted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            break;
        case 3:
            wxMessageDialog(this, _("K3b project file type: audio, but no data could be extracted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            break;
        }
        if ( success < 4 )
            return(false);
    }
    else if ( type == 3 )
    {

        wxString strtemp = wxEmptyString;
        for ( i = 0 ; i < path.Len() ; i++ )
        {
            if ( path[i] == '\n' )
            {
                NewItem.L.Add(strtemp);
                strtemp = wxEmptyString;
            }
            else
                strtemp += path[i];
        }
        NewItem.L.Add(strtemp);

    }

    NewItem.Font = wxFontData();
    NewItem.Font.SetChosenFont(Dfont);
    NewItem.Font.SetInitialFont(NewItem.Font.GetChosenFont());
    NewItem.Colour.SetColour(DColour);

    if ( NewPlace.x < 0 )
        NewItem.X = 0;
    else if ( NewPlace.x > GetBackWidth(Cpage) )
        NewItem.X = GetBackWidth(Cpage);
    else
        NewItem.X = NewPlace.x;
    if ( NewPlace.y < 0 )
        NewItem.Y = 0;
    else if ( NewPlace.y > GetBackHeight(Cpage) )
        NewItem.Y = GetBackHeight(Cpage);
    else
        NewItem.Y = NewPlace.y;

    Database->Page[Cpage].lists.Add(NewItem);

    SelectedItem = Database->Page[Cpage].lists.GetCount()-1;
    if ( SelectedItem == 0 )
        AbleTool(2, true);



    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar

    return(true);
}

void DiscWrapperFrame::OnDeleteList(wxCommandEvent& event)  // Deletes a list object
{
    AddToRedoList(6);
    NowOfRedoList(6);
    DeleteList();
    FixRedoIndex(UR_IndexCorrection);
}

void DiscWrapperFrame::DeleteList()
{
    CFs.DWLog(_T(">>> Deleting list\n"));
    int Cpage = GetCurrentPage(), i;

    Database->Page[Cpage].lists.RemoveAt(SelectedItem);

    if ( Database->Page[Cpage].lists.GetCount() > 0 )
    {
        if ( SelectedItem != 0 )
            SelectedItem -= 1;
    }
    else
    {
        SelectedItem = -1;
        AbleTool(2, false);
    }

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}


/*************************************************************
 *  Image
 *
 *************************************************************/
void DiscWrapperFrame::On_NewImage(wxCommandEvent& event)   // Creates a new image object
{
    if ( ChangeTool == true )
        SetImageTool();

    wxFileDialog dialog(this, _("Choose an image"), ImportPath, _(""), _("Supported image files (*.bmp;*.jpg;*.png)|*.bmp;*.jpg;*.JPG;*.jpeg;*.JPEG;*.png|BMP files (*.bmp)|*.bmp;*.BMP;|JPG files (*.jpg)|*.jpg;*.JPG;*.jpeg;*.JPEG;|PNG files (*.png)|*.png;*.PNG;|All files (*)|*"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);
    if (dialog.ShowModal() == wxID_OK)
    {
        On_IMAGE(dialog.GetPath());
    }
    else
        return;

    AddToRedoList(5);
    NowOfRedoList(5);
}

void DiscWrapperFrame::On_ImageS(wxCommandEvent& event)   // Creates a new image object from the store
{
    if ( ChangeTool == true )
        SetImageTool();
    if ( wxDir::Exists(CFs.DataPath()+_T("imagestore")) == false )
    {
        wxMessageDialog(this, _("Image store does not exist."), _("Error"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();
        return;
    }

#if defined(__UNIX__)
    ImageStoreDialog dialog( this, wxID_ANY, ImportPath);

    //FIXME : Shouldn't jump out from here under Windows
    if (dialog.ShowModal() == wxID_OK)
    {
        On_IMAGE(dialog.GetPath());
    }
    else
        return;
#elif defined(__WXMSW__)
    wxFileDialog dialog(this, _("Choose an image"), CFs.DataPath()+_T("imagestore"), _(""), _("Supported image files (*.bmp;*.jpg;*.png)|*.bmp;*.jpg;*.png|BMP files (*.bmp)|*.bmp|JPG files (*.jpg)|*.jpg|PNG files (*.png)|*.png|All files (*)|*"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);
    if (dialog.ShowModal() == wxID_OK)
    {
        On_IMAGE(dialog.GetPath());
    }
    else
        return;
#endif

    AddToRedoList(5);
    NowOfRedoList(5);
}

void DiscWrapperFrame::On_IMAGE(wxString path)
{
    CFs.DWLog(_T(">>> Adding image\n"));

    int Cpage = GetCurrentPage();

    ImageStructure NewItem;

    NewItem.Img = NewItem.Path = path;

    if ( NewPlace.x < 0 )
        NewItem.X = 0;
    else if ( NewPlace.x > GetBackWidth(Cpage) )
        NewItem.X = GetBackWidth(Cpage);
    else
        NewItem.X = NewPlace.x;
    if ( NewPlace.y < 0 )
        NewItem.Y = 0;
    else if ( NewPlace.y > GetBackHeight(Cpage) )
        NewItem.Y = GetBackHeight(Cpage);
    else
        NewItem.Y = NewPlace.y;

    NewItem.Scale = 100;
    NewItem.Rotate = 0;

    Database->Page[Cpage].images.Add(NewItem);
    Database->Page[Cpage].ImageOrder.Add(Database->Page[Cpage].images.GetCount()-1);

    SelectedItem = Database->Page[Cpage].images.GetCount()-1;
    if ( SelectedItem == 0 )
        AbleTool(3, true);

    BitmapButton6->Enable();
    BitmapButton7->Enable();

    if ( Database->Page[Cpage].ImageOrder[Database->Page[Cpage].images.GetCount()-1] == SelectedItem )
        BitmapButton6->Disable();
    if ( Database->Page[Cpage].ImageOrder[0] == SelectedItem )
        BitmapButton7->Disable();

    UpdPview = true;

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::OnDeleteImage(wxCommandEvent& event) // Deletes an image object
{
    UR_IndexCorrection = SelectedItem;
    AddToRedoList(6);
    NowOfRedoList(6);
    DeleteImage();
    FixRedoIndex(UR_IndexCorrection);
}

void DiscWrapperFrame::DeleteImage()
{
    CFs.DWLog(_T(">>> Deleting image\n"));
    int Cpage = GetCurrentPage(), i, j;

    Database->Page[Cpage].images.RemoveAt(SelectedItem);

    i = 0;
    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
        i++;

    j = Database->Page[Cpage].ImageOrder.Item(i);
    Database->Page[Cpage].ImageOrder.RemoveAt(i);
    for ( i = 0 ; i < Database->Page[Cpage].images.GetCount() ; i++ )
        if ( Database->Page[Cpage].ImageOrder.Item(i) > j )
            Database->Page[Cpage].ImageOrder.Item(i) -= 1;


    if ( Database->Page[Cpage].images.GetCount() > 0 )
    {
        if ( SelectedItem != 0 )
            SelectedItem -= 1;
        AbleTool(3, true);
    }
    else
    {
        SelectedItem = -1;
        AbleTool(3, false);
    }

    UpdPview = true;

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::On_ImageUp(wxCommandEvent& event)    // Place an image upper
{
    AddToRedoList(3);
    PlaceImageUp();
    NowOfRedoList(3);
}

void DiscWrapperFrame::PlaceImageUp()
{
    CFs.DWLog(_T(">>> Place image upper\n"));
    int Cpage = GetCurrentPage(), j, i;

    i = 0;
    while ( Database->Page[Cpage].ImageOrder.Item(i) != SelectedItem )
        i++;

    j = Database->Page[Cpage].ImageOrder.Item(i);
    Database->Page[Cpage].ImageOrder.Item(i) = Database->Page[Cpage].ImageOrder.Item(i+1);
    Database->Page[Cpage].ImageOrder.Item(i+1) = j;
    //SelectedItem = i+1;

    BitmapButton6->Enable();
    BitmapButton7->Enable();

    if ( Database->Page[Cpage].ImageOrder[Database->Page[Cpage].images.GetCount()-1] == SelectedItem )
        BitmapButton6->Disable();

    UpdPview = true;

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::On_ImageDown(wxCommandEvent& event)  // Place an image lower
{
    AddToRedoList(4);
    PlaceImageDown();
    NowOfRedoList(4);
}

void DiscWrapperFrame::PlaceImageDown()
{
    CFs.DWLog(_T(">>> Place image downer\n"));
    int Cpage = GetCurrentPage(), j, i;
    i = 0;
    while ( Database->Page[Cpage].ImageOrder.Item(i) != SelectedItem )
        i++;

    j = Database->Page[Cpage].ImageOrder.Item(i);
    Database->Page[Cpage].ImageOrder.Item(i) = Database->Page[Cpage].ImageOrder.Item(i-1);
    Database->Page[Cpage].ImageOrder.Item(i-1) = j;
    //SelectedItem = i-1;

    BitmapButton6->Enable();
    BitmapButton7->Enable();

    if ( Database->Page[Cpage].ImageOrder[0] == SelectedItem )
        BitmapButton7->Disable();

    UpdPview = true;

    RDO();
    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::On_ImageFitIt(wxCommandEvent& event)
{
    int Cpage = GetCurrentPage();

    AddToRedoList(7);

    if (FitHorizontal = !FitHorizontal)
    {
        if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 0) or (Database->Page[Cpage].images[SelectedItem].Rotate == 2) )
            Database->Page[Cpage].images[SelectedItem].Scale = 100*(float)GetBackWidth(Cpage)/Database->Page[Cpage].images[SelectedItem].Img.GetWidth();
        else
            Database->Page[Cpage].images[SelectedItem].Scale = 100*(float)GetBackWidth(Cpage)/Database->Page[Cpage].images[SelectedItem].Img.GetHeight();
    }
    else
    {
        if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 0) or (Database->Page[Cpage].images[SelectedItem].Rotate == 2) )
            Database->Page[Cpage].images[SelectedItem].Scale = 100*(float)GetBackHeight(Cpage)/Database->Page[Cpage].images[SelectedItem].Img.GetHeight();
        else
            Database->Page[Cpage].images[SelectedItem].Scale = 100*(float)GetBackHeight(Cpage)/Database->Page[Cpage].images[SelectedItem].Img.GetWidth();
    }

    Database->Page[Cpage].images[SelectedItem].X = GetBackWidth(Cpage)/2;
    Database->Page[Cpage].images[SelectedItem].Y = GetBackHeight(Cpage)/2;

    NowOfRedoList(7);

    UpdPview = true;

    RDO();
}


/*************************************************************
 *  Common stuff
 *
 *************************************************************/
void DiscWrapperFrame::OnFontClick(wxCommandEvent& event)   // Change font properties
{
    CFs.DWLog(_T(">>> Changing font\n"));

    int Cpage = GetCurrentPage();

    if ( ActiveTool == 1 )   //Text tool
    {
        wxFontDialog *fontDialog = new wxFontDialog;
        if ( fontDialog->Create(this,Database->Page[Cpage].labels[SelectedItem].Font) == false )   // create font dialog with the current selections
        {
            wxMessageDialog(this, _("Unexpected error occured."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            Close();
        }

        if (fontDialog->ShowModal() == wxID_OK)
        {
            AddToRedoList(5);
            Database->Page[Cpage].labels[SelectedItem].Font = fontDialog->GetFontData();
            NowOfRedoList(5);
        }
        Database->Page[Cpage].labels[SelectedItem].Font.SetInitialFont(Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont());
        delete fontDialog;
    }
    else if ( ActiveTool == 2 )   //List tool
    {
        wxFontDialog *fontDialog = new wxFontDialog;

        if ( fontDialog->Create(this,Database->Page[Cpage].lists[SelectedItem].Font) == false )   // create font dialog with the current selections
        {
            wxMessageDialog(this, _("Unexpected error occured."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            Close();
        }

        if (fontDialog->ShowModal() == wxID_OK)
        {
            AddToRedoList(3);
            Database->Page[Cpage].lists[SelectedItem].Font = fontDialog->GetFontData();
            NowOfRedoList(3);
        }
        Database->Page[Cpage].lists[SelectedItem].Font.SetInitialFont(Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont());

        delete fontDialog;
    }


    RDO();

    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

void DiscWrapperFrame::OnColorClick(wxCommandEvent& event)   // Change text colour
{
    CFs.DWLog(_T(">>> Changing colour\n"));

    int Cpage = GetCurrentPage();

    if ( ActiveTool == 1 )   //Text tool
    {
        wxColourData *wxcld = new wxColourData(Database->Page[Cpage].labels[SelectedItem].Colour);   // create colour dialog with the current value
        wxColourDialog *colourDialog = new wxColourDialog(this, wxcld);
        if (colourDialog->ShowModal() == wxID_OK)
        {
            AddToRedoList(6);
            Database->Page[Cpage].labels[SelectedItem].Colour = colourDialog->GetColourData();
            NowOfRedoList(6);
        }
        delete wxcld;
        delete colourDialog;
    }
    else if ( ActiveTool == 2 )   //List tool
    {
        wxColourData *wxcld = new wxColourData(Database->Page[Cpage].lists[SelectedItem].Colour);   // create colour dialog with the current value
        wxColourDialog *colourDialog = new wxColourDialog(this, wxcld);
        if (colourDialog->ShowModal() == wxID_OK)
        {
            AddToRedoList(4);
            Database->Page[Cpage].lists[SelectedItem].Colour = colourDialog->GetColourData();
            NowOfRedoList(4);
        }
        delete wxcld;
        delete colourDialog;
    }


    RDO();

    if ( STATUS != _("Unsaved") )
    {
        ToolBar1->EnableTool(ID_SAVE, true);
        MenuItem5->Enable();
        STATUS = _("Modified");
    }
    USB();    //Update Status Bar
}

wxPanel* DiscWrapperFrame::GetCurrentPanel()
{
    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Front") )   // Find selected pattern
        return(PanelF);
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Inside") )
        return(PanelI);
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Back") )
        return(PanelB);
    else
        return(PanelD);
}

int DiscWrapperFrame::GetCurrentPage()
{
    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Front") )   // Find selected pattern
        return(0);
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Inside") )
        return(1);
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Back") )
        return(2);
    else
        return(3);
}


/*************************************************************
 *  Custom stuff: dialogs, etc.
 *
 *************************************************************/
void DiscWrapperFrame::On_PREFERENCES(wxCommandEvent& event)    // Shows PreferencesDialog
{
    CFs.LocalDir();
    PreferencesDialog( this, wxID_ANY).ShowModal();  // Shows PreferencesDialog

    if ( wxFile::Exists(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("defaults0")) == false )
        return;

    int j, g;
    char *c;
    wxFile file;
    wxString path, temp, stemp;

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("defaults0");
    file.Open(path, wxFile::read);

    file.Read(&DClass, sizeof(int));

    file.Read(&j, sizeof(int));
    Dfont.SetPointSize(j);
    file.Read(&j, sizeof(int));
    switch (j)
    {
    case 70:
        Dfont.SetFamily(wxFONTFAMILY_DEFAULT);
        break;
    case 71:
        Dfont.SetFamily(wxFONTFAMILY_DECORATIVE);
        break;
    case 72:
        Dfont.SetFamily(wxFONTFAMILY_ROMAN);
        break;
    case 73:
        Dfont.SetFamily(wxFONTFAMILY_SCRIPT);
        break;
    case 74:
        Dfont.SetFamily(wxFONTFAMILY_SWISS);
        break;
    case 75:
        Dfont.SetFamily(wxFONTFAMILY_MODERN);
        break;
    case 76:
        Dfont.SetFamily(wxFONTFAMILY_TELETYPE);
        break;
    }
    file.Read(&j, sizeof(int));
    Dfont.SetStyle(j);
    file.Read(&j, sizeof(int));
    switch (j)
    {
    case 90:
        Dfont.SetWeight(wxFONTWEIGHT_NORMAL);
        break;
    case 91:
        Dfont.SetWeight(wxFONTWEIGHT_LIGHT);
        break;
    case 92:
        Dfont.SetWeight(wxFONTWEIGHT_BOLD);
        break;
    }

    file.Read(&j, sizeof(int));
    c = new char[j];
    for ( g = 0 ; g < j ; g++ )
        file.Read(&c[g], sizeof(char));
    temp = wxString::From8BitData(c);
    for ( g = 0 ; g < temp.Len()-(temp.Len()-j) ; g++ )
        stemp += temp[g];
    delete[] c;
    Dfont.SetFaceName(stemp);

    file.Read(&FilesOnly, sizeof(bool));
    file.Read(&Hidden, sizeof(bool));

    unsigned char R, G, B, A;

    file.Read(&R, sizeof(unsigned char));
    file.Read(&G, sizeof(unsigned char));
    file.Read(&B, sizeof(unsigned char));
    file.Read(&A, sizeof(unsigned char));

    DColour.Set(R, G, B, A);

    file.Close();
}

void DiscWrapperFrame::OnAbout(wxCommandEvent& event)   // About dialog
{
    if ( AboutDialog( this, wxID_ANY).ShowModal() == wxID_OK )  // Shows AboutDialog
    {
    }
}

bool DiscWrapperFrame::ConfirmClose()       // Confirmation asking before closing an unsaved project
{
    wxString path, name, temp;
    int i, choice;
    ConfirmCloseDialog dialog(this,wxID_ANY);
    if ( dialog.ShowModal() == wxID_OK )
    {
        choice = dialog.GetChoice();
    }
    switch (choice)
    {
    case 1:

        if ( STATUS == _("Unsaved") )
        {
            wxFileDialog FileDialog1(this, _("Choose a file"), ProjectPath, _(""), _("DiscWrapper project files (*.dwp)|*.dwp"), wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize);

            if (FileDialog1.ShowModal() == wxID_OK)
            {
                LastDir = path = FileDialog1.GetDirectory();
                name = FileDialog1.GetFilename();
            }
            else
                return false;
            i = name.Len();
            if ( (name[i-4] != '.') or (name[i-3] != 'd') or (name[i-2] != 'w') or (name[i-1] != 'p') )
                path = path + _T("/") + name + _T(".dwp");
            else
                path = path + _T("/") + name;
        }
        else if ( STATUS == _("Modified") )
        {
            path = SPATH;
        }

        Saving(path);

        return(true);
    case 2:
        return(true);
    case 3:
        return(false);
    }
}


/*************************************************************
 *  Recent projects
 *
 *************************************************************/
void DiscWrapperFrame::UpdateRecents()      // Update the list in File menu and save the new list of recents
{
    CFs.DWLog(_T(">>>> Updating recents"));
#if defined(__UNIX__)
    if ( wxDir::Exists(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("")) == false )
        wxMkdir(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T(""));
#endif

    CFs.DWLog(_T("."));

    wxFile file;
    int i, j = rec;
    wxString path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("recent");
    wxString recsT[rec+1];
    recsT[0] = SPATH;
    CFs.DWLog(_T("."));
    for ( i = 0 ; i < rec ; i++ )
    {
        if ( SPATH != recs[i] )
            recsT[i+1-rec+j] = recs[i];
        else
            j--;
    }
    CFs.DWLog(_T("."));

#if defined(__UNIX__)
    for ( i = 0 ; i < rec ; i++ )
    {
        switch (i)
        {
        case 0:
            Disconnect(ID_RECENT1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents1);
            Menu1->Destroy(Recent1);
            break;
        case 1:
            Disconnect(ID_RECENT2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents2);
            Menu1->Destroy(Recent2);
            break;
        case 2:
            Disconnect(ID_RECENT3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents3);
            Menu1->Destroy(Recent3);
            break;
        case 3:
            Disconnect(ID_RECENT4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents4);
            Menu1->Destroy(Recent4);
            break;
        case 4:
            Disconnect(ID_RECENT5,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents5);
            Menu1->Destroy(Recent5);
            break;
        }
    }
#endif

    rec++;

    if ( (6 == rec) or (SPATH == recs[0]) or (SPATH == recs[1]) or (SPATH == recs[2]) or (SPATH == recs[3]) or (SPATH == recs[4]) )
        rec--;
    /*if ( rec > 1 )
        delete[] recs;
    recs = new wxString[5];*/
    for ( i = 0 ; i < rec ; i++ )
        recs[i] = recsT[i];

    CFs.DWLog(_T("."));
    file.Create(path, true, wxS_DEFAULT);
    file.Write(&rec, sizeof(int));

    for ( i = 0 ; i < rec ; i++ )
    {
        CFs.DWLog(_T("."));
        j = recs[i].Len();
        file.Write(&j, sizeof(int));
        for ( j = 0 ; j < recs[i].Len() ; j++ )
            file.Write(&recs[i][j], sizeof(char));

#if defined(__UNIX__)
        switch (i)
        {
        case 0:
            Recent1 = new wxMenuItem(Menu1, ID_RECENT1, recs[0], wxEmptyString, wxITEM_NORMAL);
            Menu1->Insert(10, Recent1);
            Connect(ID_RECENT1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents1);
            break;
        case 1:
            Recent2 = new wxMenuItem(Menu1, ID_RECENT2, recs[1], wxEmptyString, wxITEM_NORMAL);
            Menu1->Insert(11, Recent2);
            Connect(ID_RECENT2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents2);
            break;
        case 2:
            Recent3 = new wxMenuItem(Menu1, ID_RECENT3, recs[2], wxEmptyString, wxITEM_NORMAL);
            Menu1->Insert(12, Recent3);
            Connect(ID_RECENT3,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents3);
            break;
        case 3:
            Recent4 = new wxMenuItem(Menu1, ID_RECENT4, recs[3], wxEmptyString, wxITEM_NORMAL);
            Menu1->Insert(13, Recent4);
            Connect(ID_RECENT4,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents4);
            break;
        case 4:
            Recent5 = new wxMenuItem(Menu1, ID_RECENT5, recs[4], wxEmptyString, wxITEM_NORMAL);
            Menu1->Insert(14, Recent5);
            Connect(ID_RECENT5,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::Recents5);
            break;
        }
#endif
    }
    file.Close();

    CFs.DWLog(_T("Ok\n"));
}

void DiscWrapperFrame::Recents1(wxCommandEvent& event)      // Load recent project 1
{
    if ( wxFile::Exists(recs[0]) == true )
    {
        wxString path;

        if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        {
            if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
                if ( ConfirmClose() == false )
                    return;

            path = recs[0];
        }
        else
        {
            path = recs[0];
        }
        if ( SPATH != wxEmptyString )
            UpdateRecents();
        OpenProject(path);
    }
    else
        wxMessageDialog(this, _("File no longer exists."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
}

void DiscWrapperFrame::Recents2(wxCommandEvent& event)      // Load recent project 2
{
    if ( wxFile::Exists(recs[1]) == true )
    {
        wxString path;

        if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        {
            if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
                if ( ConfirmClose() == false )
                    return;

            path = recs[1];

        }
        else
        {
            path = recs[1];
        }
        if ( SPATH != wxEmptyString )
            UpdateRecents();
        OpenProject(path);
    }
    else
        wxMessageDialog(this, _("File no longer exists."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
}

void DiscWrapperFrame::Recents3(wxCommandEvent& event)      // Load recent project 3
{
    if ( wxFile::Exists(recs[2]) == true )
    {
        wxString path;

        if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        {
            if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
                if ( ConfirmClose() == false )
                    return;

            path = recs[2];

        }
        else
        {
            path = recs[2];
        }
        if ( SPATH != wxEmptyString )
            UpdateRecents();
        OpenProject(path);
    }
    else
        wxMessageDialog(this, _("File no longer exists."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
}

void DiscWrapperFrame::Recents4(wxCommandEvent& event)      // Load recent project 4
{
    if ( wxFile::Exists(recs[3]) == true )
    {
        wxString path;

        if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        {
            if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
                if ( ConfirmClose() == false )
                    return;

            path = recs[3];

        }
        else
        {
            path = recs[3];
        }
        if ( SPATH != wxEmptyString )
            UpdateRecents();
        OpenProject(path);
    }
    else
        wxMessageDialog(this, _("File no longer exists."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
}

void DiscWrapperFrame::Recents5(wxCommandEvent& event)      // Load recent project 5
{
    if ( wxFile::Exists(recs[4]) == true )
    {
        wxString path;

        if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
        {
            if ( (STATUS == _("Unsaved")) or (STATUS == _("Modified")) )
                if ( ConfirmClose() == false )
                    return;

            path = recs[4];

        }
        else
        {
            path = recs[4];
        }
        if ( SPATH != wxEmptyString )
            UpdateRecents();
        OpenProject(path);
    }
    else
        wxMessageDialog(this, _("File no longer exists."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
}


/*************************************************************
 *  'Select next item'
 *
 *************************************************************/
void DiscWrapperFrame::OnSelectNext(wxCommandEvent& event)
{
    int Cpage = GetCurrentPage();

    if ( (Database->Page[Cpage].labels.GetCount() == 0) and (Database->Page[Cpage].lists.GetCount() == 0) and (Database->Page[Cpage].images.GetCount() == 0) )
        return;

    if ( ActiveTool == 1 )
    {
        SelectNextLabel(SelectedItem);
    }
    else if ( ActiveTool == 2 )
    {
        SelectNextList(SelectedItem);
    }
    else if ( ActiveTool == 3 )
    {
        SelectNextImage(SelectedItem);
    }

    RDO();
}

void DiscWrapperFrame::SelectNextLabel(int place)
{
    int Cpage = GetCurrentPage(), quantity = Database->Page[Cpage].labels.GetCount();

    place++;

    if ( place >= quantity )
    {
        SelectNextList(-1);
        return;
    }

    if ( ActiveTool != 1 )
    {
        SetTextTool();
        MenuItem10->Check();
    }
    SelectedItem = place;
    Choice1->SetSelection(Database->Page[Cpage].labels[SelectedItem].Class);
    ToggleButton1->SetValue(Database->Page[Cpage].labels[SelectedItem].Bend);
}

void DiscWrapperFrame::SelectNextList(int place)
{
    int Cpage = GetCurrentPage(), quantity = Database->Page[Cpage].lists.GetCount();

    place++;

    if ( place >= quantity )
    {
        SelectNextImage(-1);
        return;
    }

    if ( ActiveTool != 2 )
    {
        SetListTool();
        MenuItem10->Check();
    }
    SelectedItem = place;
}

void DiscWrapperFrame::SelectNextImage(int place)
{
    int Cpage = GetCurrentPage(), quantity = Database->Page[Cpage].images.GetCount();

    place++;

    if ( place >= quantity )
    {
        SelectNextLabel(-1);
        return;
    }

    int i = 0;
    while ( Database->Page[Cpage].ImageOrder.Item(i) != place )
        i++;
    SelectedItem = Database->Page[Cpage].ImageOrder.Item(i);

    if ( ActiveTool != 3 )
    {
        SetImageTool();
        MenuItem10->Check();
    }
    AbleTool(3 , true);
}
