/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef EDITLISTDIALOG_H
#define EDITLISTDIALOG_H

#include "CommonFunctions.h"

//(*Headers(EditListDialog)
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/grid.h>
#include <wx/bmpbuttn.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)
#include <wx/menu.h>

class EditListDialog: public wxDialog
{
	public:

		EditListDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~EditListDialog();

		void SetTableData(int columns, int rows, wxArrayString *data);
		wxArrayString GetData(){ return(m_DataArray); }

		//(*Declarations(EditListDialog)
		wxButton* Button1;
		wxBitmapButton* BitmapButton2;
		wxGrid* Grid1;
		wxBitmapButton* BitmapButton1;
		wxButton* Button2;
		wxStaticLine* StaticLine1;
		wxBitmapButton* BitmapButton3;
		//*)

	protected:

		//(*Identifiers(EditListDialog)
		static const long ID_BITMAPBUTTON1;
		static const long ID_BITMAPBUTTON2;
		static const long ID_BITMAPBUTTON3;
		static const long ID_STATICLINE1;
		static const long ID_GRID1;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		//*)

        static const long ID_POPAPPROW;
        static const long ID_POPINSERTROW;
        static const long ID_POPDELROW;
        static const long ID_POPAPPCOL;
        static const long ID_POPINSERTCOL;
        static const long ID_POPDELCOL;

        wxArrayString m_DataArray;

	private:

		//(*Handlers(EditListDialog)
		void OnOk(wxCommandEvent& event);
		void OnCancel(wxCommandEvent& event);
		void OnGrid1LabelRightClick(wxGridEvent& event);
		void OnAlign(wxCommandEvent& event);
		//*)
        void OnAppRow(wxCommandEvent& event);
        void OnDelRow(wxCommandEvent& event);
        void OnInsRow(wxCommandEvent& event);
        void OnInsCol(wxCommandEvent& event);
        void OnDelCol(wxCommandEvent& event);
        void OnAppCol(wxCommandEvent& event);

        wxMenuItem *PopAppRow;
        wxMenuItem *PopInsertRow;
        wxMenuItem *PopDelRow;
        wxMenuItem *PopAppCol;
        wxMenuItem *PopInsertCol;
        wxMenuItem *PopDelCol;
        wxMenu *PopRow;
        wxMenu *PopCol;

        int LastC, LastR;
        wxString Header;

        CommonFunctions CFs;

		DECLARE_EVENT_TABLE()
};

#endif
