/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.view.ServerTable;
import org.jsampler.view.ServerTableModel;
import org.jsampler.view.std.JSAddServerDlg;
import org.jsampler.view.std.StdI18n;

public class JSConnectionPropsPane
extends JPanel {
    private final JCheckBox checkManualSelect = new JCheckBox(StdI18n.i18n.getLabel("JSConnectionPropsPane.checkManualSelect"));
    private final JLabel lReadTimeout = new JLabel(StdI18n.i18n.getLabel("JSConnectionPropsPane.lReadTimeout"));
    private final JSpinner spinnerTimeout = new JSpinner(new SpinnerNumberModel(0, 0, 2000, 1));
    private final ServerListPane serverListPane;
    private final LocalSettingsPane localSettingsPane = new LocalSettingsPane();

    public JSConnectionPropsPane() {
        this.setLayout(new BoxLayout(this, 1));
        boolean bl = JSConnectionPropsPane.preferences().getBoolProperty("manualServerSelectOnStartup");
        this.checkManualSelect.setSelected(bl);
        this.checkManualSelect.setAlignmentX(0.0f);
        this.add(this.checkManualSelect);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lReadTimeout);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        int n = JSConnectionPropsPane.preferences().getIntProperty("socketReadTimeout");
        this.spinnerTimeout.setValue(n);
        jPanel.add(this.spinnerTimeout);
        jPanel.setAlignmentX(0.0f);
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel.getPreferredSize().height));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.serverListPane = this.createServerListPane();
        this.add(this.serverListPane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.localSettingsPane);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    private ServerListPane createServerListPane() {
        ServerListPane serverListPane = new ServerListPane();
        serverListPane.setPreferredSize(new Dimension(200, 160));
        serverListPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        String string = StdI18n.i18n.getLabel("JSConnectionPropsPane.title");
        serverListPane.setBorder(BorderFactory.createTitledBorder(string));
        serverListPane.setAlignmentX(0.0f);
        return serverListPane;
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public int getReadTimeout() {
        return Integer.parseInt(this.spinnerTimeout.getValue().toString());
    }

    public void apply() {
        boolean bl = this.checkManualSelect.isSelected();
        JSConnectionPropsPane.preferences().setBoolProperty("manualServerSelectOnStartup", bl);
        JSConnectionPropsPane.preferences().setIntProperty("socketReadTimeout", this.getReadTimeout());
        CC.setClientReadTimeout(this.getReadTimeout());
        int n = this.serverListPane.serverTable.getSelectedRow();
        if (n != -1) {
            JSConnectionPropsPane.preferences().setIntProperty("serverIndex", n);
        }
        this.localSettingsPane.apply();
    }

    public static class LocalSettingsPane
    extends JPanel {
        private final JCheckBox checkLaunchBackend = new JCheckBox(StdI18n.i18n.getLabel("JSConnectionPropsPane.checkLaunchBackend"));
        private final JLabel lCommand = new JLabel(StdI18n.i18n.getLabel("JSConnectionPropsPane.lCommand"));
        private final JLabel lDelay = new JLabel(StdI18n.i18n.getLabel("JSConnectionPropsPane.lDelay"));
        private final JLabel lSeconds = new JLabel(StdI18n.i18n.getLabel("JSConnectionPropsPane.lSeconds"));
        private final JTextField tfCommand = new JTextField();
        private final JSpinner spinnerDelay;

        public LocalSettingsPane() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 3, 3, 3);
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints(this.checkLaunchBackend, gridBagConstraints);
            this.add(this.checkLaunchBackend);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(3, 9, 3, 3);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.lCommand, gridBagConstraints);
            this.add(this.lCommand);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(this.lDelay, gridBagConstraints);
            this.add(this.lDelay);
            this.spinnerDelay = new JSpinner(new SpinnerNumberModel(3, 0, 100, 1));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.spinnerDelay, gridBagConstraints);
            this.add(this.spinnerDelay);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.lSeconds, gridBagConstraints);
            this.add(this.lSeconds);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.tfCommand, gridBagConstraints);
            this.add(this.tfCommand);
            String string = StdI18n.i18n.getLabel("JSConnectionPropsPane.localSettings");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
            this.setAlignmentX(0.0f);
            this.checkLaunchBackend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LocalSettingsPane.this.updateLocalSettingsState();
                }
            });
            boolean bl = JSConnectionPropsPane.preferences().getBoolProperty("launchBackednLocally");
            this.checkLaunchBackend.setSelected(bl);
            string = JSConnectionPropsPane.preferences().getStringProperty("backendLaunchCommand");
            this.tfCommand.setText(string);
            int n = JSConnectionPropsPane.preferences().getIntProperty("backendLaunchDelay");
            this.spinnerDelay.setValue(n);
            this.updateLocalSettingsState();
        }

        private void updateLocalSettingsState() {
            boolean bl = this.checkLaunchBackend.isSelected();
            this.tfCommand.setEnabled(bl);
            this.spinnerDelay.setEnabled(bl);
        }

        public void apply() {
            boolean bl = this.checkLaunchBackend.isSelected();
            JSConnectionPropsPane.preferences().setBoolProperty("launchBackednLocally", bl);
            JSConnectionPropsPane.preferences().setStringProperty("backendLaunchCommand", this.tfCommand.getText());
            int n = Integer.parseInt(this.spinnerDelay.getValue().toString());
            JSConnectionPropsPane.preferences().setIntProperty("backendLaunchDelay", n);
        }
    }

    public static class ServerListPane
    extends JPanel {
        protected final ServerTable serverTable;
        private final JButton btnAdd = new JButton(StdI18n.i18n.getButtonLabel("add"));
        private final JButton btnRemove = new JButton(StdI18n.i18n.getButtonLabel("remove"));
        private final JButton btnMoveUp = new JButton(StdI18n.i18n.getButtonLabel("JSConnectionPropsPane.btnMoveUp"));
        private final JButton btnMoveDown = new JButton(StdI18n.i18n.getButtonLabel("JSConnectionPropsPane.btnMoveDown"));

        public ServerListPane() {
            this.setLayout(new BoxLayout(this, 0));
            ServerTableModel serverTableModel = new ServerTableModel(CC.getServerList());
            this.serverTable = new ServerTable(serverTableModel);
            this.add(new JScrollPane(this.serverTable));
            int n = this.btnAdd.getPreferredSize().height;
            this.btnAdd.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            n = this.btnRemove.getPreferredSize().height;
            this.btnRemove.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            n = this.btnMoveUp.getPreferredSize().height;
            this.btnMoveUp.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            n = this.btnMoveDown.getPreferredSize().height;
            this.btnMoveDown.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.btnAdd);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel.add(this.btnRemove);
            jPanel.add(Box.createRigidArea(new Dimension(0, 17)));
            jPanel.add(this.btnMoveUp);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel.add(this.btnMoveDown);
            jPanel.add(Box.createGlue());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add(jPanel);
            this.installListeners();
            int n2 = JSConnectionPropsPane.preferences().getIntProperty("serverIndex");
            int n3 = CC.getServerList().getServerCount();
            if (n3 > 0) {
                if (n2 < 0 || n2 >= n3) {
                    this.serverTable.getSelectionModel().setSelectionInterval(0, 0);
                } else {
                    this.serverTable.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        }

        private void installListeners() {
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerListPane.this.addServer();
                }
            });
            this.btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerListPane.this.removeServer();
                }
            });
            this.btnMoveUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerListPane.this.serverTable.moveSelectedServerUp();
                }
            });
            this.btnMoveDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerListPane.this.serverTable.moveSelectedServerDown();
                }
            });
            ServerSelectionHandler serverSelectionHandler = new ServerSelectionHandler();
            this.serverTable.getSelectionModel().addListSelectionListener(serverSelectionHandler);
        }

        private void addServer() {
            int n = this.serverTable.getSelectedRow();
            Window window = JuifeUtils.getWindow(this);
            JSAddServerDlg jSAddServerDlg = window instanceof Dialog ? new JSAddServerDlg((Dialog)window) : (window instanceof Frame ? new JSAddServerDlg((Frame)window) : new JSAddServerDlg(CC.getMainFrame()));
            jSAddServerDlg.setVisible(true);
            if (jSAddServerDlg.isCancelled()) {
                return;
            }
            this.serverTable.getSelectionModel().setSelectionInterval(n, n);
        }

        private void removeServer() {
            if (CC.getServerList().getServerCount() < 2) {
                Window window = JuifeUtils.getWindow(this);
                String string = StdI18n.i18n.getError("JSConnectionPropsPane.cantRemove");
                if (window instanceof Dialog) {
                    HF.showErrorMessage(string, (Component)((Dialog)window));
                } else if (window instanceof Frame) {
                    HF.showErrorMessage(string, (Component)((Frame)window));
                }
                return;
            }
            this.serverTable.removeSelectedServer();
        }

        private class ServerSelectionHandler
        implements ListSelectionListener {
            private ServerSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (ServerListPane.this.serverTable.getSelectedServer() == null) {
                    ServerListPane.this.btnMoveUp.setEnabled(false);
                    ServerListPane.this.btnMoveDown.setEnabled(false);
                    return;
                }
                int n = ServerListPane.this.serverTable.getSelectedRow();
                ServerListPane.this.btnMoveUp.setEnabled(n != 0);
                ServerListPane.this.btnMoveDown.setEnabled(n != ServerListPane.this.serverTable.getRowCount() - 1);
            }
        }
    }
}

