/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.ICloud;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.ITextInput;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

public class RSSInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("RSS");
        this.processFeed(root, feed);
    }

    private void processFeed(Element element, IFeed feed) {
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (this.processAttributeExtern(attribute, feed) || !"version".equals(name)) continue;
            feed.setFormat(this.buildFormat("RSS", attribute.getValue()));
        }
        List feedChildren = element.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed) || !"channel".equals(name)) continue;
            this.processChannel(child, feed);
        }
    }

    private void processChannel(Element element, IFeed feed) {
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            this.processAttributeExtern(attribute, feed);
        }
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("item".equals(name)) {
                this.processItems(child, feed);
                continue;
            }
            if ("title".equals(name)) {
                feed.setTitle(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("link".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null && StringUtils.isSet(uri.toString())) {
                    feed.setHomepage(uri);
                }
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("description".equals(name)) {
                feed.setDescription(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("pubdate".equals(name)) {
                feed.setPublishDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("image".equals(name)) {
                this.processImage(child, feed);
                continue;
            }
            if ("language".equals(name)) {
                feed.setLanguage(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("copyright".equals(name)) {
                feed.setCopyright(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("webmaster".equals(name)) {
                feed.setWebmaster(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("managingeditor".equals(name)) {
                IPerson person = Owl.getModelFactory().createPerson(null, feed);
                person.setName(child.getText());
                this.processNamespaceAttributes(child, person);
                continue;
            }
            if ("lastbuilddate".equals(name)) {
                feed.setLastBuildDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("category".equals(name)) {
                this.processCategory(child, feed);
                continue;
            }
            if ("generator".equals(name)) {
                feed.setGenerator(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("docs".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    feed.setDocs(uri);
                }
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("rating".equals(name)) {
                feed.setRating(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("ttl".equals(name)) {
                int ttl = StringUtils.stringToInt(child.getTextNormalize());
                if (ttl >= 0) {
                    feed.setTTL(ttl);
                }
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("skiphours".equals(name)) {
                this.processNamespaceAttributes(child, feed);
                List skipHoursChildren = child.getChildren("hour");
                for (Element skipHour : skipHoursChildren) {
                    this.processNamespaceAttributes(skipHour, feed);
                    int hour = StringUtils.stringToInt(skipHour.getTextNormalize());
                    if (hour < 0 || hour >= 24) continue;
                    feed.addHourToSkip(hour);
                }
                continue;
            }
            if ("skipdays".equals(name)) {
                this.processNamespaceAttributes(child, feed);
                List skipDaysChildren = child.getChildren("day");
                for (Element skipDay : skipDaysChildren) {
                    this.processNamespaceAttributes(skipDay, feed);
                    String day = skipDay.getText().toLowerCase();
                    int index = IFeed.DAYS.indexOf(day);
                    if (index < 0) continue;
                    feed.addDayToSkip(index);
                }
                continue;
            }
            if ("textinput".equals(name)) {
                this.processTextInput(child, feed);
                continue;
            }
            if (!"cloud".equals(name)) continue;
            this.processCloud(child, feed);
        }
    }

    private void processCloud(Element element, IFeed feed) {
        ICloud cloud = Owl.getModelFactory().createCloud(feed);
        List cloudAttributes = element.getAttributes();
        for (Attribute attribute : cloudAttributes) {
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, cloud)) continue;
            if ("domain".equals(name)) {
                cloud.setDomain(attribute.getValue());
                continue;
            }
            if ("path".equals(name)) {
                cloud.setPath(attribute.getValue());
                continue;
            }
            if ("port".equals(name)) {
                int port = StringUtils.stringToInt(attribute.getValue());
                if (port < 0) continue;
                cloud.setPort(port);
                continue;
            }
            if ("registerprocedure".equals(name)) {
                cloud.setRegisterProcedure(attribute.getValue());
                continue;
            }
            if (!"protocol".equals(name)) continue;
            cloud.setProtocol(attribute.getValue());
        }
    }

    private void processCategory(Element element, IEntity type) {
        ICategory category = Owl.getModelFactory().createCategory(null, type);
        category.setName(element.getText());
        List categoryAttributes = element.getAttributes();
        for (Attribute attribute : categoryAttributes) {
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, category) || !"domain".equals(name)) continue;
            category.setDomain(attribute.getValue());
        }
    }

    private void processImage(Element element, IFeed feed) {
        IImage image = Owl.getModelFactory().createImage(feed);
        this.processNamespaceAttributes(element, image);
        List imageChilds = element.getChildren();
        for (Element child : imageChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, image)) continue;
            if ("url".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    image.setLink(uri);
                }
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("title".equals(name)) {
                image.setTitle(child.getText());
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("link".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    image.setHomepage(uri);
                }
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("description".equals(name)) {
                image.setDescription(child.getText());
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("width".equals(name)) {
                int width = StringUtils.stringToInt(child.getTextNormalize());
                if (width >= 0) {
                    image.setWidth(width);
                }
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if (!"height".equals(name)) continue;
            int height = StringUtils.stringToInt(child.getTextNormalize());
            if (height >= 0) {
                image.setHeight(height);
            }
            this.processNamespaceAttributes(child, image);
        }
    }

    private void processItems(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        this.processNamespaceAttributes(element, news);
        List newsChilds = element.getChildren();
        for (Element child : newsChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, news)) continue;
            if ("title".equals(name)) {
                news.setTitle(child.getText());
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("link".equals(name)) {
                URI uri;
                if (child.getText().length() > 0 && (uri = URIUtils.createURI(child.getText())) != null) {
                    news.setLink(uri);
                }
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("description".equals(name)) {
                news.setDescription(child.getText());
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("pubdate".equals(name)) {
                news.setPublishDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("author".equals(name)) {
                IPerson person = Owl.getModelFactory().createPerson(null, news);
                person.setName(child.getText());
                this.processNamespaceAttributes(child, person);
                continue;
            }
            if ("comments".equals(name)) {
                news.setComments(child.getText());
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("enclosure".equals(name)) {
                this.processEnclosure(child, news);
                continue;
            }
            if ("category".equals(name)) {
                this.processCategory(child, news);
                continue;
            }
            if ("guid".equals(name)) {
                this.processGuid(child, news);
                continue;
            }
            if (!"source".equals(name)) continue;
            this.processSource(child, news);
        }
    }

    private void processEnclosure(Element element, INews news) {
        URI attachmentUri = null;
        String attachmentType = null;
        int attachmentLength = -1;
        List attachmentAttributes = element.getAttributes();
        for (Attribute attribute : attachmentAttributes) {
            String name = attribute.getName().toLowerCase();
            if ("url".equals(name)) {
                URI uri = URIUtils.createURI(attribute.getValue());
                if (uri == null) continue;
                attachmentUri = uri;
                continue;
            }
            if ("type".equals(name)) {
                attachmentType = attribute.getValue();
                continue;
            }
            if (!"length".equals(name)) continue;
            attachmentLength = StringUtils.stringToInt(attribute.getValue());
        }
        if (attachmentUri != null && !CoreUtils.hasAttachment(news, attachmentUri)) {
            IAttachment attachment = Owl.getModelFactory().createAttachment(null, news);
            attachment.setLink(attachmentUri);
            if (StringUtils.isSet(attachmentType)) {
                attachment.setType(attachmentType);
            }
            if (attachmentLength != -1) {
                attachment.setLength(attachmentLength);
            }
            for (Attribute attribute : attachmentAttributes) {
                this.processAttributeExtern(attribute, attachment);
            }
        }
    }

    private void processSource(Element element, INews news) {
        ISource source = Owl.getModelFactory().createSource(news);
        source.setName(element.getText());
        this.processNamespaceAttributes(element, source);
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            URI uri;
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, source) || !"url".equals(name) || (uri = URIUtils.createURI(attribute.getValue())) == null) continue;
            source.setLink(uri);
        }
    }

    private void processGuid(Element element, INews news) {
        Boolean permaLink = null;
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName().toLowerCase();
            if (!"ispermalink".equals(name)) continue;
            permaLink = Boolean.parseBoolean(attribute.getValue());
        }
        Owl.getModelFactory().createGuid(news, element.getText(), permaLink);
    }

    private void processTextInput(Element element, IFeed feed) {
        ITextInput input = Owl.getModelFactory().createTextInput(feed);
        this.processNamespaceAttributes(element, input);
        List inputChilds = element.getChildren();
        for (Element child : inputChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, input)) continue;
            if ("title".equals(name)) {
                input.setTitle(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if ("description".equals(name)) {
                input.setDescription(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if ("name".equals(name)) {
                input.setName(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if (!"link".equals(name)) continue;
            URI uri = URIUtils.createURI(child.getText());
            if (uri != null) {
                input.setLink(uri);
            }
            this.processNamespaceAttributes(child, input);
        }
    }
}

