/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.rssowl.core.persist.ISearchValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchValueType
implements ISearchValueType {
    private final int fType;
    private List<String> fEnumValues;
    static final SearchValueType STRING = new SearchValueType(0);
    static final SearchValueType INTEGER = new SearchValueType(4);
    static final SearchValueType DATETIME = new SearchValueType(3);
    static final SearchValueType BOOLEAN = new SearchValueType(6);
    static final SearchValueType LINK = new SearchValueType(8);

    public SearchValueType(int type) {
        Assert.isLegal((type != 7 ? 1 : 0) != 0, (String)"Use the other constructor to supply a list of Enumeration values.");
        this.fType = type;
    }

    public SearchValueType(List<String> enumValues) {
        Assert.isNotNull(enumValues, (String)"The type SearchValueType of Type ENUM requires a List of Enum-Values that is not NULL");
        this.fEnumValues = enumValues;
        this.fType = 7;
    }

    @Override
    public synchronized int getId() {
        return this.fType;
    }

    @Override
    public synchronized List<String> getEnumValues() {
        return Collections.unmodifiableList(this.fEnumValues);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Object object = obj;
        synchronized (object) {
            SearchValueType s = (SearchValueType)obj;
            if (this.fType == 7 && s.fType == 7) {
                return this.fEnumValues.equals(s.fEnumValues);
            }
            return this.fType == s.fType;
        }
    }

    public synchronized int hashCode() {
        if (this.fType != 7) {
            return (this.fType * this.getClass().hashCode() + 17) * 37;
        }
        return this.fEnumValues.hashCode();
    }

    public synchronized String toString() {
        String type;
        switch (this.fType) {
            case 6: {
                type = "Boolean";
                break;
            }
            case 1: {
                type = "Date";
                break;
            }
            case 3: {
                type = "DateTime";
                break;
            }
            case 7: {
                type = "Enum";
                break;
            }
            case 4: {
                type = "Integer";
                break;
            }
            case 5: {
                type = "Number";
                break;
            }
            case 0: {
                type = "String";
                break;
            }
            case 2: {
                type = "Time";
                break;
            }
            case 8: {
                type = "Link";
                break;
            }
            default: {
                type = "Unknown";
            }
        }
        if (this.fType != 7) {
            return String.valueOf(super.toString()) + "(Type = " + type + ")";
        }
        return String.valueOf(super.toString()) + "(Type = " + type + ", Values = " + this.fEnumValues + ")";
    }
}

