/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.dao.AbstractPersistableDAO;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.EntityIdsByEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitiesToBeIndexedDAOImpl
extends AbstractPersistableDAO<EntityIdsByEventType> {
    private volatile EntityIdsByEventType fEntityIds;

    public EntitiesToBeIndexedDAOImpl() {
        super(EntityIdsByEventType.class, true);
    }

    public final EntityIdsByEventType load() {
        return this.fEntityIds;
    }

    @Override
    protected void onDatabaseOpened(DatabaseEvent event) {
        super.onDatabaseOpened(event);
        EntityIdsByEventType entityIds = this.doLoad();
        if (entityIds == null) {
            entityIds = new EntityIdsByEventType(false);
            this.save(entityIds);
        }
        this.fEntityIds = entityIds;
    }

    @Override
    protected void preCommit() {
    }

    private EntityIdsByEventType doLoad() {
        Collection entityIdsCollection = super.loadAll();
        Assert.isLegal((entityIdsCollection.size() <= 1 ? 1 : 0) != 0, (String)("There shouldn't be more than 1 EntityIdsByEventType, size: " + entityIdsCollection.size()));
        Iterator iterator = entityIdsCollection.iterator();
        if (iterator.hasNext()) {
            EntityIdsByEventType entityIds = (EntityIdsByEventType)iterator.next();
            return entityIds;
        }
        return null;
    }

    @Override
    protected void onDatabaseClosed(DatabaseEvent event) {
        super.onDatabaseClosed(event);
        this.fEntityIds = null;
    }

    @Override
    public final void delete(EntityIdsByEventType newsCounter) {
        if (!newsCounter.equals(this.load())) {
            throw new IllegalArgumentException("Only a single entity should be used. Trying to delete a non-existent one.");
        }
        super.delete(newsCounter);
    }

    @Override
    public Collection<EntityIdsByEventType> loadAll() {
        ArrayList<EntityIdsByEventType> newsCounters = new ArrayList<EntityIdsByEventType>(1);
        newsCounters.add(this.load());
        return newsCounters;
    }

    @Override
    public final void saveAll(Collection<EntityIdsByEventType> entities) {
        if (entities.size() > 1) {
            throw new IllegalArgumentException("Only a single entity can be stored");
        }
        super.saveAll(entities);
    }

    @Override
    protected final void doSave(EntityIdsByEventType entity) {
        if (!this.fDb.ext().isStored((Object)entity) && this.load() != null) {
            throw new IllegalArgumentException("Only a single entity can be stored");
        }
        super.doSave(entity);
    }
}

