/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.search.Indexer;
import org.rssowl.core.internal.persist.search.Messages;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexingTask
implements ITask {
    private final Indexer fIndexer;
    private final EventType fTaskType;
    private final List<INews> fNews;
    private final Collection<NewsReference> fNewsRefs;
    private final RemovedNewsRefsListener fRemovedNewsRefsListener;

    IndexingTask(Indexer indexer, Set<NewsEvent> events, EventType taskType) {
        this(indexer, IndexingTask.getNews(events, taskType), taskType);
    }

    private static List<INews> getNews(Set<NewsEvent> events, EventType taskType) {
        ArrayList<INews> news = new ArrayList<INews>(events.size());
        for (NewsEvent event : events) {
            if (taskType == EventType.PERSIST && event.getEntity().getState().equals((Object)INews.State.DELETED)) continue;
            news.add(event.getEntity());
        }
        return news;
    }

    IndexingTask(Indexer indexer, Collection<INews> news, EventType taskType) {
        this.fIndexer = indexer;
        this.fNews = news instanceof List ? (List<Object>)news : new ArrayList<INews>(news);
        this.fNewsRefs = null;
        this.fTaskType = taskType;
        this.fRemovedNewsRefsListener = null;
    }

    IndexingTask(Indexer indexer, EventType taskType, Collection<NewsReference> newsRefs, RemovedNewsRefsListener removedNewsRefsListener) {
        this.fIndexer = indexer;
        this.fNewsRefs = newsRefs;
        this.fNews = null;
        this.fTaskType = taskType;
        this.fRemovedNewsRefsListener = removedNewsRefsListener;
    }

    @Override
    public final String getName() {
        return Messages.IndexingTask_INDEXING_FEED;
    }

    @Override
    public final ITask.Priority getPriority() {
        return ITask.Priority.DEFAULT;
    }

    @Override
    public final IStatus run(IProgressMonitor monitor) {
        switch (this.fTaskType) {
            case PERSIST: {
                if (monitor.isCanceled() || Owl.isShuttingDown()) break;
                this.addToIndex();
                break;
            }
            case UPDATE: {
                if (monitor.isCanceled() || Owl.isShuttingDown()) break;
                this.updateIndex();
                break;
            }
            case REMOVE: {
                if (monitor.isCanceled() || Owl.isShuttingDown()) break;
                this.deleteFromIndex();
            }
        }
        return Status.OK_STATUS;
    }

    private List<INews> getNewsFromRefs(Collection<NewsReference> newsRefs) {
        ArrayList<INews> newsList = new ArrayList<INews>(newsRefs.size());
        ArrayList<NewsReference> removedNewsRefs = new ArrayList<NewsReference>(1);
        INewsDAO newsDAO = InternalOwl.getDefault().getPersistenceService().getDAOService().getNewsDAO();
        for (NewsReference newsRef : newsRefs) {
            INews news = (INews)newsDAO.load(newsRef.getId());
            if (news == null) {
                removedNewsRefs.add(newsRef);
                continue;
            }
            newsList.add(news);
        }
        if (this.fRemovedNewsRefsListener != null) {
            this.fRemovedNewsRefsListener.event(removedNewsRefs);
        }
        return newsList;
    }

    private List<NewsReference> getRefsFromNews(List<INews> newsList) {
        ArrayList<NewsReference> newsRefs = new ArrayList<NewsReference>(newsList.size());
        for (INews news : newsList) {
            newsRefs.add(new NewsReference(news.getId()));
        }
        return newsRefs;
    }

    private void addToIndex() {
        if (this.fNews == null) {
            this.fIndexer.index(this.getNewsFromRefs(this.fNewsRefs), false);
            return;
        }
        this.fIndexer.index(this.fNews, false);
    }

    private void updateIndex() {
        if (this.fNews == null) {
            this.fIndexer.index(this.getNewsFromRefs(this.fNewsRefs), true);
            return;
        }
        this.fIndexer.index(this.fNews, true);
    }

    private void deleteFromIndex() {
        try {
            if (this.fNews == null) {
                this.fIndexer.removeFromIndex(this.fNewsRefs);
                return;
            }
            this.fIndexer.removeFromIndex(this.getRefsFromNews(this.fNews));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RemovedNewsRefsListener {
        public void event(Collection<NewsReference> var1);
    }
}

