/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumberTools;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.util.HTMLStripReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchDocument<T extends IEntity> {
    protected static final int ENTITY_ID = -2;
    public static final String ENTITY_ID_TEXT = String.valueOf(-2);
    private final Document fDocument;
    private final T fType;

    public SearchDocument(T type) {
        Assert.isLegal((type != null ? 1 : 0) != 0);
        this.fType = type;
        this.fDocument = new Document();
    }

    public final T getType() {
        return this.fType;
    }

    public final Document getDocument() {
        return this.fDocument;
    }

    public abstract boolean addFields();

    protected boolean addFieldsToDocument(List<Field> fields) {
        if (fields.size() == 0) {
            return false;
        }
        for (Field field : fields) {
            this.getDocument().add((Fieldable)field);
        }
        return true;
    }

    protected boolean addField(List<Field> fields, Field field) {
        if (field == null) {
            return false;
        }
        fields.add(field);
        return true;
    }

    protected Field createDocumentIDField() {
        return new Field(ENTITY_ID_TEXT, String.valueOf(this.getType().getId()), Field.Store.YES, Field.Index.UN_TOKENIZED);
    }

    protected Field createIDField(int fieldConstant, IEntity entity, Field.Store store) {
        return new Field(String.valueOf(fieldConstant), String.valueOf(entity.getId()), store, Field.Index.UN_TOKENIZED);
    }

    protected Field createLongField(int fieldConstant, long value, Field.Store store) {
        String valueText = NumberTools.longToString((long)value);
        return new Field(String.valueOf(fieldConstant), valueText, store, Field.Index.UN_TOKENIZED);
    }

    protected Field createBooleanField(int fieldConstant, boolean value, Field.Store store) {
        return new Field(String.valueOf(fieldConstant), String.valueOf(value), store, Field.Index.UN_TOKENIZED);
    }

    protected Field createDateField(int fieldConstant, Date value, Field.Store store) {
        return this.createDateField(fieldConstant, value, store, DateTools.Resolution.DAY);
    }

    protected Field createDateField(int fieldConstant, Date value, Field.Store store, DateTools.Resolution resolution) {
        if (value == null) {
            return null;
        }
        String valueText = DateTools.dateToString((Date)value, (DateTools.Resolution)resolution);
        return new Field(String.valueOf(fieldConstant), valueText, store, Field.Index.UN_TOKENIZED);
    }

    protected Field createURIField(int fieldConstant, String value, Field.Store store, Field.Index index) {
        if (value == null) {
            return null;
        }
        return new Field(String.valueOf(fieldConstant), value.toLowerCase(), store, index);
    }

    protected Field createStringField(int fieldConstant, String value, Field.Store store, Field.Index index) {
        if (value == null) {
            return null;
        }
        return new Field(String.valueOf(fieldConstant), value, store, index);
    }

    protected Field createHTMLField(int fieldConstant, String value) {
        if (value == null) {
            return null;
        }
        return new Field(String.valueOf(fieldConstant), (Reader)new HTMLStripReader(new StringReader(value)));
    }

    protected Field createEnumField(int fieldConstant, Enum<?> value, Field.Store store) {
        if (value == null) {
            return null;
        }
        return new Field(String.valueOf(fieldConstant), String.valueOf(value.ordinal()), store, Field.Index.UN_TOKENIZED);
    }

    protected Field createPersonField(int fieldConstant, IPerson person, Field.Store store, Field.Index index) {
        if (person == null) {
            return null;
        }
        if (person.getName() != null && person.getEmail() != null) {
            return this.createStringField(fieldConstant, String.valueOf(person.getName()) + " " + person.getEmail().toString(), store, index);
        }
        if (person.getName() != null) {
            return this.createStringField(fieldConstant, person.getName(), store, index);
        }
        if (person.getEmail() != null) {
            return this.createURIField(fieldConstant, person.getEmail().toString(), store, Field.Index.UN_TOKENIZED);
        }
        return null;
    }

    protected Field createCategoriesField(int fieldConstant, List<ICategory> categories, Field.Store store, Field.Index index) {
        if (categories == null || categories.size() == 0) {
            return null;
        }
        StringBuilder categoryValues = new StringBuilder();
        for (ICategory category : categories) {
            if (category.getName() == null) continue;
            categoryValues.append(category.getName()).append('\n');
        }
        if (categoryValues.length() > 0) {
            return this.createStringField(fieldConstant, categoryValues.toString(), store, index);
        }
        return null;
    }

    protected Field createAttachmentsField(int fieldConstant, List<IAttachment> attachments, Field.Store store, Field.Index index) {
        if (attachments == null || attachments.size() == 0) {
            return null;
        }
        StringBuilder attachmentValues = new StringBuilder();
        for (IAttachment attachment : attachments) {
            if (attachment.getLink() != null) {
                attachmentValues.append(attachment.getLink()).append(" ");
            }
            if (attachment.getType() == null) continue;
            attachmentValues.append(attachment.getType()).append(" ");
        }
        if (attachmentValues.length() > 0) {
            return this.createStringField(fieldConstant, attachmentValues.toString(), store, index);
        }
        return null;
    }
}

