/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int binarySearch(long[] a, long key, int endIndex) {
        int low = 0;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void reverse(int[] array, int size) {
        int left = 0;
        int right = size - 1;
        while (left < right) {
            int temp = array[left];
            array[left] = array[right];
            array[right] = temp;
            ++left;
            --right;
        }
    }

    public static int[] ensureCapacity(int[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int[] copy = new int[newCapacity];
            System.arraycopy(array, 0, copy, 0, Math.min(oldData.length, newCapacity));
            return copy;
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            long[] copy = new long[newCapacity];
            System.arraycopy(array, 0, copy, 0, Math.min(oldData.length, newCapacity));
            return copy;
        }
        return array;
    }
}

