/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.dialogs.CustomWizardDialog;
import org.rssowl.ui.internal.dialogs.importer.ImportWizard;

public class ImportAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "org.rssowl.ui.actions.ImportFeeds";
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.importer.ImportWizard";
    private IWorkbenchWindow fWindow;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.openWizardDefault(this.fWindow.getShell());
    }

    public void openWizardDefault(Shell shell) {
        this.internalOpenWizard(shell, null, null, false, false);
    }

    public void openWizardForFeedSearch(Shell shell, String website) {
        this.internalOpenWizard(shell, null, website, false, true);
    }

    public void openWizardForKeywordSearch(Shell shell) {
        this.internalOpenWizard(shell, null, null, true, false);
    }

    public void openWizardForFileImport(Shell shell, IFolder targetFolder, String file) {
        this.internalOpenWizard(shell, targetFolder, file, false, false);
    }

    private void internalOpenWizard(Shell shell, IFolder targetFolder, final String fileOrWebsite, boolean isKeywordSearch, final boolean isWebsiteSearch) {
        final ImportWizard importWizard = new ImportWizard(targetFolder, fileOrWebsite, isKeywordSearch);
        CustomWizardDialog dialog = new CustomWizardDialog(shell, (IWizard)importWizard){

            protected boolean isResizable() {
                return true;
            }

            public int open() {
                if (StringUtils.isSet((String)fileOrWebsite) && isWebsiteSearch) {
                    importWizard.getContainer().showPage(importWizard.getNextPage(this.getCurrentPage()));
                }
                return super.open();
            }

            protected IDialogSettings getDialogBoundsSettings() {
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                IDialogSettings section = settings.getSection(ImportAction.SETTINGS_SECTION);
                if (section != null) {
                    return section;
                }
                return settings.addNewSection(ImportAction.SETTINGS_SECTION);
            }

            protected int getDialogBoundsStrategy() {
                return 2;
            }
        };
        dialog.setMinimumPageSize(0, 0);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

