/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

public class NewsBinWizard
extends Wizard
implements INewWizard {
    private IFolder fFolder;
    private IFolderChild fPosition;
    private NewNewsBinWizardPage fPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Pair<IFolder, IFolderChild> pair = ModelUtils.getLocationAndPosition(selection);
        this.fFolder = (IFolder)pair.getFirst();
        this.fPosition = (IFolderChild)pair.getSecond();
    }

    public void addPages() {
        this.fPage = new NewNewsBinWizardPage(Messages.NewsBinWizard_NEW_NEWS_BIN);
        this.setWindowTitle(Messages.NewsBinWizard_NEWS_BIN);
        this.setHelpAvailable(false);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        String name = this.fPage.getBinName();
        IModelFactory factory = Owl.getModelFactory();
        if (!StringUtils.isSet((String)name)) {
            this.fPage.setErrorMessage(Messages.NewsBinWizard_ENTER_NAME);
            this.fPage.focusInput();
            return false;
        }
        IFolder parent = this.fPage.getFolder();
        INewsBin fNewsbin = factory.createNewsBin(null, parent, name, this.fPosition, this.fPosition != null ? Boolean.valueOf(true) : null);
        Map properties = parent.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            fNewsbin.setProperty((String)property.getKey(), (Serializable)property.getValue());
        }
        DynamicDAO.save((IPersistable)parent);
        return true;
    }

    private class NewNewsBinWizardPage
    extends WizardPage {
        private Text fNameInput;
        private FolderChooser fFolderChooser;

        NewNewsBinWizardPage(String pageName) {
            super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/newsbin_wiz.gif"));
            this.setMessage(Messages.NewsBinWizard_BIN_WIZ_TITLE);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5));
            control.setLayoutData((Object)new GridData(4, 1, true, false));
            Label l1 = new Label(control, 0);
            l1.setText(Messages.NewsBinWizard_NAME);
            this.fNameInput = new Text(control, 2052);
            this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameInput.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewNewsBinWizardPage.this.setErrorMessage(null);
                }
            });
            Label l3 = new Label(control, 0);
            l3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            l3.setText(Messages.NewsBinWizard_LOCATION);
            this.fFolderChooser = new FolderChooser(control, NewsBinWizard.this.fFolder, 2048, true);
            this.fFolderChooser.setExpandStrategy(FolderChooser.ExpandStrategy.PACK);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(control.getDisplay().getSystemColor(25));
            this.setControl((Control)control);
        }

        String getBinName() {
            return this.fNameInput.getText();
        }

        void focusInput() {
            this.fNameInput.setFocus();
            this.fNameInput.selectAll();
        }

        IFolder getFolder() {
            return this.fFolderChooser.getFolder();
        }
    }
}

