/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.dialogs.SearchNewsDialog;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.SearchConditionList;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMarkDialog
extends TitleAreaDialog {
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.actions.NewSearchMarkAction";
    private Text fNameInput;
    private SearchConditionList fSearchConditionList;
    private Button fMatchAnyRadio;
    private Button fMatchAllRadio;
    private LocalResourceManager fResources;
    private IDialogSettings fDialogSettings;
    private boolean fFirstTimeOpen;
    private IFolder fParent;
    private IFolderChild fPosition;
    private ISearchCondition fInitialLocation;
    private List<ISearchCondition> fInitialSearchConditions;
    private boolean fInitialMatchAllConditions;
    private FolderChooser fFolderChooser;
    private LocationControl fLocationControl;
    private boolean fShowLocationConflict;
    private ISearchMark fCreatedSearchMark;
    private Map<String, Serializable> fProperties;

    public SearchMarkDialog(Shell shell, IFolder parent, IMark position) {
        this(shell, parent, (IFolderChild)position, null, true);
    }

    public SearchMarkDialog(Shell shell, IFolder parent, IFolderChild position, List<ISearchCondition> initialConditions, boolean matchAllConditions) {
        this(shell, parent, position, initialConditions, matchAllConditions, null);
    }

    public SearchMarkDialog(Shell shell, IFolder parent, IFolderChild position, List<ISearchCondition> initialConditions, boolean matchAllConditions, Map<String, Serializable> properties) {
        super(shell);
        this.fParent = parent;
        this.fPosition = position;
        this.fInitialMatchAllConditions = matchAllConditions;
        this.fProperties = properties;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fDialogSettings = Activator.getDefault().getDialogSettings();
        boolean bl = this.fFirstTimeOpen = this.fDialogSettings.getSection(SETTINGS_SECTION) == null;
        if (this.fParent == null) {
            this.fParent = this.getDefaultParent();
        }
        if (initialConditions != null) {
            Pair conditions = CoreUtils.splitScope(initialConditions);
            this.fInitialLocation = (ISearchCondition)conditions.getFirst();
            this.fInitialSearchConditions = (List)conditions.getSecond();
            this.fShowLocationConflict = CoreUtils.isLocationConflict(initialConditions);
        }
    }

    protected void okPressed() {
        if (this.fSearchConditionList.isEmpty()) {
            this.setErrorMessage(Messages.SearchMarkDialog_ERROR_MISSING_CONDITIONS);
            return;
        }
        this.fParent = this.fFolderChooser.getFolder();
        if (!StringUtils.isSet((String)this.fNameInput.getText())) {
            this.onGenerateName();
        }
        this.fCreatedSearchMark = Owl.getModelFactory().createSearchMark(null, this.fParent, this.fNameInput.getText(), this.fPosition, this.fPosition != null ? Boolean.valueOf(true) : null);
        this.fCreatedSearchMark.setMatchAllConditions(this.fMatchAllRadio.getSelection());
        this.fSearchConditionList.createConditions(this.fCreatedSearchMark);
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (locationCondition != null) {
            this.fCreatedSearchMark.addSearchCondition(locationCondition);
        }
        Map properties = this.fProperties != null ? this.fProperties : this.fParent.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            this.fCreatedSearchMark.setProperty((String)property.getKey(), (Serializable)property.getValue());
        }
        DynamicDAO.save((IPersistable)this.fParent);
        Controller.getDefault().getSavedSearchService().updateSavedSearches(Collections.singleton(this.fCreatedSearchMark), true);
        super.okPressed();
    }

    public ISearchMark getSearchMark() {
        return this.fCreatedSearchMark;
    }

    private IFolder getDefaultParent() {
        return OwlUI.getSelectedBookMarkSet();
    }

    public boolean close() {
        boolean res = super.close();
        this.fResources.dispose();
        return res;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings section = this.fDialogSettings.getSection(SETTINGS_SECTION);
        if (section != null) {
            return section;
        }
        return this.fDialogSettings.addNewSection(SETTINGS_SECTION);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.SearchMarkDialog_NEW_SAVED_SEARCH);
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x400;
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.SearchMarkDialog_SAVED_SEARCH);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/search.gif"));
        this.setMessage(Messages.SearchMarkDialog_SEARCH_HELP, 1);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5, 5, 5, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.SearchMarkDialog_NAME);
        Composite nameContainer = new Composite(container, 2048);
        nameContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        nameContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        nameContainer.setBackground(container.getDisplay().getSystemColor(25));
        this.fNameInput = new Text(nameContainer, 4);
        OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
        this.fNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fNameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchMarkDialog.this.setErrorMessage(null);
            }
        });
        ToolBar generateTitleBar = new ToolBar(nameContainer, 0x800000);
        OwlUI.makeAccessible((Control)generateTitleBar, Messages.SearchMarkDialog_CREATE_NAME_FROM_CONDITIONS);
        generateTitleBar.setBackground(container.getDisplay().getSystemColor(25));
        ToolItem generateTitleItem = new ToolItem(generateTitleBar, 8);
        generateTitleItem.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/info.gif"));
        generateTitleItem.setToolTipText(Messages.SearchMarkDialog_CREATE_NAME_FROM_CONDITIONS);
        generateTitleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMarkDialog.this.onGenerateName();
            }
        });
        Label folderLabel = new Label(container, 0);
        folderLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        folderLabel.setText(Messages.SearchMarkDialog_LOCATION);
        this.fFolderChooser = new FolderChooser(container, this.fParent, 2048, true);
        this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
        this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
        this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        Composite topControlsContainer = new Composite(container, 0);
        topControlsContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        topControlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(4, 5, 0));
        ((GridLayout)topControlsContainer.getLayout()).marginTop = 10;
        this.fMatchAllRadio = new Button(topControlsContainer, 16);
        this.fMatchAllRadio.setText(Messages.SearchMarkDialog_MATCH_ALL_CONDITIONS);
        this.fMatchAllRadio.setSelection(this.fInitialMatchAllConditions);
        this.fMatchAnyRadio = new Button(topControlsContainer, 16);
        this.fMatchAnyRadio.setText(Messages.SearchMarkDialog_MATCH_ANY_CONDITION);
        this.fMatchAnyRadio.setSelection(!this.fInitialMatchAllConditions);
        Label sep = new Label(topControlsContainer, 514);
        sep.setLayoutData((Object)new GridData(-1, 16));
        Composite scopeContainer = new Composite(topControlsContainer, 0);
        scopeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        scopeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        ((GridLayout)scopeContainer.getLayout()).marginLeft = 2;
        Label locationLabel = new Label(scopeContainer, 0);
        locationLabel.setText(Messages.SearchMarkDialog_SEARCH_IN);
        this.fLocationControl = new LocationControl(scopeContainer, 64){

            protected String getDefaultLabel() {
                return Messages.SearchMarkDialog_ALL_NEWS;
            }
        };
        this.fLocationControl.setLayoutData(new GridData(4, 0x1000000, true, true));
        ((GridData)this.fLocationControl.getLayoutData()).widthHint = 100;
        this.fLocationControl.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        if (this.fInitialLocation != null && this.fInitialLocation.getValue() instanceof Long[][]) {
            this.fLocationControl.select((Long[][])this.fInitialLocation.getValue());
        }
        Composite conditionsContainer = new Composite(container, 2048);
        conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2));
        conditionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        conditionsContainer.setBackgroundMode(2);
        if (this.fInitialSearchConditions == null) {
            this.fInitialSearchConditions = this.getDefaultConditions();
        }
        this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, this.fInitialSearchConditions);
        this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.fSearchConditionList.setVisibleItemCount(3);
        if (this.fInitialSearchConditions != null && !this.fInitialSearchConditions.isEmpty()) {
            this.onGenerateName();
        }
        if (this.fShowLocationConflict) {
            this.setMessage(Messages.SearchMarkDialog_LOCATION_WARNING, 2);
        }
        SearchMarkDialog.applyDialogFont((Control)container);
        return container;
    }

    void onGenerateName() {
        String name;
        List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (locationCondition != null) {
            conditions.add(locationCondition);
        }
        if ((name = CoreUtils.getName(conditions, (boolean)this.fMatchAllRadio.getSelection())).length() > 0) {
            this.fNameInput.setText(name);
            this.fNameInput.selectAll();
        }
    }

    private List<ISearchCondition> getDefaultConditions() {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(-1, INews.class.getName());
        ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)"");
        conditions.add(condition);
        return conditions;
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        Link previewLink = new Link(buttonBar, 0);
        previewLink.setText(Messages.SearchMarkDialog_PREVIEW_RESULTS);
        SearchMarkDialog.applyDialogFont((Control)previewLink);
        previewLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        previewLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMarkDialog.this.onPreview();
            }
        });
        Button okButton = this.createButton(buttonBar, 0, IDialogConstants.OK_LABEL, true);
        ((GridData)okButton.getLayoutData()).horizontalAlignment = 0x1000008;
        this.createButton(buttonBar, 1, IDialogConstants.CANCEL_LABEL, false);
        return buttonBar;
    }

    private void onPreview() {
        final List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
        if (!conditions.isEmpty()) {
            ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
            if (locationCondition != null) {
                conditions.add(locationCondition);
            }
            JobRunner.runInUIThread((Widget)this.getShell(), new Runnable(){

                public void run() {
                    SearchNewsDialog dialog = new SearchNewsDialog(SearchMarkDialog.this.getShell(), conditions, SearchMarkDialog.this.fMatchAllRadio.getSelection(), true);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                }
            });
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.fFirstTimeOpen) {
            Point requiredSize = this.getShell().computeSize(-1, -1);
            if (Application.IS_LINUX) {
                requiredSize.x += 100;
            } else if (Application.IS_MAC) {
                requiredSize.x += 50;
            }
            this.getShell().setSize(requiredSize);
            LayoutUtils.positionShell(this.getShell());
        }
    }
}

