/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.bookmark;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.bookmark.CreateBookmarkWizard;
import org.rssowl.ui.internal.dialogs.bookmark.Messages;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class BookmarkDefinitionPage
extends WizardPage {
    private Text fNameInput;
    private FolderChooser fFolderChooser;
    private final IFolder fSelectedFolder;

    String getBookmarkName() {
        return this.fNameInput.getText();
    }

    IFolder getFolder() {
        return this.fFolderChooser.getFolder();
    }

    public void presetBookmarkName(final String name) {
        JobRunner.runInUIThread((Widget)this.fNameInput, new Runnable(){

            public void run() {
                if (StringUtils.isSet((String)name)) {
                    BookmarkDefinitionPage.this.setMessage(Messages.BookmarkDefinitionPage_CREATE_BOOKMARK);
                    BookmarkDefinitionPage.this.fNameInput.setText(name);
                    BookmarkDefinitionPage.this.fNameInput.selectAll();
                } else {
                    BookmarkDefinitionPage.this.setMessage(Messages.BookmarkDefinitionPage_UNABLE_LOAD_TITLE, 2);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.fNameInput.getText().length() > 0;
    }

    protected BookmarkDefinitionPage(String pageName, IFolder selectedFolder) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/bkmrk_wiz.gif"));
        this.fSelectedFolder = selectedFolder;
        this.setMessage(Messages.BookmarkDefinitionPage_CREATE_BOOKMARK);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((CreateBookmarkWizard)this.getWizard()).loadNameFromFeed();
        }
        super.setVisible(visible);
        this.fNameInput.setFocus();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.BookmarkDefinitionPage_NAME);
        this.fNameInput = new Text(container, 2048);
        OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
        this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fNameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BookmarkDefinitionPage.this.getContainer().updateButtons();
            }
        });
        Composite labelContainer = new Composite(container, 0);
        labelContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 3));
        labelContainer.setLayoutData((Object)new GridData(1, 1, false, false));
        Label locationLabel = new Label(labelContainer, 0);
        locationLabel.setText(Messages.BookmarkDefinitionPage_LOCATION);
        this.fFolderChooser = new FolderChooser(container, this.fSelectedFolder, null, 2048, false, 5);
        this.fFolderChooser.setLayoutData(new GridData(4, 4, true, true));
        this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
        this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }
}

